/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.mrz;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.LayoutRes;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraOpenCallback;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.camera.ScanbotCameraView;
import io.scanbot.sdk.mrzscanner.MRZScanner;
import io.scanbot.sdk.mrzscanner.MRZScannerFrameHandler;
import io.scanbot.sdk.ui.base.databinding.ScanbotSdkCameraViewPermissionPlaceholderBinding;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.ui.mrz.R;
import io.scanbot.sdk.ui.mrz.databinding.ScanbotSdkMrzCameraViewBinding;
import io.scanbot.sdk.ui.utils.CheckableFrameLayout;
import io.scanbot.sdk.ui.utils.events.Signal;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.mrz.IMRZCameraView;
import io.scanbot.sdk.ui.view.mrz.MRZCameraView;
import io.scanbot.sdk.ui.view.mrz.MRZCameraView$WhenMappings;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 B2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001BB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020*H\u0015J\u001c\u0010+\u001a\u00020\u001e2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-H\u0016J\b\u00100\u001a\u00020(H\u0002J\b\u00101\u001a\u00020(H\u0014J\u0010\u00102\u001a\u00020(2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020(2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u00109\u001a\u00020(2\u0006\u0010:\u001a\u00020\u0014J\b\u0010;\u001a\u00020(H\u0002J\u0010\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020\u001eH\u0014J\u0010\u0010>\u001a\u00020(2\u0006\u0010?\u001a\u00020\u001eH\u0002J\u0010\u0010@\u001a\u00020(2\u0006\u0010A\u001a\u00020$H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lio/scanbot/sdk/ui/view/mrz/MRZCameraView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView;", "Lio/scanbot/sdk/mrzscanner/MRZScannerFrameHandler$ResultHandler;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cameraBinding", "Lio/scanbot/sdk/ui/mrz/databinding/ScanbotSdkMrzCameraViewBinding;", "getCameraBinding", "()Lio/scanbot/sdk/ui/mrz/databinding/ScanbotSdkMrzCameraViewBinding;", "setCameraBinding", "(Lio/scanbot/sdk/ui/mrz/databinding/ScanbotSdkMrzCameraViewBinding;)V", "cameraOpened", "Ljava/util/concurrent/atomic/AtomicBoolean;", "listener", "Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView$Listener;", "mrzScanner", "Lio/scanbot/sdk/mrzscanner/MRZScanner;", "mrzScannerFrameHandler", "Lio/scanbot/sdk/mrzscanner/MRZScannerFrameHandler;", "permissionBinding", "Lio/scanbot/sdk/ui/base/databinding/ScanbotSdkCameraViewPermissionPlaceholderBinding;", "getPermissionBinding", "()Lio/scanbot/sdk/ui/base/databinding/ScanbotSdkCameraViewPermissionPlaceholderBinding;", "setPermissionBinding", "(Lio/scanbot/sdk/ui/base/databinding/ScanbotSdkCameraViewPermissionPlaceholderBinding;)V", "singleCodeScanningMode", "", "getSingleCodeScanningMode", "()Z", "setSingleCodeScanningMode", "(Z)V", "state", "Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView$State;", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "closeCamera", "", "getLayoutRes", "", "handle", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/mrzscanner/model/MRZRecognitionResult;", "Lio/scanbot/sdk/SdkLicenseError;", "initCameraView", "onDetachedFromWindow", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraOrientationMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setListener", "setMrzScanner", "scanner", "subscribeViews", "updateCameraPermissionView", "cameraPermissionGranted", "updateFlashState", "flash", "updateState", "newState", "Companion", "rtu-ui-mrz_release"})
public class MRZCameraView
extends FrameLayout
implements IMRZCameraView,
MRZScannerFrameHandler.ResultHandler {
    private IMRZCameraView.State state;
    private IMRZCameraView.Listener listener;
    private MRZScanner mrzScanner;
    private MRZScannerFrameHandler mrzScannerFrameHandler;
    private final AtomicBoolean cameraOpened;
    private final CompositeDisposable subscriptions;
    private boolean singleCodeScanningMode;
    @NotNull
    private ScanbotSdkCameraViewPermissionPlaceholderBinding permissionBinding;
    @NotNull
    private ScanbotSdkMrzCameraViewBinding cameraBinding;
    private static final long CAMERA_OPENED_DELAY_MILLIS = 300L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean getSingleCodeScanningMode() {
        return this.singleCodeScanningMode;
    }

    public final void setSingleCodeScanningMode(boolean bl) {
        this.singleCodeScanningMode = bl;
    }

    @NotNull
    public final ScanbotSdkCameraViewPermissionPlaceholderBinding getPermissionBinding() {
        return this.permissionBinding;
    }

    public final void setPermissionBinding(@NotNull ScanbotSdkCameraViewPermissionPlaceholderBinding scanbotSdkCameraViewPermissionPlaceholderBinding) {
        Intrinsics.checkNotNullParameter((Object)scanbotSdkCameraViewPermissionPlaceholderBinding, (String)"<set-?>");
        this.permissionBinding = scanbotSdkCameraViewPermissionPlaceholderBinding;
    }

    @NotNull
    public final ScanbotSdkMrzCameraViewBinding getCameraBinding() {
        return this.cameraBinding;
    }

    public final void setCameraBinding(@NotNull ScanbotSdkMrzCameraViewBinding scanbotSdkMrzCameraViewBinding) {
        Intrinsics.checkNotNullParameter((Object)scanbotSdkMrzCameraViewBinding, (String)"<set-?>");
        this.cameraBinding = scanbotSdkMrzCameraViewBinding;
    }

    @LayoutRes
    protected int getLayoutRes() {
        return R.layout.scanbot_sdk_mrz_camera_view;
    }

    public final void setMrzScanner(@NotNull MRZScanner scanner) {
        Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
        this.mrzScanner = scanner;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.closeCamera();
    }

    @Override
    public void setListener(@NotNull IMRZCameraView.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    public void updateState(@NotNull IMRZCameraView.State newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.state = newState;
        this.subscribeViews();
    }

    public boolean handle(@NotNull FrameHandlerResult<MRZRecognitionResult, SdkLicenseError> result) {
        block3: {
            FrameHandlerResult<MRZRecognitionResult, SdkLicenseError> frameHandlerResult;
            Intrinsics.checkNotNullParameter(result, (String)"result");
            this.listener.mrzCodeScanned(result);
            if (!this.singleCodeScanningMode || !((frameHandlerResult = result) instanceof FrameHandlerResult.Success)) break block3;
            MRZRecognitionResult mRZRecognitionResult = (MRZRecognitionResult)((FrameHandlerResult.Success)result).getValue();
            if (mRZRecognitionResult != null) {
                MRZRecognitionResult mRZRecognitionResult2 = mRZRecognitionResult;
                boolean bl = false;
                boolean bl2 = false;
                MRZRecognitionResult it = mRZRecognitionResult2;
                boolean bl3 = false;
                if (it.recognitionSuccessful) {
                    MRZScannerFrameHandler mRZScannerFrameHandler = this.mrzScannerFrameHandler;
                    if (mRZScannerFrameHandler == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mrzScannerFrameHandler");
                    }
                    mRZScannerFrameHandler.setEnabled(false);
                }
            }
        }
        return false;
    }

    @Override
    public void setCameraOrientationMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        switch (MRZCameraView$WhenMappings.$EnumSwitchMapping$0[cameraOrientationMode.ordinal()]) {
            case 1: {
                this.cameraBinding.scanbotCameraView.lockToPortrait(true);
                break;
            }
            case 2: {
                this.cameraBinding.scanbotCameraView.lockToLandscape(true);
                break;
            }
        }
    }

    @Override
    public void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.cameraBinding.scanbotCameraView.setCameraModule(cameraModule);
    }

    private final void closeCamera() {
        this.cameraOpened.set(false);
        this.cameraBinding.scanbotCameraView.onPause();
        this.subscriptions.clear();
    }

    private final void initCameraView() {
        this.cameraBinding.scanbotCameraView.setPreviewMode(CameraPreviewMode.FILL_IN);
        this.cameraBinding.scanbotCameraView.setCameraOpenCallback(new CameraOpenCallback(this){
            final /* synthetic */ MRZCameraView this$0;

            public void onCameraOpened() {
                MRZCameraView.access$getCameraOpened$p(this.this$0).set(true);
                this.this$0.getCameraBinding().scanbotCameraView.postDelayed(new Runnable(this){
                    final /* synthetic */ initCameraView.1 this$0;

                    public final void run() {
                        MRZScanner mRZScanner = MRZCameraView.access$getMrzScanner$p(this.this$0.this$0);
                        if (mRZScanner != null) {
                            MRZScanner mRZScanner2 = mRZScanner;
                            boolean bl = false;
                            boolean bl2 = false;
                            MRZScanner it = mRZScanner2;
                            boolean bl3 = false;
                            MRZCameraView mRZCameraView = this.this$0.this$0;
                            ScanbotCameraView scanbotCameraView = this.this$0.this$0.getCameraBinding().scanbotCameraView;
                            Intrinsics.checkNotNullExpressionValue((Object)scanbotCameraView, (String)"cameraBinding.scanbotCameraView");
                            MRZCameraView.access$setMrzScannerFrameHandler$p(mRZCameraView, MRZScannerFrameHandler.Companion.attach((IScanbotCameraView)scanbotCameraView, it));
                            MRZCameraView.access$getMrzScannerFrameHandler$p(this.this$0.this$0).addResultHandler((MRZScannerFrameHandler.ResultHandler)this.this$0.this$0);
                        }
                        this.this$0.this$0.getCameraBinding().scanbotCameraView.setShutterSound(false);
                        this.this$0.this$0.getCameraBinding().scanbotCameraView.continuousFocus();
                        ScanbotCameraView scanbotCameraView = this.this$0.this$0.getCameraBinding().scanbotCameraView;
                        Object object = MRZCameraView.access$getState$p(this.this$0.this$0).getFlash().getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this@MRZCameraView.state.flash.value");
                        scanbotCameraView.useFlash(((Boolean)object).booleanValue());
                        MRZCameraView.access$getListener$p(this.this$0.this$0).onCameraOpened();
                        MRZCameraView.access$getSubscriptions$p(this.this$0.this$0).add(MRZCameraView.access$getState$p(this.this$0.this$0).getFlash().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(this){
                            final /* synthetic */ initCameraView.onCameraOpened.1 this$0;

                            public final void accept(Boolean flash) {
                                MRZCameraView mRZCameraView = this.this$0.this$0.this$0;
                                Boolean bl = flash;
                                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"flash");
                                MRZCameraView.access$updateFlashState(mRZCameraView, bl);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, 300L);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void subscribeViews() {
        this.subscriptions.add(this.state.getCameraPermissionGranted().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ MRZCameraView this$0;

            public final void accept(Boolean granted) {
                Boolean bl = granted;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"granted");
                if (bl.booleanValue()) {
                    this.this$0.getCameraBinding().scanbotCameraView.onResume();
                }
                this.this$0.updateCameraPermissionView(granted);
            }
            {
                this.this$0 = mRZCameraView;
            }
        }));
        this.subscriptions.add(this.state.getCameraClosed().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Signal>(this){
            final /* synthetic */ MRZCameraView this$0;

            public final void accept(Signal it) {
                MRZCameraView.access$closeCamera(this.this$0);
            }
            {
                this.this$0 = mRZCameraView;
            }
        }));
    }

    protected void updateCameraPermissionView(boolean cameraPermissionGranted) {
        if (cameraPermissionGranted) {
            LinearLayout linearLayout = this.permissionBinding.cameraPermissionView;
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"permissionBinding.cameraPermissionView");
            linearLayout.setVisibility(8);
        } else {
            LinearLayout linearLayout = this.permissionBinding.cameraPermissionView;
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"permissionBinding.cameraPermissionView");
            linearLayout.setVisibility(0);
        }
    }

    private final void updateFlashState(boolean flash) {
        if (this.cameraOpened.get()) {
            CheckableFrameLayout checkableFrameLayout = this.cameraBinding.flashBtn;
            if (checkableFrameLayout == null) {
                throw new NullPointerException("null cannot be cast to non-null type io.scanbot.sdk.ui.utils.CheckableFrameLayout");
            }
            checkableFrameLayout.setChecked(flash);
            this.cameraBinding.scanbotCameraView.useFlash(flash);
        }
    }

    public MRZCameraView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.state = IMRZCameraView.State.Companion.getDEFAULT();
        this.listener = IMRZCameraView.Listener.Companion.getNULL();
        this.cameraOpened = new AtomicBoolean(false);
        this.subscriptions = new CompositeDisposable();
        this.singleCodeScanningMode = true;
        View view = LayoutInflater.from((Context)context).inflate(this.getLayoutRes(), (ViewGroup)this, true);
        ScanbotSdkMrzCameraViewBinding scanbotSdkMrzCameraViewBinding = ScanbotSdkMrzCameraViewBinding.bind(view.findViewById(R.id.cameraRootLayout));
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkMrzCameraViewBinding, (String)"ScanbotSdkMrzCameraViewB\u2026d(R.id.cameraRootLayout))");
        this.cameraBinding = scanbotSdkMrzCameraViewBinding;
        ScanbotSdkCameraViewPermissionPlaceholderBinding scanbotSdkCameraViewPermissionPlaceholderBinding = this.cameraBinding.cameraPermissionView;
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkCameraViewPermissionPlaceholderBinding, (String)"cameraBinding.cameraPermissionView");
        this.permissionBinding = scanbotSdkCameraViewPermissionPlaceholderBinding;
        ScanbotSdkMrzCameraViewBinding scanbotSdkMrzCameraViewBinding2 = this.cameraBinding;
        boolean bl = false;
        boolean bl2 = false;
        ScanbotSdkMrzCameraViewBinding $this$apply = scanbotSdkMrzCameraViewBinding2;
        boolean bl3 = false;
        $this$apply.cancelBtn.setOnClickListener(new View.OnClickListener(this, context){
            final /* synthetic */ MRZCameraView this$0;
            final /* synthetic */ Context $context$inlined;
            {
                this.this$0 = mRZCameraView;
                this.$context$inlined = context;
            }

            public final void onClick(View it) {
                MRZCameraView.access$getListener$p(this.this$0).onCancelClicked();
            }
        });
        $this$apply.flashBtn.setOnClickListener(new View.OnClickListener(this, context){
            final /* synthetic */ MRZCameraView this$0;
            final /* synthetic */ Context $context$inlined;
            {
                this.this$0 = mRZCameraView;
                this.$context$inlined = context;
            }

            public final void onClick(View it) {
                MRZCameraView.access$getListener$p(this.this$0).onFlashClicked();
            }
        });
        boolean hasFlash = context.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
        CheckableFrameLayout checkableFrameLayout = $this$apply.flashBtn;
        Intrinsics.checkNotNullExpressionValue((Object)checkableFrameLayout, (String)"flashBtn");
        checkableFrameLayout.setVisibility(hasFlash ? 0 : 4);
        this.permissionBinding.enableCameraBtn.setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.onActivateCameraPermission();
            }
        });
        this.initCameraView();
    }

    public static final /* synthetic */ AtomicBoolean access$getCameraOpened$p(MRZCameraView $this) {
        return $this.cameraOpened;
    }

    public static final /* synthetic */ MRZScanner access$getMrzScanner$p(MRZCameraView $this) {
        return $this.mrzScanner;
    }

    public static final /* synthetic */ void access$setMrzScanner$p(MRZCameraView $this, MRZScanner mRZScanner) {
        $this.mrzScanner = mRZScanner;
    }

    public static final /* synthetic */ MRZScannerFrameHandler access$getMrzScannerFrameHandler$p(MRZCameraView $this) {
        MRZScannerFrameHandler mRZScannerFrameHandler = $this.mrzScannerFrameHandler;
        if (mRZScannerFrameHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mrzScannerFrameHandler");
        }
        return mRZScannerFrameHandler;
    }

    public static final /* synthetic */ void access$setMrzScannerFrameHandler$p(MRZCameraView $this, MRZScannerFrameHandler mRZScannerFrameHandler) {
        $this.mrzScannerFrameHandler = mRZScannerFrameHandler;
    }

    public static final /* synthetic */ IMRZCameraView.State access$getState$p(MRZCameraView $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(MRZCameraView $this, IMRZCameraView.State state) {
        $this.state = state;
    }

    public static final /* synthetic */ void access$setListener$p(MRZCameraView $this, IMRZCameraView.Listener listener) {
        $this.listener = listener;
    }

    public static final /* synthetic */ CompositeDisposable access$getSubscriptions$p(MRZCameraView $this) {
        return $this.subscriptions;
    }

    public static final /* synthetic */ void access$updateFlashState(MRZCameraView $this, boolean flash) {
        $this.updateFlashState(flash);
    }

    public static final /* synthetic */ void access$closeCamera(MRZCameraView $this) {
        $this.closeCamera();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/ui/view/mrz/MRZCameraView$Companion;", "", "()V", "CAMERA_OPENED_DELAY_MILLIS", "", "rtu-ui-mrz_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

