/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.nfc;

import android.graphics.Bitmap;
import android.net.Uri;
import android.nfc.Tag;
import androidx.annotation.Nullable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.reactivex.processors.BehaviorProcessor;
import io.scanbot.mrzscanner.model.MRZField;
import io.scanbot.mrzscanner.model.MRZFieldName;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.nfcscanner.passport.NFCDatagroupDG1FieldName;
import io.scanbot.nfcscanner.passport.NFCDatagroupDG2FieldName;
import io.scanbot.nfcscanner.passport.PassportNfcData;
import io.scanbot.nfcscanner.passport.PassportNfcDg1DataItem;
import io.scanbot.nfcscanner.passport.PassportNfcDg2DataItem;
import io.scanbot.nfcscanner.passport.PassportNfcLoadErrorType;
import io.scanbot.sdk.nfcscanner.passport.PassportNfcKey;
import io.scanbot.sdk.ui.di.BackgroundTaskScheduler;
import io.scanbot.sdk.ui.utils.CrossViewStatePresenter;
import io.scanbot.sdk.ui.utils.StatelessView;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.mrz.MrzScanningSession;
import io.scanbot.sdk.ui.view.nfc.INfcPassportView;
import io.scanbot.sdk.ui.view.nfc.NfcPassportPresenter$WhenMappings;
import io.scanbot.sdk.ui.view.nfc.NfcPassportPresenter$sam$i$io_reactivex_functions_Consumer$0;
import io.scanbot.sdk.ui.view.nfc.NfcPassportPresenter$sam$io_reactivex_functions_Consumer$0;
import io.scanbot.sdk.ui.view.nfc.PassportPhotoSaveCallback;
import io.scanbot.sdk.ui.view.nfc.entity.Dg1ScanningResult;
import io.scanbot.sdk.ui.view.nfc.entity.Dg2ScanningResult;
import io.scanbot.sdk.ui.view.nfc.entity.NfcPassportScanningResult;
import io.scanbot.sdk.ui.view.nfc.interactor.CheckNfcStateUseCase;
import io.scanbot.sdk.ui.view.nfc.interactor.NfcPassportException;
import io.scanbot.sdk.ui.view.nfc.interactor.NfcState;
import io.scanbot.sdk.ui.view.nfc.interactor.ProcessNfcTagUseCase;
import io.scanbot.sdk.ui.view.nfc.interactor.SaveNfcPassportImageUseCase;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0002<=BE\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u001f\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020%H\u0002\u00a2\u0006\u0002\u0010&J\u001a\u0010'\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020 2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\b\u0010+\u001a\u00020\u001cH\u0016J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.H\u0002J\u0012\u0010/\u001a\u00020\u001c2\b\u00100\u001a\u0004\u0018\u000101H\u0002J\u000e\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u000204J\u0010\u00105\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u0003H\u0016J\b\u00108\u001a\u00020\u001cH\u0016J\u000e\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\u0017J\b\u0010;\u001a\u00020\u001cH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lio/scanbot/sdk/ui/view/nfc/NfcPassportPresenter;", "Lio/scanbot/sdk/ui/utils/CrossViewStatePresenter;", "Lio/scanbot/sdk/ui/view/nfc/INfcPassportView$State;", "Lio/scanbot/sdk/ui/view/nfc/INfcPassportView;", "Lio/scanbot/sdk/ui/view/nfc/INfcPassportView$Listener;", "navigator", "Lio/scanbot/sdk/ui/utils/navigator/Navigator;", "backgroundTaskScheduler", "Lio/reactivex/Scheduler;", "checkNfcStateUseCase", "Lio/scanbot/sdk/ui/view/nfc/interactor/CheckNfcStateUseCase;", "processNfcTagUseCase", "Lio/scanbot/sdk/ui/view/nfc/interactor/ProcessNfcTagUseCase;", "saveNfcPassportImageUseCase", "Lio/scanbot/sdk/ui/view/nfc/interactor/SaveNfcPassportImageUseCase;", "passportPhotoSaveCallback", "Lio/scanbot/sdk/ui/view/nfc/PassportPhotoSaveCallback;", "mrzScanningSession", "Lio/scanbot/sdk/ui/view/mrz/MrzScanningSession;", "(Lio/scanbot/sdk/ui/utils/navigator/Navigator;Lio/reactivex/Scheduler;Lio/scanbot/sdk/ui/view/nfc/interactor/CheckNfcStateUseCase;Lio/scanbot/sdk/ui/view/nfc/interactor/ProcessNfcTagUseCase;Lio/scanbot/sdk/ui/view/nfc/interactor/SaveNfcPassportImageUseCase;Lio/scanbot/sdk/ui/view/nfc/PassportPhotoSaveCallback;Lio/scanbot/sdk/ui/view/mrz/MrzScanningSession;)V", "inputDateFormat", "Ljava/text/SimpleDateFormat;", "savePhotoImageAllowed", "", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "back", "backPressed", "", "getDg1Item", "", "passportNfcData", "Lio/scanbot/nfcscanner/passport/PassportNfcData;", "type", "Lio/scanbot/nfcscanner/passport/NFCDatagroupDG1FieldName;", "getDg2Item", "", "Lio/scanbot/nfcscanner/passport/NFCDatagroupDG2FieldName;", "(Lio/scanbot/nfcscanner/passport/PassportNfcData;Lio/scanbot/nfcscanner/passport/NFCDatagroupDG2FieldName;)Ljava/lang/Integer;", "mapResult", "Lio/scanbot/sdk/ui/view/nfc/entity/NfcPassportScanningResult;", "photoImageUri", "Landroid/net/Uri;", "pause", "processMrzResult", "recognitionResult", "Lio/scanbot/mrzscanner/model/MRZRecognitionResult;", "processNfcError", "throwable", "", "processNfcTag", "tag", "Landroid/nfc/Tag;", "processPassportNfcData", "resume", "view", "retryClicked", "setSavePhotoImageAllowed", "allowed", "updateNfcState", "MrzProcessed", "NfcScanned", "rtu-ui-nfc_release"})
public final class NfcPassportPresenter
extends CrossViewStatePresenter<INfcPassportView.State, INfcPassportView>
implements INfcPassportView.Listener {
    private final SimpleDateFormat inputDateFormat;
    private final CompositeDisposable subscriptions;
    private boolean savePhotoImageAllowed;
    private final Navigator navigator;
    private final Scheduler backgroundTaskScheduler;
    private final CheckNfcStateUseCase checkNfcStateUseCase;
    private final ProcessNfcTagUseCase processNfcTagUseCase;
    private final SaveNfcPassportImageUseCase saveNfcPassportImageUseCase;
    private final PassportPhotoSaveCallback passportPhotoSaveCallback;
    private final MrzScanningSession mrzScanningSession;

    public void resume(@NotNull INfcPassportView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.resume((StatelessView)view);
        view.setListener(this);
        if (this.getState() == null) {
            this.updateState(INfcPassportView.State.Companion.getDEFAULT());
        }
        Function1 function1 = (Function1)new Function1<MRZRecognitionResult, Unit>(this){

            public final void invoke(@NotNull MRZRecognitionResult p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                NfcPassportPresenter.access$processMrzResult((NfcPassportPresenter)this.receiver, p1);
            }
        };
        this.subscriptions.add(this.mrzScanningSession.observeMrzScanningResults().subscribe((Consumer)new NfcPassportPresenter$sam$io_reactivex_functions_Consumer$0(function1)));
        this.updateNfcState();
    }

    private final void processMrzResult(MRZRecognitionResult recognitionResult) {
        block10: {
            INfcPassportView.State state = (INfcPassportView.State)this.getState();
            if (state == null) break block10;
            INfcPassportView.State state2 = state;
            boolean bl = false;
            boolean bl2 = false;
            INfcPassportView.State state3 = state2;
            boolean bl3 = false;
            if ((INfcPassportView.NfcScanStep)((Object)state3.getStep().getValue()) == INfcPassportView.NfcScanStep.MRZ) {
                String expiryDate;
                Object v5;
                String birthDate;
                String documentCode;
                block9: {
                    Object v3;
                    block8: {
                        Object v1;
                        block7: {
                            Iterable iterable = recognitionResult.fields;
                            boolean bl4 = false;
                            Iterable iterable2 = iterable;
                            boolean bl5 = false;
                            for (Object object : iterable2) {
                                MRZField it = (MRZField)object;
                                boolean bl6 = false;
                                if (!(it.name == MRZFieldName.DocumentCode)) continue;
                                v1 = object;
                                break block7;
                            }
                            v1 = null;
                        }
                        MRZField mRZField = v1;
                        documentCode = mRZField != null ? mRZField.value : null;
                        Iterable iterable = recognitionResult.fields;
                        boolean bl7 = false;
                        Iterable iterable3 = iterable;
                        boolean bl8 = false;
                        for (Object object : iterable3) {
                            MRZField it = (MRZField)object;
                            boolean bl9 = false;
                            if (!(it.name == MRZFieldName.DateOfBirth)) continue;
                            v3 = object;
                            break block8;
                        }
                        v3 = null;
                    }
                    MRZField mRZField = v3;
                    birthDate = mRZField != null ? mRZField.value : null;
                    Iterable iterable = recognitionResult.fields;
                    boolean bl10 = false;
                    Iterable iterable4 = iterable;
                    boolean bl11 = false;
                    for (Object e : iterable4) {
                        MRZField it = (MRZField)e;
                        boolean bl12 = false;
                        if (!(it.name == MRZFieldName.DateOfExpiry)) continue;
                        v5 = e;
                        break block9;
                    }
                    v5 = null;
                }
                MRZField mRZField = v5;
                String string = expiryDate = mRZField != null ? mRZField.value : null;
                if (documentCode != null && birthDate != null && expiryDate != null) {
                    try {
                        Date date = this.inputDateFormat.parse(birthDate);
                        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"inputDateFormat.parse(birthDate)");
                        Date date2 = this.inputDateFormat.parse(expiryDate);
                        Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"inputDateFormat.parse(expiryDate)");
                        PassportNfcKey nfcKey = new PassportNfcKey(documentCode, date, date2);
                        state3.getStep().onNext((Object)INfcPassportView.NfcScanStep.NFC_READY);
                        state3.getNfcKey().onNext((Object)nfcKey);
                        this.navigator.navigate((Object)new MrzProcessed(recognitionResult));
                    }
                    catch (ParseException parseException) {
                    }
                }
            }
        }
    }

    public void pause() {
        super.pause();
        this.subscriptions.clear();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void retryClicked() {
        block3: {
            v0 = (INfcPassportView.State)this.getState();
            if (v0 == null) break block3;
            var1_1 = v0;
            var2_2 = false;
            var3_3 = false;
            state = var1_1;
            $i$a$-let-NfcPassportPresenter$retryClicked$1 = false;
            v1 = state.getStep();
            v2 = (INfcPassportView.NfcScanStep)state.getStep().getValue();
            if (v2 == null) ** GOTO lbl-1000
            switch (NfcPassportPresenter$WhenMappings.$EnumSwitchMapping$0[v2.ordinal()]) {
                case 1: 
                case 2: {
                    v3 = INfcPassportView.NfcScanStep.MRZ;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v3 = INfcPassportView.NfcScanStep.NFC_READY;
                }
            }
            v1.onNext((Object)v3);
            this.updateNfcState();
        }
    }

    private final void updateNfcState() {
        this.subscriptions.add(this.checkNfcStateUseCase.checkNfcState().subscribeOn(this.backgroundTaskScheduler).subscribe((Consumer)new Consumer<NfcState>(this){
            final /* synthetic */ NfcPassportPresenter this$0;

            public final void accept(NfcState nfcState) {
                block0: {
                    BehaviorProcessor<NfcState> behaviorProcessor = NfcPassportPresenter.access$getState$p(this.this$0);
                    if (behaviorProcessor == null || (behaviorProcessor = behaviorProcessor.getNfcState()) == null) break block0;
                    behaviorProcessor.onNext((Object)((Object)nfcState));
                }
            }
            {
                this.this$0 = nfcPassportPresenter;
            }
        }));
    }

    public boolean back() {
        BehaviorProcessor<INfcPassportView.NfcScanStep> behaviorProcessor = (BehaviorProcessor<INfcPassportView.NfcScanStep>)this.getState();
        if ((behaviorProcessor != null && (behaviorProcessor = behaviorProcessor.getStep()) != null ? (INfcPassportView.NfcScanStep)((Object)behaviorProcessor.getValue()) : null) != INfcPassportView.NfcScanStep.MRZ) {
            BehaviorProcessor<INfcPassportView.NfcScanStep> behaviorProcessor2 = (BehaviorProcessor<INfcPassportView.NfcScanStep>)this.getState();
            if (behaviorProcessor2 != null && (behaviorProcessor2 = behaviorProcessor2.getStep()) != null) {
                behaviorProcessor2.onNext((Object)INfcPassportView.NfcScanStep.MRZ);
            }
        } else {
            this.navigator.navigate((Object)"NAVIGATE_CANCEL_SNAPPING");
        }
        return true;
    }

    @Override
    public void backPressed() {
        this.back();
    }

    public final void processNfcTag(@NotNull Tag tag) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            INfcPassportView.State state = (INfcPassportView.State)this.getState();
            if (state == null) break block2;
            INfcPassportView.State state2 = state;
            boolean bl = false;
            boolean bl2 = false;
            INfcPassportView.State state3 = state2;
            boolean bl3 = false;
            INfcPassportView.NfcScanStep currentStep = (INfcPassportView.NfcScanStep)((Object)state3.getStep().getValue());
            if (currentStep == INfcPassportView.NfcScanStep.NFC_READY || currentStep == INfcPassportView.NfcScanStep.ERROR) {
                PassportNfcKey passportNfcKey = (PassportNfcKey)state3.getNfcKey().getValue();
                if (passportNfcKey != null) {
                    PassportNfcKey passportNfcKey2 = passportNfcKey;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    PassportNfcKey key = passportNfcKey2;
                    boolean bl6 = false;
                    state3.getStep().onNext((Object)INfcPassportView.NfcScanStep.LOADING_DATA);
                    Function1 function1 = (Function1)new Function1<PassportNfcData, Unit>(this){

                        public final void invoke(@NotNull PassportNfcData p1) {
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            NfcPassportPresenter.access$processPassportNfcData((NfcPassportPresenter)this.receiver, p1);
                        }
                    };
                    NfcPassportPresenter$sam$i$io_reactivex_functions_Consumer$0 nfcPassportPresenter$sam$i$io_reactivex_functions_Consumer$0 = new NfcPassportPresenter$sam$i$io_reactivex_functions_Consumer$0(function1);
                    function1 = (Function1)new Function1<Throwable, Unit>(this){

                        public final void invoke(@org.jetbrains.annotations.Nullable Throwable p1) {
                            NfcPassportPresenter.access$processNfcError((NfcPassportPresenter)this.receiver, p1);
                        }
                    };
                    this.subscriptions.add(this.processNfcTagUseCase.extract(tag, key).subscribeOn(this.backgroundTaskScheduler).subscribe((Consumer)nfcPassportPresenter$sam$i$io_reactivex_functions_Consumer$0, (Consumer)new NfcPassportPresenter$sam$i$io_reactivex_functions_Consumer$0(function1)));
                }
            }
        }
    }

    private final void processPassportNfcData(PassportNfcData passportNfcData) {
        Bitmap photoImage = passportNfcData.getDg2Image();
        PassportPhotoSaveCallback passportPhotoSaveCallback = this.passportPhotoSaveCallback;
        if (passportPhotoSaveCallback != null) {
            passportPhotoSaveCallback.onImageRetrieved(photoImage);
        }
        if (photoImage != null && this.savePhotoImageAllowed) {
            this.subscriptions.add(this.saveNfcPassportImageUseCase.saveNfcPassportImage(photoImage).subscribe((Consumer)new Consumer<Uri>(this, passportNfcData){
                final /* synthetic */ NfcPassportPresenter this$0;
                final /* synthetic */ PassportNfcData $passportNfcData;

                public final void accept(Uri imageUri) {
                    NfcPassportPresenter.access$getNavigator$p(this.this$0).navigate((Object)new NfcScanned(NfcPassportPresenter.access$mapResult(this.this$0, this.$passportNfcData, imageUri)));
                }
                {
                    this.this$0 = nfcPassportPresenter;
                    this.$passportNfcData = passportNfcData;
                }
            }, (Consumer)new Consumer<Throwable>(this){
                final /* synthetic */ NfcPassportPresenter this$0;

                public final void accept(Throwable it) {
                    NfcPassportPresenter.access$processNfcError(this.this$0, it);
                }
                {
                    this.this$0 = nfcPassportPresenter;
                }
            }));
        } else {
            this.navigator.navigate((Object)new NfcScanned(this.mapResult(passportNfcData, null)));
        }
    }

    private final NfcPassportScanningResult mapResult(PassportNfcData passportNfcData, Uri photoImageUri) {
        Integer n;
        Integer n2;
        Integer n3;
        boolean bl;
        String string;
        String string2 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.DocumentType);
        String string3 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.IssuingStateOrOrganization);
        String string4 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.DocumentNumber);
        String string5 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.CheckDigitDocNumber);
        if (string5 != null) {
            string = string5;
            bl = false;
            n3 = Integer.parseInt(string);
        } else {
            n3 = null;
        }
        String string6 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.OptionalData);
        String string7 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.OptionalData2);
        String string8 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.DateOfBirth6Digit);
        String string9 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.CheckDigitDateOfBirth);
        String string10 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.Sex);
        String string11 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.DateOfExpiry);
        String string12 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.CheckDigitExpiryDate);
        String string13 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.Nationality);
        String string14 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.CheckDigitComposite);
        if (string14 != null) {
            string = string14;
            bl = false;
            n2 = Integer.parseInt(string);
        } else {
            n2 = null;
        }
        String string15 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.NameOfDocumentHolder);
        String string16 = this.getDg1Item(passportNfcData, NFCDatagroupDG1FieldName.CheckDigitOptionalData);
        if (string16 != null) {
            string = string16;
            bl = false;
            n = Integer.parseInt(string);
        } else {
            n = null;
        }
        Dg1ScanningResult dg1Group = new Dg1ScanningResult(string2, string3, string4, n3, string6, string7, string8, string9, string10, string11, string12, string13, n2, string15, n);
        Dg2ScanningResult dg2Group = new Dg2ScanningResult(this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.NumberOfImages), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.Version), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.LengthOfRecord), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.NumberOfFacialImages), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.FacialRecordDataLength), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.NumberOfFeaturePoints), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.Gender), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.EyeColor), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.HairColor), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.FeatureMask), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.Expression), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.PoseAngle), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.PoseAngleUncertainty), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.FaceImageType), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.ImageDataType), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.ImageWidth), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.ImageHeight), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.ImageColorspace), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.SourceType), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.DeviceType), this.getDg2Item(passportNfcData, NFCDatagroupDG2FieldName.Quality));
        return new NfcPassportScanningResult(dg1Group, dg2Group, photoImageUri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getDg1Item(PassportNfcData passportNfcData, NFCDatagroupDG1FieldName type) {
        PassportNfcDg1DataItem element$iv;
        PassportNfcDg1DataItem[] passportNfcDg1DataItemArray;
        block2: {
            PassportNfcDg1DataItem[] passportNfcDg1DataItemArray2 = passportNfcData.getDg1Data();
            passportNfcDg1DataItemArray = passportNfcDg1DataItemArray2;
            if (passportNfcDg1DataItemArray2 == null) return null;
            PassportNfcDg1DataItem[] $this$firstOrNull$iv = passportNfcDg1DataItemArray;
            boolean $i$f$firstOrNull = false;
            PassportNfcDg1DataItem[] passportNfcDg1DataItemArray3 = $this$firstOrNull$iv;
            int n = passportNfcDg1DataItemArray3.length;
            int n2 = 0;
            while (n2 < n) {
                PassportNfcDg1DataItem it = element$iv = passportNfcDg1DataItemArray3[n2];
                boolean bl = false;
                if (!(it.getKey() == type)) {
                    ++n2;
                    continue;
                }
                break block2;
            }
            return null;
        }
        PassportNfcDg1DataItem passportNfcDg1DataItem = element$iv;
        passportNfcDg1DataItemArray = passportNfcDg1DataItem;
        if (passportNfcDg1DataItem == null) return null;
        String string = passportNfcDg1DataItemArray.getValue();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Integer getDg2Item(PassportNfcData passportNfcData, NFCDatagroupDG2FieldName type) {
        PassportNfcDg2DataItem element$iv;
        Object object;
        block2: {
            PassportNfcDg2DataItem[] passportNfcDg2DataItemArray = passportNfcData.getDg2Data();
            object = passportNfcDg2DataItemArray;
            if (passportNfcDg2DataItemArray == null) return null;
            PassportNfcDg2DataItem[] passportNfcDg2DataItemArray2 = object;
            boolean $i$f$firstOrNull = false;
            PassportNfcDg2DataItem[] passportNfcDg2DataItemArray3 = passportNfcDg2DataItemArray2;
            int n = passportNfcDg2DataItemArray3.length;
            int n2 = 0;
            while (n2 < n) {
                PassportNfcDg2DataItem it = element$iv = passportNfcDg2DataItemArray3[n2];
                boolean bl = false;
                if (!(it.getKey() == type)) {
                    ++n2;
                    continue;
                }
                break block2;
            }
            return null;
        }
        PassportNfcDg2DataItem passportNfcDg2DataItem = element$iv;
        object = passportNfcDg2DataItem;
        if (passportNfcDg2DataItem == null) return null;
        String string = object.getValue();
        object = string;
        if (string == null) return null;
        Object object2 = object;
        boolean bl = false;
        Integer n = Integer.parseInt((String)object2);
        return n;
    }

    private final void processNfcError(Throwable throwable) {
        block1: {
            block2: {
                block0: {
                    LoggerProvider.getLogger().logException(throwable);
                    if (!(throwable instanceof NfcPassportException) || ((NfcPassportException)throwable).getType() != PassportNfcLoadErrorType.LICENSE_ERROR) break block0;
                    this.navigator.navigate((Object)"NAVIGATE_CANCEL_LICENSE_INVALID");
                    break block1;
                }
                if (!(throwable instanceof NfcPassportException) || ((NfcPassportException)throwable).getType() != PassportNfcLoadErrorType.AUTHENTICATE_FAIL) break block2;
                BehaviorProcessor<INfcPassportView.NfcScanStep> behaviorProcessor = (BehaviorProcessor<INfcPassportView.NfcScanStep>)this.getState();
                if (behaviorProcessor == null || (behaviorProcessor = behaviorProcessor.getStep()) == null) break block1;
                behaviorProcessor.onNext((Object)INfcPassportView.NfcScanStep.AUTH_ERROR);
                break block1;
            }
            BehaviorProcessor<INfcPassportView.NfcScanStep> behaviorProcessor = (BehaviorProcessor<INfcPassportView.NfcScanStep>)this.getState();
            if (behaviorProcessor == null || (behaviorProcessor = behaviorProcessor.getStep()) == null) break block1;
            behaviorProcessor.onNext((Object)INfcPassportView.NfcScanStep.ERROR);
        }
    }

    public final void setSavePhotoImageAllowed(boolean allowed) {
        this.savePhotoImageAllowed = allowed;
    }

    @Inject
    public NfcPassportPresenter(@NotNull Navigator navigator, @BackgroundTaskScheduler @NotNull Scheduler backgroundTaskScheduler, @NotNull CheckNfcStateUseCase checkNfcStateUseCase, @NotNull ProcessNfcTagUseCase processNfcTagUseCase, @NotNull SaveNfcPassportImageUseCase saveNfcPassportImageUseCase, @Nullable @org.jetbrains.annotations.Nullable PassportPhotoSaveCallback passportPhotoSaveCallback, @NotNull MrzScanningSession mrzScanningSession) {
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskScheduler, (String)"backgroundTaskScheduler");
        Intrinsics.checkNotNullParameter((Object)checkNfcStateUseCase, (String)"checkNfcStateUseCase");
        Intrinsics.checkNotNullParameter((Object)processNfcTagUseCase, (String)"processNfcTagUseCase");
        Intrinsics.checkNotNullParameter((Object)saveNfcPassportImageUseCase, (String)"saveNfcPassportImageUseCase");
        Intrinsics.checkNotNullParameter((Object)mrzScanningSession, (String)"mrzScanningSession");
        this.navigator = navigator;
        this.backgroundTaskScheduler = backgroundTaskScheduler;
        this.checkNfcStateUseCase = checkNfcStateUseCase;
        this.processNfcTagUseCase = processNfcTagUseCase;
        this.saveNfcPassportImageUseCase = saveNfcPassportImageUseCase;
        this.passportPhotoSaveCallback = passportPhotoSaveCallback;
        this.mrzScanningSession = mrzScanningSession;
        this.inputDateFormat = new SimpleDateFormat("dd.MM.yy", Locale.GERMAN);
        this.subscriptions = new CompositeDisposable();
    }

    public static final /* synthetic */ void access$processMrzResult(NfcPassportPresenter $this, MRZRecognitionResult recognitionResult) {
        $this.processMrzResult(recognitionResult);
    }

    public static final /* synthetic */ INfcPassportView.State access$getState$p(NfcPassportPresenter $this) {
        return (INfcPassportView.State)$this.getState();
    }

    public static final /* synthetic */ void access$setState$p(NfcPassportPresenter $this, INfcPassportView.State state) {
        $this.setState(state);
    }

    public static final /* synthetic */ void access$processPassportNfcData(NfcPassportPresenter $this, PassportNfcData passportNfcData) {
        $this.processPassportNfcData(passportNfcData);
    }

    public static final /* synthetic */ void access$processNfcError(NfcPassportPresenter $this, Throwable throwable) {
        $this.processNfcError(throwable);
    }

    public static final /* synthetic */ Navigator access$getNavigator$p(NfcPassportPresenter $this) {
        return $this.navigator;
    }

    public static final /* synthetic */ NfcPassportScanningResult access$mapResult(NfcPassportPresenter $this, PassportNfcData passportNfcData, Uri photoImageUri) {
        return $this.mapResult(passportNfcData, photoImageUri);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/ui/view/nfc/NfcPassportPresenter$NfcScanned;", "", "nfcPassportData", "Lio/scanbot/sdk/ui/view/nfc/entity/NfcPassportScanningResult;", "(Lio/scanbot/sdk/ui/view/nfc/entity/NfcPassportScanningResult;)V", "getNfcPassportData", "()Lio/scanbot/sdk/ui/view/nfc/entity/NfcPassportScanningResult;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "rtu-ui-nfc_release"})
    public static final class NfcScanned {
        @NotNull
        private final NfcPassportScanningResult nfcPassportData;

        @NotNull
        public final NfcPassportScanningResult getNfcPassportData() {
            return this.nfcPassportData;
        }

        public NfcScanned(@NotNull NfcPassportScanningResult nfcPassportData) {
            Intrinsics.checkNotNullParameter((Object)nfcPassportData, (String)"nfcPassportData");
            this.nfcPassportData = nfcPassportData;
        }

        @NotNull
        public final NfcPassportScanningResult component1() {
            return this.nfcPassportData;
        }

        @NotNull
        public final NfcScanned copy(@NotNull NfcPassportScanningResult nfcPassportData) {
            Intrinsics.checkNotNullParameter((Object)nfcPassportData, (String)"nfcPassportData");
            return new NfcScanned(nfcPassportData);
        }

        public static /* synthetic */ NfcScanned copy$default(NfcScanned nfcScanned2, NfcPassportScanningResult nfcPassportScanningResult, int n, Object object) {
            if ((n & 1) != 0) {
                nfcPassportScanningResult = nfcScanned2.nfcPassportData;
            }
            return nfcScanned2.copy(nfcPassportScanningResult);
        }

        @NotNull
        public String toString() {
            return "NfcScanned(nfcPassportData=" + this.nfcPassportData + ")";
        }

        public int hashCode() {
            NfcPassportScanningResult nfcPassportScanningResult = this.nfcPassportData;
            return nfcPassportScanningResult != null ? ((Object)nfcPassportScanningResult).hashCode() : 0;
        }

        public boolean equals(@org.jetbrains.annotations.Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NfcScanned)) break block3;
                    NfcScanned nfcScanned2 = (NfcScanned)object;
                    if (!Intrinsics.areEqual((Object)this.nfcPassportData, (Object)nfcScanned2.nfcPassportData)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/ui/view/nfc/NfcPassportPresenter$MrzProcessed;", "", "mrzRecognitionResult", "Lio/scanbot/mrzscanner/model/MRZRecognitionResult;", "(Lio/scanbot/mrzscanner/model/MRZRecognitionResult;)V", "getMrzRecognitionResult", "()Lio/scanbot/mrzscanner/model/MRZRecognitionResult;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "rtu-ui-nfc_release"})
    public static final class MrzProcessed {
        @NotNull
        private final MRZRecognitionResult mrzRecognitionResult;

        @NotNull
        public final MRZRecognitionResult getMrzRecognitionResult() {
            return this.mrzRecognitionResult;
        }

        public MrzProcessed(@NotNull MRZRecognitionResult mrzRecognitionResult) {
            Intrinsics.checkNotNullParameter((Object)mrzRecognitionResult, (String)"mrzRecognitionResult");
            this.mrzRecognitionResult = mrzRecognitionResult;
        }

        @NotNull
        public final MRZRecognitionResult component1() {
            return this.mrzRecognitionResult;
        }

        @NotNull
        public final MrzProcessed copy(@NotNull MRZRecognitionResult mrzRecognitionResult) {
            Intrinsics.checkNotNullParameter((Object)mrzRecognitionResult, (String)"mrzRecognitionResult");
            return new MrzProcessed(mrzRecognitionResult);
        }

        public static /* synthetic */ MrzProcessed copy$default(MrzProcessed mrzProcessed2, MRZRecognitionResult mRZRecognitionResult, int n, Object object) {
            if ((n & 1) != 0) {
                mRZRecognitionResult = mrzProcessed2.mrzRecognitionResult;
            }
            return mrzProcessed2.copy(mRZRecognitionResult);
        }

        @NotNull
        public String toString() {
            return "MrzProcessed(mrzRecognitionResult=" + this.mrzRecognitionResult + ")";
        }

        public int hashCode() {
            MRZRecognitionResult mRZRecognitionResult = this.mrzRecognitionResult;
            return mRZRecognitionResult != null ? mRZRecognitionResult.hashCode() : 0;
        }

        public boolean equals(@org.jetbrains.annotations.Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MrzProcessed)) break block3;
                    MrzProcessed mrzProcessed2 = (MrzProcessed)object;
                    if (!Intrinsics.areEqual((Object)this.mrzRecognitionResult, (Object)mrzProcessed2.mrzRecognitionResult)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

