/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.log;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.doo.snap.util.log.Logger;

public final class DebugLog
implements Logger {
    public static final String LOG_DIRECTORY = "debug_logs";
    public static final String LOG_EXTENSION = ".txt";
    private static final String LOG_FIELD_SEPARATOR = " | ";
    private static final String UNKNOWN_SIGNATURE = "[unknown]";
    private static final String DEFAULT_PACKAGE_NAME = "default";
    private static final String NO_APPLICATION_INFO_MESSAGE = "[No application info]";
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss.SSS] ");
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("([A-Z]*|(^[a-z]))[_\\da-z\\$]*");
    private static boolean prepared = false;
    private static boolean savingEnabled = true;
    private static boolean echoEnabled = true;
    private static Logger.Level savingLevel = Logger.Level.Verbose;
    private static Logger.Level echoLevel = Logger.Level.Verbose;
    private static String packageName = "default";

    public DebugLog(Context context) {
        prepared = true;
        if (context != null) {
            packageName = context.getPackageName();
            this.printVersionInfo(context);
            return;
        }
        packageName = DEFAULT_PACKAGE_NAME;
    }

    private void printVersionInfo(Context context) {
        String string2;
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            int n2 = packageInfo.applicationInfo.labelRes;
            string2 = (n2 != 0 ? context.getString(n2) : UNKNOWN_SIGNATURE) + " v" + packageInfo.versionName + " #" + packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.logException(nameNotFoundException);
            string2 = NO_APPLICATION_INFO_MESSAGE;
        }
        this.i("APP_INFO", string2);
    }

    @Override
    public final void d(String string2, String string3) {
        this.logMessage(string2, string3, Logger.Level.Debug);
    }

    @Override
    public final void w(String string2, String string3) {
        this.logMessage(string2, string3, Logger.Level.Warning);
    }

    @Override
    public final void e(String string2, String string3) {
        this.logMessage(string2, string3, Logger.Level.Error);
    }

    @Override
    public final void i(String string2, String string3) {
        this.logMessage(string2, string3, Logger.Level.Information);
    }

    public final void e(String string2, String string3, Throwable throwable) {
        String string4 = "Exception in " + string3 + ": " + throwable.getClass().getName() + LOG_FIELD_SEPARATOR + throwable.getMessage();
        this.e(string2, string4);
    }

    public final void d(String string2) {
        String string3 = this.getCallerClassName();
        this.d(string3, string2);
    }

    public final void i(String string2) {
        String string3 = this.getCallerClassName();
        this.i(string3, string2);
    }

    public final void w(String string2) {
        String string3 = this.getCallerClassName();
        this.w(string3, string2);
    }

    public final void e(String string2) {
        String string3 = this.getCallerClassName();
        this.e(string3, string2);
    }

    @Override
    public final void logException(Throwable throwable) {
        if (!prepared) {
            return;
        }
        String string2 = this.getCallerClassName();
        String string3 = this.getCallerMethodName();
        if (throwable != null) {
            this.e(string2, string3, throwable);
            return;
        }
        this.e(string2, string3, new Exception("Unknown exception"));
    }

    @Override
    public final void logMethod() {
        if (!prepared) {
            return;
        }
        String string2 = this.getCallerClassName();
        String string3 = this.getCallerMethodName();
        this.i(string2, string3);
    }

    private void logMessage(String string2, String string3, Logger.Level level) {
        if (!prepared) {
            return;
        }
        if (echoEnabled && level.ordinal() >= echoLevel.ordinal()) {
            this.echoMessage(string2, string3, level);
        }
        if (savingEnabled && level.ordinal() >= savingLevel.ordinal()) {
            this.logToFile(string2, string3, level);
        }
    }

    private void echoMessage(String string2, String string3, Logger.Level level) {
        switch (level) {
            case Debug: {
                Log.d((String)string2, (String)string3);
                return;
            }
            case Error: {
                Log.e((String)string2, (String)string3);
                return;
            }
            case Warning: {
                Log.w((String)string2, (String)string3);
                return;
            }
            case Information: {
                Log.i((String)string2, (String)string3);
                return;
            }
            case Verbose: {
                Log.v((String)string2, (String)string3);
            }
        }
    }

    private synchronized void logToFile(String string2, String string3, Logger.Level level) {
        Writer writer = this.getLogWriter();
        if (writer != null) {
            try {
                writer.write(this.buildLogMessage(string2, string3, level));
                return;
            }
            catch (IOException iOException) {
                return;
            }
            finally {
                this.closeSafely(writer);
            }
        }
    }

    private void closeSafely(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private String buildLogMessage(String string2, String string3, Logger.Level level) {
        String string4 = string2 != null ? string2.replace('|', '/') : "";
        return TIME_FORMAT.format(new Date()) + (Object)((Object)level) + LOG_FIELD_SEPARATOR + string4 + LOG_FIELD_SEPARATOR + string3 + "\r\n";
    }

    private Writer getLogWriter() {
        FileWriter fileWriter = null;
        File file = Environment.getExternalStorageDirectory();
        this.prepareLogsFolder(file);
        File file2 = new File(file, this.getLogFilename());
        try {
            fileWriter = new FileWriter(file2, true);
        }
        catch (IOException iOException) {}
        return fileWriter;
    }

    private void prepareLogsFolder(File file) {
        File file2 = new File(file, LOG_DIRECTORY);
        if (!file2.exists()) {
            file2.mkdir();
        }
    }

    private String getLogFilename() {
        return LOG_DIRECTORY + File.separatorChar + packageName + LOG_EXTENSION;
    }

    private String tokenizeClassName(String string2) {
        String string3;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Matcher matcher = CLASS_NAME_PATTERN.matcher(string2);
            while (matcher.find()) {
                String string4 = string2.substring(matcher.start(), matcher.end());
                if (TextUtils.isEmpty((CharSequence)string4.trim())) continue;
                arrayList.add(string4.toUpperCase());
            }
            string3 = arrayList.isEmpty() ? string2 : TextUtils.join((CharSequence)"_", arrayList);
        }
        catch (Exception exception) {
            string3 = string2;
        }
        return string3;
    }

    private String getCallerClassName() {
        String string2;
        try {
            String string3;
            int n2;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            string2 = stackTraceElementArray.length > 4 ? ((n2 = (string3 = stackTraceElementArray[4].getClassName()).lastIndexOf(".")) >= 0 && n2 + 1 < string3.length() ? string3.substring(n2 + 1) : UNKNOWN_SIGNATURE) : UNKNOWN_SIGNATURE;
        }
        catch (Exception exception) {
            string2 = UNKNOWN_SIGNATURE;
        }
        return this.tokenizeClassName(string2);
    }

    private String getCallerMethodName() {
        String string2;
        try {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            string2 = stackTraceElementArray.length > 4 ? stackTraceElementArray[4].getMethodName() : UNKNOWN_SIGNATURE;
        }
        catch (Exception exception) {
            string2 = UNKNOWN_SIGNATURE;
        }
        return string2;
    }
}

