/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera.barcode;

import android.content.Context;
import android.graphics.Rect;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import io.scanbot.sap.SapManager;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import net.doo.snap.c.c;
import net.doo.snap.camera.barcode.ScanbotBarcodeDetector;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ZXingBarcodeDetector
implements ScanbotBarcodeDetector {
    private final Logger logger = LoggerProvider.getLogger();
    private final MultiFormatReader multiFormatReader;
    private final SapManager sapManager;
    private AtomicBoolean barcodeScanEnabled = new AtomicBoolean(true);

    @Inject
    public ZXingBarcodeDetector(Context context) {
        this.multiFormatReader = new MultiFormatReader();
        this.sapManager = c.a(context);
    }

    @Override
    public void enableBarcodeScan(boolean bl) {
        this.barcodeScanEnabled.set(bl);
    }

    @Override
    public Result decodeWithState(byte[] byArray, int n2, int n3, int n4) {
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        try {
            PlanarYUVLuminanceSource planarYUVLuminanceSource = new PlanarYUVLuminanceSource(byArray, n2, n3, 0, 0, n2, n3, false);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)planarYUVLuminanceSource));
            Result result = this.multiFormatReader.decodeWithState(binaryBitmap);
            return result;
        }
        catch (NotFoundException notFoundException) {
            this.logger.logException(notFoundException);
        }
        finally {
            this.multiFormatReader.reset();
        }
        return null;
    }

    @Override
    public Result decodeWithState(byte[] byArray, int n2, int n3, int n4, Rect rect) {
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        try {
            int n5 = n4 == 0 || n4 == 180 ? n2 : n3;
            int n6 = n4 == 0 || n4 == 180 ? rect.width() : rect.height();
            int n7 = n4 == 0 || n4 == 180 ? rect.height() : rect.width();
            int n8 = n4 == 0 || n4 == 180 ? rect.left : rect.top;
            int n9 = n4 == 0 || n4 == 180 ? rect.top : n5 - rect.right;
            PlanarYUVLuminanceSource planarYUVLuminanceSource = new PlanarYUVLuminanceSource(byArray, n2, n3, n8, n9, n6, n7, false);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)planarYUVLuminanceSource));
            Result result = this.multiFormatReader.decodeWithState(binaryBitmap);
            return result;
        }
        catch (NotFoundException notFoundException) {
            this.logger.logException(notFoundException);
        }
        finally {
            this.multiFormatReader.reset();
        }
        return null;
    }
}

