/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode.entity;

import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.ResultPoint;

public class BarcodeScanningResult
implements Parcelable {
    private final String text;
    private final byte[] rawBytes;
    private final int numBits;
    private ResultPoint[] resultPoints;
    private final BarcodeFormat format;
    private final long timestamp;
    public static final Parcelable.Creator<BarcodeScanningResult> CREATOR = new Parcelable.Creator<BarcodeScanningResult>(){

        public BarcodeScanningResult a(Parcel parcel) {
            return new BarcodeScanningResult(parcel);
        }

        public BarcodeScanningResult[] a(int n2) {
            return new BarcodeScanningResult[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public BarcodeScanningResult(String string2, byte[] byArray, ResultPoint[] resultPointArray, BarcodeFormat barcodeFormat) {
        this(string2, byArray, resultPointArray, barcodeFormat, System.currentTimeMillis());
    }

    public BarcodeScanningResult(String string2, byte[] byArray, ResultPoint[] resultPointArray, BarcodeFormat barcodeFormat, long l2) {
        this(string2, byArray, byArray == null ? 0 : 8 * byArray.length, resultPointArray, barcodeFormat, l2);
    }

    public BarcodeScanningResult(String string2, byte[] byArray, int n2, ResultPoint[] resultPointArray, BarcodeFormat barcodeFormat, long l2) {
        this.text = string2;
        this.rawBytes = byArray;
        this.numBits = n2;
        this.resultPoints = resultPointArray;
        this.format = barcodeFormat;
        this.timestamp = l2;
    }

    protected BarcodeScanningResult(Parcel parcel) {
        this.text = parcel.readString();
        this.rawBytes = parcel.createByteArray();
        this.numBits = parcel.readInt();
        this.resultPoints = (ResultPoint[])parcel.createTypedArray(ResultPoint.CREATOR);
        this.timestamp = parcel.readLong();
        this.format = BarcodeFormat.valueOf(parcel.readString());
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.text);
        parcel.writeByteArray(this.rawBytes);
        parcel.writeInt(this.numBits);
        parcel.writeTypedArray((Parcelable[])this.resultPoints, n2);
        parcel.writeLong(this.timestamp);
        parcel.writeString(this.format.name());
    }

    public int describeContents() {
        return 0;
    }

    public String getText() {
        return this.text;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public ResultPoint[] getResultPoints() {
        return this.resultPoints;
    }

    public BarcodeFormat getBarcodeFormat() {
        return this.format;
    }

    public void addResultPoints(ResultPoint[] resultPointArray) {
        ResultPoint[] resultPointArray2 = this.resultPoints;
        if (resultPointArray2 == null) {
            this.resultPoints = resultPointArray;
        } else if (resultPointArray != null && resultPointArray.length > 0) {
            ResultPoint[] resultPointArray3 = new ResultPoint[resultPointArray2.length + resultPointArray.length];
            System.arraycopy(resultPointArray2, 0, resultPointArray3, 0, resultPointArray2.length);
            System.arraycopy(resultPointArray, 0, resultPointArray3, resultPointArray2.length, resultPointArray.length);
            this.resultPoints = resultPointArray3;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.text;
    }
}

