/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.loading;

import android.content.Context;
import android.content.Loader;
import android.os.Handler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public abstract class SingleThreadLoader<D>
extends Loader<D> {
    private static ExecutorService executor;
    private final Handler handler = new Handler();
    private final Logger logger = LoggerProvider.getLogger();
    private D data;
    private Future future;
    private Runnable loadDataTask = new Runnable(){

        @Override
        public void run() {
            final Object d2 = SingleThreadLoader.this.doInBackground();
            SingleThreadLoader.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    SingleThreadLoader.this.dispatchOnLoadComplete(d2);
                }
            });
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleThreadLoader(Context context) {
        super(context);
        Class<SingleThreadLoader> clazz = SingleThreadLoader.class;
        synchronized (SingleThreadLoader.class) {
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract D doInBackground();

    protected void onStartLoading() {
        super.onStartLoading();
        if (this.data != null) {
            this.deliverResult(this.data);
        } else if (this.takeContentChanged() || this.future == null) {
            this.forceLoad();
        } else {
            this.logger.d("OCR", "Doing nothing");
        }
    }

    protected void onForceLoad() {
        super.onForceLoad();
        try {
            if (this.future != null) {
                this.future.cancel(true);
            }
            this.future = executor.submit(this.loadDataTask);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.deliverResult(null);
        }
    }

    protected void onReset() {
        super.onReset();
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.data = null;
        this.future = null;
    }

    private void dispatchOnLoadComplete(D d2) {
        this.future = null;
        this.data = d2;
        if (this.isAbandoned()) {
            this.logger.d("Loader", "Loader was abandoned, not delivering");
        } else if (this.isStarted()) {
            this.logger.d("Loader", "Delivering new result=" + d2);
            this.deliverResult(d2);
        } else {
            this.logger.d("Loader", "Loader was stopped, not delivering");
        }
    }
}

