/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Rect;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.aztec.AztecReader;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.datamatrix.DataMatrixReader;
import com.google.zxing.maxicode.MaxiCodeReader;
import com.google.zxing.oned.CodaBarReader;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.Code93Reader;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.EAN8Reader;
import com.google.zxing.oned.ITFReader;
import com.google.zxing.oned.MultiFormatUPCEANReader;
import com.google.zxing.oned.UPCAReader;
import com.google.zxing.oned.UPCEReader;
import com.google.zxing.oned.rss.RSS14Reader;
import com.google.zxing.oned.rss.expanded.RSSExpandedReader;
import com.google.zxing.pdf417.PDF417Reader;
import com.google.zxing.qrcode.QRCodeReader;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import net.doo.snap.b.c;
import net.doo.snap.util.YUVUtil;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ZXingBarcodeDetector
implements ScanbotBarcodeDetector {
    private final Logger logger = LoggerProvider.getLogger();
    private Reader reader;
    private final SapManager sapManager;
    private AtomicBoolean barcodeScanEnabled = new AtomicBoolean(true);

    @Inject
    public ZXingBarcodeDetector(Context context) {
        this.reader = new MultiFormatReader();
        this.sapManager = c.a(context);
    }

    @Override
    public void enableBarcodeScan(boolean bl) {
        this.barcodeScanEnabled.set(bl);
    }

    @Override
    public synchronized void setBarcodeFormat(BarcodeFormat barcodeFormat) {
        this.reinitReader(barcodeFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BarcodeScanningResult decodeWithState(byte[] byArray, int n2, int n3, int n4) {
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        try {
            byte[] byArray2 = YUVUtil.rotateYUV21Image(n4, byArray, n2, n3);
            PlanarYUVLuminanceSource planarYUVLuminanceSource = n4 % 180 == 0 ? new PlanarYUVLuminanceSource(byArray2, n2, n3, 0, 0, n2, n3, false) : new PlanarYUVLuminanceSource(byArray2, n3, n2, 0, 0, n3, n2, false);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)planarYUVLuminanceSource));
            Result result = this.reader instanceof MultiFormatReader ? ((MultiFormatReader)this.reader).decodeWithState(binaryBitmap) : this.reader.decode(binaryBitmap);
            BarcodeScanningResult barcodeScanningResult = new BarcodeScanningResult(result.getText(), result.getRawBytes(), this.getCornerPoints(result.getResultPoints()), this.getAppFormat(result.getBarcodeFormat()));
            return barcodeScanningResult;
        }
        catch (NotFoundException notFoundException) {
            this.logger.logException(notFoundException);
        }
        catch (FormatException formatException) {
            this.logger.logException(formatException);
        }
        catch (ChecksumException checksumException) {
            this.logger.logException(checksumException);
        }
        finally {
            this.reader.reset();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BarcodeScanningResult decodeWithState(byte[] byArray, int n2, int n3, int n4, Rect rect) {
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        try {
            byte[] byArray2 = YUVUtil.rotateYUV21Image(n4, byArray, n2, n3);
            PlanarYUVLuminanceSource planarYUVLuminanceSource = n4 % 180 == 0 ? new PlanarYUVLuminanceSource(byArray2, n2, n3, rect.left, rect.top, rect.width(), rect.height(), false) : new PlanarYUVLuminanceSource(byArray2, n3, n2, rect.left, rect.top, rect.width(), rect.height(), false);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)planarYUVLuminanceSource));
            Result result = this.reader instanceof MultiFormatReader ? ((MultiFormatReader)this.reader).decodeWithState(binaryBitmap) : this.reader.decode(binaryBitmap);
            BarcodeScanningResult barcodeScanningResult = new BarcodeScanningResult(result.getText(), result.getRawBytes(), this.getCornerPoints(result.getResultPoints()), this.getAppFormat(result.getBarcodeFormat()));
            return barcodeScanningResult;
        }
        catch (NotFoundException notFoundException) {
            this.logger.logException(notFoundException);
        }
        catch (FormatException formatException) {
            this.logger.logException(formatException);
        }
        catch (ChecksumException checksumException) {
            this.logger.logException(checksumException);
        }
        finally {
            this.reader.reset();
        }
        return null;
    }

    private ResultPoint[] getCornerPoints(com.google.zxing.ResultPoint[] resultPointArray) {
        ArrayList<ResultPoint> arrayList = new ArrayList<ResultPoint>();
        for (com.google.zxing.ResultPoint resultPoint : resultPointArray) {
            arrayList.add(new ResultPoint(resultPoint.getX(), resultPoint.getY()));
        }
        return arrayList.toArray(new ResultPoint[arrayList.size()]);
    }

    private BarcodeFormat getAppFormat(com.google.zxing.BarcodeFormat barcodeFormat) {
        switch (barcodeFormat) {
            case AZTEC: {
                return BarcodeFormat.AZTEC;
            }
            case CODABAR: {
                return BarcodeFormat.CODABAR;
            }
            case CODE_39: {
                return BarcodeFormat.CODE_39;
            }
            case CODE_93: {
                return BarcodeFormat.CODE_93;
            }
            case CODE_128: {
                return BarcodeFormat.CODE_128;
            }
            case DATA_MATRIX: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case EAN_8: {
                return BarcodeFormat.EAN_8;
            }
            case EAN_13: {
                return BarcodeFormat.EAN_13;
            }
            case ITF: {
                return BarcodeFormat.ITF;
            }
            case MAXICODE: {
                return BarcodeFormat.MAXICODE;
            }
            case PDF_417: {
                return BarcodeFormat.PDF_417;
            }
            case QR_CODE: {
                return BarcodeFormat.QR_CODE;
            }
            case RSS_14: {
                return BarcodeFormat.RSS_14;
            }
            case RSS_EXPANDED: {
                return BarcodeFormat.RSS_EXPANDED;
            }
            case UPC_A: {
                return BarcodeFormat.UPC_A;
            }
            case UPC_E: {
                return BarcodeFormat.UPC_E;
            }
            case UPC_EAN_EXTENSION: {
                return BarcodeFormat.UPC_EAN_EXTENSION;
            }
        }
        return BarcodeFormat.UNKNOWN;
    }

    private void reinitReader(BarcodeFormat barcodeFormat) {
        switch (barcodeFormat) {
            case ALL_FORMATS: {
                this.reader = new MultiFormatReader();
                break;
            }
            case AZTEC: {
                this.reader = new AztecReader();
                break;
            }
            case CODABAR: {
                this.reader = new CodaBarReader();
                break;
            }
            case CODE_39: {
                this.reader = new Code39Reader();
                break;
            }
            case CODE_93: {
                this.reader = new Code93Reader();
                break;
            }
            case CODE_128: {
                this.reader = new Code128Reader();
                break;
            }
            case DATA_MATRIX: {
                this.reader = new DataMatrixReader();
                break;
            }
            case EAN_8: {
                this.reader = new EAN8Reader();
                break;
            }
            case EAN_13: {
                this.reader = new EAN13Reader();
                break;
            }
            case ITF: {
                this.reader = new ITFReader();
                break;
            }
            case MAXICODE: {
                this.reader = new MaxiCodeReader();
                break;
            }
            case PDF_417: {
                this.reader = new PDF417Reader();
                break;
            }
            case QR_CODE: {
                this.reader = new QRCodeReader();
                break;
            }
            case RSS_14: {
                this.reader = new RSS14Reader();
                break;
            }
            case RSS_EXPANDED: {
                this.reader = new RSSExpandedReader();
                break;
            }
            case UPC_A: {
                this.reader = new UPCAReader();
                break;
            }
            case UPC_E: {
                this.reader = new UPCEReader();
                break;
            }
            case UPC_EAN_EXTENSION: {
                this.reader = new MultiFormatUPCEANReader(null);
                break;
            }
            case UNKNOWN: {
                this.reader = new MultiFormatReader();
            }
        }
    }
}

