/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.draft;

import android.content.SharedPreferences;
import java.util.UUID;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.Page;
import net.doo.snap.entity.SnappingDraft;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.process.util.DocumentDraft;

public class CombinedDocumentDraftExtractor
implements DocumentDraftExtractor {
    private final DocumentStoreStrategy a;
    private final SharedPreferences b;

    @Inject
    public CombinedDocumentDraftExtractor(DocumentStoreStrategy documentStoreStrategy, SharedPreferences sharedPreferences) {
        this.a = documentStoreStrategy;
        this.b = sharedPreferences;
    }

    @Override
    public DocumentDraft[] extract(SnappingDraft snappingDraft) {
        boolean bl = this.b.getBoolean("SAVE_SINGLE_AS_JPEG", false);
        String string2 = bl && snappingDraft.size() == 1 ? ".jpg" : ".pdf";
        Document document = this.a(this.a.getUniqueName(snappingDraft.getDocumentName() + string2), snappingDraft.size());
        return new DocumentDraft[]{new DocumentDraft(document, snappingDraft.getPages().toArray(new Page[snappingDraft.size()]))};
    }

    private Document a(String string2, int n2) {
        Document document = new Document();
        document.setId(UUID.randomUUID().toString());
        document.setName(string2);
        document.setPagesCount(n2);
        document.setOcrStatus(OcrStatus.NOT_SCHEDULED);
        return document;
    }
}

