/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.snap;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.lib.detector.Line2D;

public class PolygonHelper {
    private static final int MIN_EDGE_LENGTH_PX = 35;
    private float[] tmpPoints = new float[8];
    private Matrix matrix = new Matrix();
    private int width;
    private int height;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int rotation = 0;

    public static boolean checkPolygonSize(List<Point> list) {
        return !list.isEmpty() && Math.abs(list.get((int)1).x - list.get((int)0).x) > 35 && Math.abs(list.get((int)2).x - list.get((int)3).x) > 35 && Math.abs(list.get((int)3).y - list.get((int)0).y) > 35 && Math.abs(list.get((int)2).y - list.get((int)1).y) > 35;
    }

    public void setRotation(int n2) {
        if (this.rotation == n2) {
            return;
        }
        this.rotation = n2;
        this.matrix.setRotate((float)n2, 0.5f, 0.5f);
    }

    public void setImageSize(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public void setLayout(int n2, int n3, int n4, int n5) {
        this.left = n2;
        this.top = n3;
        this.right = n4;
        this.bottom = n5;
        this.width = n4 - n2;
        this.height = n5 - n3;
    }

    public void polygonToPoints(List<PointF> list, float[] fArray) {
        int n2;
        for (n2 = 0; n2 < list.size(); ++n2) {
            this.tmpPoints[n2 * 2] = list.get((int)n2).x;
            this.tmpPoints[n2 * 2 + 1] = list.get((int)n2).y;
        }
        this.matrix.mapPoints(this.tmpPoints);
        for (n2 = 0; n2 < list.size(); ++n2) {
            fArray[n2 * 4] = (float)this.left + (float)this.width * this.tmpPoints[n2 * 2];
            fArray[n2 * 4 + 1] = (float)this.top + (float)this.height * this.tmpPoints[n2 * 2 + 1];
            fArray[n2 * 4 + 2] = (float)this.left + (float)this.width * this.tmpPoints[(n2 * 2 + 2) % 8];
            fArray[n2 * 4 + 3] = (float)this.top + (float)this.height * this.tmpPoints[(n2 * 2 + 3) % 8];
        }
    }

    public void getDrawingPolygon(List<PointF> list, List<PointF> list2) {
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            PointF pointF = list.get(i2);
            PointF pointF2 = list2.get(i2);
            pointF2.x = pointF.x * (float)this.width;
            pointF2.y = pointF.y * (float)this.height;
        }
    }

    public void getPolygonFromDrawingPolygon(List<PointF> list, List<PointF> list2) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            PointF pointF = list2.get(i2);
            PointF pointF2 = list.get(i2);
            pointF.x = pointF2.x / (float)this.width;
            pointF.y = pointF2.y / (float)this.height;
        }
    }

    public List<Line2D> scaleLines(List<Line2D> list) {
        ArrayList<Line2D> arrayList = new ArrayList<Line2D>();
        for (Line2D line2D : list) {
            line2D.getStart().x = (float)this.left + (float)this.width * line2D.getStart().x;
            line2D.getStart().y = (float)this.top + (float)this.height * line2D.getStart().y;
            line2D.getEnd().x = (float)this.left + (float)this.width * line2D.getEnd().x;
            line2D.getEnd().y = (float)this.top + (float)this.height * line2D.getEnd().y;
            arrayList.add(line2D);
        }
        return arrayList;
    }
}

