/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.snap;

import android.hardware.Camera;
import android.os.Build;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public class Utils {
    private static final int A4_AREA = 8699840;
    private static final double ASPECT_TOLERANCE = 0.1;

    public static boolean isFlashSupported(Camera.Parameters parameters) {
        if (parameters == null) {
            return false;
        }
        List list = parameters.getSupportedFlashModes();
        return list != null && !list.isEmpty() && (list.size() != 1 || !((String)list.get(0)).equals("off"));
    }

    public static Camera.Size getBestA4PictureSize(Camera.Parameters parameters) {
        Object object2;
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        for (Object object2 : parameters.getSupportedPictureSizes()) {
            int n2 = ((Camera.Size)object2).width * ((Camera.Size)object2).height;
            treeMap.put(n2, object2);
        }
        Camera.Size size = null;
        object2 = treeMap.ceilingEntry(8699840);
        if (object2 == null) {
            object2 = treeMap.floorEntry(8699840);
        }
        if (object2 != null) {
            size = (Camera.Size)object2.getValue();
        }
        return size;
    }

    public static Camera.Size getLargestPictureSize(Camera.Parameters parameters) {
        Camera.Size size = null;
        for (Camera.Size size2 : parameters.getSupportedPictureSizes()) {
            if (size == null) {
                size = size2;
                continue;
            }
            int n2 = size2.width * size2.height;
            int n3 = size.width * size.height;
            if (n2 <= n3) continue;
            size = size2;
        }
        return size;
    }

    public static Camera.Size getLargestSizeWithAspectRatioMatch(List<Camera.Size> list, double d2) {
        a a2 = new a();
        ArrayList<Camera.Size> arrayList = new ArrayList<Camera.Size>();
        for (Camera.Size size : list) {
            double d3 = (double)size.width / (double)size.height;
            if (!(Math.abs(d2 - d3) < 0.1)) continue;
            arrayList.add(size);
        }
        return Collections.max(arrayList, a2);
    }

    public static Camera.Size findByWidthAndHeight(Camera.Parameters parameters, int n2, int n3) {
        for (Camera.Size size : parameters.getSupportedPictureSizes()) {
            if (size.width != n2 || size.height != n3) continue;
            return size;
        }
        return null;
    }

    public static Camera.Size getBestAspectPictureSize(int n2, int n3, int n4, Camera.Parameters parameters, double d2) {
        double d3 = (double)n3 / (double)n4;
        Camera.Size size = null;
        double d4 = Double.MAX_VALUE;
        if (n2 == 90 || n2 == 270) {
            d3 = (double)n4 / (double)n3;
        }
        List list = parameters.getSupportedPictureSizes();
        Collections.sort(list, Collections.reverseOrder(new a()));
        for (Camera.Size size2 : list) {
            double d5 = (double)size2.width / (double)size2.height;
            if (Math.abs(d5 - d3) < d4) {
                size = size2;
                d4 = Math.abs(d5 - d3);
            }
            if (!(d4 < d2)) continue;
            break;
        }
        return size;
    }

    public static void enableContinuousFocus(Camera.Parameters parameters) {
        if (parameters == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            List<String> list = Utils.extractFocusModes(parameters);
            if (list.contains("continuous-picture")) {
                parameters.setFocusMode("continuous-picture");
            } else if (list.contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            } else if (list.contains("auto")) {
                parameters.setFocusMode("auto");
            }
        }
    }

    public static void enableAutoFocus(Camera.Parameters parameters) {
        if (parameters == null) {
            return;
        }
        List<String> list = Utils.extractFocusModes(parameters);
        if (list.contains("auto") && !parameters.getFocusMode().equals("auto")) {
            parameters.setFocusMode("auto");
        }
    }

    private static List<String> extractFocusModes(Camera.Parameters parameters) {
        if (parameters == null) {
            return Collections.emptyList();
        }
        List<String> list = parameters.getSupportedFocusModes();
        return list != null ? list : Collections.emptyList();
    }

    private static class a
    implements Comparator<Camera.Size> {
        private a() {
        }

        public int a(Camera.Size size, Camera.Size size2) {
            int n2 = size.width * size.height;
            int n3 = size2.width * size2.height;
            return n2 - n3;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((Camera.Size)object, (Camera.Size)object2);
        }
    }
}

