/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistance;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import io.scanbot.sdk.persistance.Page;
import io.scanbot.sdk.persistance.PageProcessorInteractor$WhenMappings;
import io.scanbot.sdk.persistance.PageStorage;
import io.scanbot.sdk.persistance.PageStorageSettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.entity.OptimizationType;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rR\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/scanbot/sdk/persistance/PageProcessorInteractor;", "", "pageStorage", "Lio/scanbot/sdk/persistance/PageStorage;", "pageStorageSettings", "Lio/scanbot/sdk/persistance/PageStorageSettings;", "(Lio/scanbot/sdk/persistance/PageStorage;Lio/scanbot/sdk/persistance/PageStorageSettings;)V", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "createPage", "Lio/scanbot/sdk/persistance/Page;", "image", "", "imageOrientation", "", "createPreviewTo", "", "previewFile", "Ljava/io/File;", "bitmap", "Landroid/graphics/Bitmap;", "saveBitmapTo", "file", "scanbot-sdk_release"})
public final class PageProcessorInteractor {
    private final Logger logger;
    private final PageStorage pageStorage;
    private final PageStorageSettings pageStorageSettings;

    @NotNull
    public final Page createPage(@NotNull byte[] byArray, int n2) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"image");
        String string3 = string2 = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"pageId");
        FileUtils.forceMkdir((File)this.pageStorage.getPageDir(string3));
        BitmapFactory.Options options = new BitmapFactory.Options();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
        if (n2 > 0) {
            Matrix matrix = new Matrix();
            float f2 = n2;
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"originalBitmap");
            matrix.setRotate(f2, (float)bitmap2.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
        }
        if (this.pageStorageSettings.getImageScale() != 1.0f) {
            float f3 = this.pageStorageSettings.getImageScale();
            Bitmap bitmap3 = bitmap;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"originalBitmap");
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)(f3 * (float)bitmap3.getWidth())), (int)((int)(this.pageStorageSettings.getImageScale() * (float)bitmap.getHeight())), (boolean)false);
        }
        File file = this.pageStorage.getOriginalImage(string2);
        Bitmap bitmap4 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"originalBitmap");
        this.saveBitmapTo(file, bitmap4);
        int n3 = bitmap.getHeight();
        int n4 = bitmap.getWidth();
        double d2 = this.pageStorageSettings.getPreviewTargetMax();
        int n5 = Math.max(n3, n4);
        double d3 = d2 / (double)n5;
        Bitmap bitmap5 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * d3)), (int)((int)((double)bitmap.getHeight() * d3)), (boolean)false);
        File file2 = this.pageStorage.getOriginalImagePreview(string2);
        Bitmap bitmap6 = bitmap5;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap6, (String)"preview");
        this.saveBitmapTo(file2, bitmap6);
        ContourDetector contourDetector = new ContourDetector();
        DetectionResult detectionResult = contourDetector.detect(bitmap5);
        List list = contourDetector.getPolygonF();
        Bitmap bitmap7 = contourDetector.processImageF(bitmap, list, OptimizationType.NONE.getCode());
        File file3 = this.pageStorage.getDocumentImage(string2);
        Bitmap bitmap8 = bitmap7;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap8, (String)"cuttedBitmap");
        this.saveBitmapTo(file3, bitmap8);
        int n6 = bitmap7.getHeight();
        int n7 = bitmap7.getWidth();
        d2 = this.pageStorageSettings.getPreviewTargetMax();
        n5 = Math.max(n6, n7);
        d3 = d2 / (double)n5;
        bitmap5 = Bitmap.createScaledBitmap((Bitmap)bitmap7, (int)((int)((double)bitmap7.getWidth() * d3)), (int)((int)((double)bitmap7.getHeight() * d3)), (boolean)false);
        File file4 = this.pageStorage.getDocumentImagePreview(string2);
        Bitmap bitmap9 = bitmap5;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap9, (String)"preview");
        this.saveBitmapTo(file4, bitmap9);
        List list2 = list;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"polygonF");
        DetectionResult detectionResult2 = detectionResult;
        Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult2, (String)"detectionStatus");
        return new Page(string2, list2, detectionResult2);
    }

    @NotNull
    public static /* synthetic */ Page createPage$default(PageProcessorInteractor pageProcessorInteractor, byte[] byArray, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return pageProcessorInteractor.createPage(byArray, n2);
    }

    public final void saveBitmapTo(@NotNull File file, @NotNull byte[] byArray) {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"bitmap");
        BitmapFactory.Options options = new BitmapFactory.Options();
        Bitmap bitmap2 = bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"originalBitmap");
        this.saveBitmapTo(file, bitmap2);
    }

    public final void saveBitmapTo(@NotNull File file, @NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        FileOutputStream fileOutputStream = null;
        try {
            Bitmap.CompressFormat compressFormat;
            fileOutputStream = new FileOutputStream(file);
            switch (PageProcessorInteractor$WhenMappings.$EnumSwitchMapping$0[this.pageStorageSettings.getImageFormat().ordinal()]) {
                case 1: {
                    compressFormat = Bitmap.CompressFormat.JPEG;
                    break;
                }
                case 2: {
                    compressFormat = Bitmap.CompressFormat.PNG;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Bitmap.CompressFormat compressFormat2 = compressFormat;
            bitmap.compress(compressFormat2, this.pageStorageSettings.getImageQuality(), (OutputStream)fileOutputStream);
            return;
        }
        catch (IOException iOException) {
            this.logger.logException(iOException);
            return;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }

    public final void createPreviewTo(@NotNull File file, @NotNull byte[] byArray) {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"previewFile");
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"image");
        Bitmap bitmap2 = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        double d2 = this.pageStorageSettings.getPreviewTargetMax();
        Bitmap bitmap3 = bitmap2;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"bitmap");
        int n2 = bitmap3.getHeight();
        int n3 = bitmap2.getWidth();
        double d3 = d2;
        int n4 = Math.max(n2, n3);
        double d4 = d3 / (double)n4;
        Bitmap bitmap4 = bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)((int)((double)bitmap2.getWidth() * d4)), (int)((int)((double)bitmap2.getHeight() * d4)), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"preview");
        this.saveBitmapTo(file, bitmap4);
    }

    public final void createPreviewTo(@NotNull File file, @NotNull Bitmap bitmap) {
        Bitmap bitmap2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"previewFile");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int n2 = bitmap.getHeight();
        int n3 = bitmap.getWidth();
        double d2 = this.pageStorageSettings.getPreviewTargetMax();
        int n4 = Math.max(n2, n3);
        double d3 = d2 / (double)n4;
        Bitmap bitmap3 = bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * d3)), (int)((int)((double)bitmap.getHeight() * d3)), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"preview");
        this.saveBitmapTo(file, bitmap3);
    }

    @Inject
    public PageProcessorInteractor(@NotNull PageStorage pageStorage, @NotNull PageStorageSettings pageStorageSettings) {
        Intrinsics.checkParameterIsNotNull((Object)pageStorage, (String)"pageStorage");
        Intrinsics.checkParameterIsNotNull((Object)pageStorageSettings, (String)"pageStorageSettings");
        this.pageStorage = pageStorage;
        this.pageStorageSettings = pageStorageSettings;
        this.logger = LoggerProvider.getLogger();
    }
}

