/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.BarcodeDetector;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import net.doo.snap.c.c;

public class GoogleVisionBarcodeDetector
implements ScanbotBarcodeDetector {
    private final SapManager sapManager;
    private final Context context;
    private BarcodeDetector detector;
    private AtomicBoolean barcodeScanEnabled = new AtomicBoolean(true);

    @Inject
    public GoogleVisionBarcodeDetector(Context context) {
        this.context = context;
        this.detector = new BarcodeDetector.Builder(context).build();
        this.sapManager = c.a(context);
    }

    @Override
    public void enableBarcodeScan(boolean bl) {
        this.barcodeScanEnabled.set(bl);
    }

    @Override
    public synchronized void setBarcodeFormat(BarcodeFormat barcodeFormat) {
        this.detector.release();
        this.detector = new BarcodeDetector.Builder(this.context).setBarcodeFormats(this.getGVFormat(barcodeFormat)).build();
    }

    @Override
    public synchronized BarcodeScanningResult decodeWithState(byte[] byArray, int n2, int n3, int n4) {
        BarcodeScanningResult barcodeScanningResult = null;
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        if (this.detector == null || !this.detector.isOperational()) {
            return null;
        }
        try {
            ByteBuffer byteBuffer = MappedByteBuffer.wrap(byArray);
            Frame frame = new Frame.Builder().setImageData(byteBuffer, n2, n3, 17).build();
            SparseArray sparseArray = this.detector.detect(frame);
            if (sparseArray.size() > 0) {
                Barcode barcode = (Barcode)sparseArray.valueAt(0);
                barcodeScanningResult = new BarcodeScanningResult(barcode.rawValue, barcode.rawValue.getBytes(), this.getCornerPoints(barcode.cornerPoints), this.getAppFormat(barcode.format));
            }
        }
        finally {
            this.detector.release();
        }
        return barcodeScanningResult;
    }

    @Override
    public synchronized BarcodeScanningResult decodeWithState(byte[] byArray, int n2, int n3, int n4, Rect rect) {
        BarcodeScanningResult barcodeScanningResult = null;
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        if (this.detector == null || !this.detector.isOperational()) {
            return null;
        }
        try {
            int n5 = n4 == 0 || n4 == 180 ? n2 : n3;
            int n6 = n4 == 0 || n4 == 180 ? rect.width() : rect.height();
            int n7 = n4 == 0 || n4 == 180 ? rect.height() : rect.width();
            int n8 = n4 == 0 || n4 == 180 ? rect.left : rect.top;
            int n9 = n4 == 0 || n4 == 180 ? rect.top : n5 - rect.right;
            Rect rect2 = new Rect(n8, n9, n8 + n6, n9 + n7);
            ByteBuffer byteBuffer = MappedByteBuffer.wrap(byArray);
            Frame frame = new Frame.Builder().setImageData(byteBuffer, n2, n3, 17).build();
            SparseArray sparseArray = this.detector.detect(frame);
            for (int i2 = 0; i2 < sparseArray.size(); ++i2) {
                Barcode barcode = (Barcode)sparseArray.valueAt(i2);
                if (!rect2.contains(barcode.getBoundingBox())) continue;
                barcodeScanningResult = new BarcodeScanningResult(barcode.rawValue, barcode.rawValue.getBytes(), this.getCornerPoints(barcode.cornerPoints), this.getAppFormat(barcode.format));
                break;
            }
        }
        finally {
            this.detector.release();
        }
        return barcodeScanningResult;
    }

    private ResultPoint[] getCornerPoints(Point[] pointArray) {
        ArrayList<ResultPoint> arrayList = new ArrayList<ResultPoint>();
        Point[] pointArray2 = pointArray;
        int n2 = pointArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Point point = pointArray2[i2];
            arrayList.add(new ResultPoint(point.x, point.y));
        }
        return arrayList.toArray(new ResultPoint[arrayList.size()]);
    }

    private BarcodeFormat getAppFormat(int n2) {
        switch (n2) {
            case 4096: {
                return BarcodeFormat.AZTEC;
            }
            case 8: {
                return BarcodeFormat.CODABAR;
            }
            case 2: {
                return BarcodeFormat.CODE_39;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 1: {
                return BarcodeFormat.CODE_128;
            }
            case 16: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 64: {
                return BarcodeFormat.EAN_8;
            }
            case 32: {
                return BarcodeFormat.EAN_13;
            }
            case 128: {
                return BarcodeFormat.ITF;
            }
            case 2048: {
                return BarcodeFormat.PDF_417;
            }
            case 256: {
                return BarcodeFormat.QR_CODE;
            }
            case 512: {
                return BarcodeFormat.UPC_A;
            }
            case 1024: {
                return BarcodeFormat.UPC_E;
            }
        }
        return BarcodeFormat.UNKNOWN;
    }

    private int getGVFormat(BarcodeFormat barcodeFormat) {
        switch (barcodeFormat) {
            case ALL_FORMATS: 
            case MAXICODE: 
            case RSS_14: 
            case RSS_EXPANDED: 
            case UPC_EAN_EXTENSION: 
            case UNKNOWN: {
                return 0;
            }
            case AZTEC: {
                return 4096;
            }
            case CODABAR: {
                return 8;
            }
            case CODE_39: {
                return 2;
            }
            case CODE_93: {
                return 4;
            }
            case CODE_128: {
                return 1;
            }
            case DATA_MATRIX: {
                return 16;
            }
            case EAN_8: {
                return 64;
            }
            case EAN_13: {
                return 32;
            }
            case ITF: {
                return 128;
            }
            case PDF_417: {
                return 2048;
            }
            case QR_CODE: {
                return 256;
            }
            case UPC_A: {
                return 512;
            }
            case UPC_E: {
                return 1024;
            }
        }
        return 0;
    }
}

