/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.dcscanner;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.dcscanner.model.DisabilityCertificateRecognizerResultInfo;
import io.scanbot.sap.SapManager;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.b.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.dcscanner.DCScanner;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class DCScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private DCScanner dcScanner;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private boolean enabled = true;

    public static DCScannerFrameHandler attach(ScanbotCameraView scanbotCameraView, DCScanner dCScanner) {
        DCScannerFrameHandler dCScannerFrameHandler = new DCScannerFrameHandler(scanbotCameraView.getContext(), dCScanner);
        scanbotCameraView.getPreviewBuffer().addFrameHandler(dCScannerFrameHandler);
        return dCScannerFrameHandler;
    }

    public DCScannerFrameHandler(Context context, DCScanner dCScanner) {
        this.dcScanner = dCScanner;
        this.sapManager = c.a(context);
    }

    @Override
    public synchronized boolean handleFrame(byte[] byArray, int n2, int n3, int n4, Rect rect) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        DisabilityCertificateRecognizerResultInfo disabilityCertificateRecognizerResultInfo = this.dcScanner.recognizeDC(byArray, n2, n3, n4);
        return this.notifyHandlers(disabilityCertificateRecognizerResultInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(resultHandler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(resultHandler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(DisabilityCertificateRecognizerResultInfo disabilityCertificateRecognizerResultInfo) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handleResult(disabilityCertificateRecognizerResultInfo);
            }
        }
        return bl;
    }

    public static interface ResultHandler {
        public boolean handleResult(DisabilityCertificateRecognizerResultInfo var1);
    }
}

