/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import net.doo.snap.R;
import net.doo.snap.ui.EditPolygonImageView;
import net.doo.snap.util.bitmap.BitmapUtils;

public class MagnifierView
extends View {
    private final Drawable magnifierDrawable;
    private final float magnifierRaduis;
    private final float magnifierMargin;
    private a magnifier = new a();
    private PointF zoomPoint;
    private Bitmap magnifierFrameBitmap;

    public MagnifierView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MagnifierView, 0, 0);
        try {
            this.magnifierDrawable = typedArray.getDrawable(R.styleable.MagnifierView_magnifierImageSrc);
            this.magnifierRaduis = typedArray.getDimension(R.styleable.MagnifierView_magnifierRadius, this.getResources().getDimension(R.dimen.magnifier_raduis));
            this.magnifierMargin = typedArray.getDimension(R.styleable.MagnifierView_magnifierMargin, this.getResources().getDimension(R.dimen.magnifier_margin));
            return;
        }
        finally {
            typedArray.recycle();
        }
    }

    void drawMagnifier(PointF zoomPoint) {
        this.zoomPoint = zoomPoint;
        this.invalidate();
    }

    void eraseMagnifier() {
        this.zoomPoint = null;
        this.invalidate();
    }

    public void setImageRotation(float rotation) {
        this.magnifier.a(rotation);
        this.invalidate();
    }

    public void setupMagnifier(EditPolygonImageView view) {
        Bitmap bitmap = BitmapUtils.drawableToBitmap(view.getDrawable());
        this.magnifier.a(bitmap, view.getRotation());
        view.setMagnifier(this);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.zoomPoint != null) {
            this.magnifier.a(canvas, this.zoomPoint);
            return;
        }
        canvas.drawColor(0);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
        this.magnifierFrameBitmap = BitmapUtils.drawableToBitmap(this.magnifierDrawable);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.magnifierFrameBitmap.recycle();
        this.magnifierFrameBitmap = null;
        this.magnifier.a();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.magnifier.a(this.getWidth(), this.getHeight());
    }

    private final class a {
        private final float b = 2.0f;
        private float c;
        private int d;
        private int e;
        private BitmapShader f;
        private Paint g;
        private Matrix h = new Matrix();
        private Paint i;
        private Paint j;
        private float k;
        private float l;
        private float m;
        private Bitmap n;

        a() {
        }

        final void a(int n2, int n3) {
            this.d = n2;
            this.e = n3;
            if (this.n != null && n2 != 0 && n3 != 0) {
                this.c = Math.max((float)this.n.getWidth() / (float)this.d, (float)this.n.getHeight() / (float)this.e);
                this.k = ((float)this.d - (float)this.n.getWidth() / this.c) / 2.0f;
                this.l = ((float)this.e - (float)this.n.getHeight() / this.c) / 2.0f;
            }
        }

        final void a(Bitmap bitmap, float f2) {
            if (BitmapUtils.isBitmapValid(bitmap)) {
                if (this.f != null) {
                    this.a();
                }
                Bitmap bitmap2 = bitmap;
                Canvas canvas = new Canvas(bitmap2);
                Paint paint = new Paint();
                paint.setColor(-16777216);
                paint.setStyle(Paint.Style.STROKE);
                paint.setStrokeWidth(0.0f);
                canvas.drawRect(0.0f, 0.0f, (float)(bitmap2.getWidth() - 1), (float)(bitmap2.getHeight() - 1), paint);
                this.n = bitmap2;
                this.f = new BitmapShader(this.n, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                this.g = new Paint();
                this.g.setShader((Shader)this.f);
                this.m = f2;
                this.a(MagnifierView.this.getWidth(), MagnifierView.this.getHeight());
            }
        }

        final void a() {
            if (this.n != null) {
                this.n.recycle();
            }
            this.n = null;
            this.g = null;
            this.f = null;
        }

        private static Bitmap a(Bitmap bitmap, int n2) {
            Canvas canvas = new Canvas(bitmap);
            Paint paint = new Paint();
            paint.setColor(n2);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(0.0f);
            canvas.drawRect(0.0f, 0.0f, (float)(bitmap.getWidth() - 1), (float)(bitmap.getHeight() - 1), paint);
            return bitmap;
        }

        final void a(Canvas canvas, PointF pointF) {
            PointF pointF2 = new PointF(pointF.x * (float)this.d, pointF.y * (float)this.e);
            float f2 = MagnifierView.this.magnifierMargin;
            float f3 = MagnifierView.this.magnifierMargin;
            PointF pointF3 = pointF2;
            a a2 = this;
            int n2 = pointF3.x + a2.k < (float)(a2.d >> 1) ? (pointF3.y + a2.l < (float)(a2.e >> 1) ? 1 : 4) : (pointF3.y + a2.l < (float)(a2.e >> 1) ? 2 : 3);
            if ((int)((float)n2 - (360.0f - a2.m) % 360.0f / 90.0f) == 1) {
                f2 = (float)MagnifierView.this.getWidth() - MagnifierView.this.magnifierRaduis * 2.0f - MagnifierView.this.magnifierMargin;
            }
            this.h.setScale(2.0f, 2.0f);
            this.h.postTranslate(-pointF2.x * this.c * 2.0f + MagnifierView.this.magnifierRaduis + f2, -pointF2.y * this.c * 2.0f + MagnifierView.this.magnifierRaduis + f3);
            this.f.setLocalMatrix(this.h);
            canvas.save();
            canvas.rotate(this.m, f2 + MagnifierView.this.magnifierRaduis, f3 + MagnifierView.this.magnifierRaduis);
            canvas.drawCircle(f2 + MagnifierView.this.magnifierRaduis, f3 + MagnifierView.this.magnifierRaduis, MagnifierView.this.magnifierRaduis, this.g);
            canvas.restore();
            canvas.drawBitmap(MagnifierView.this.magnifierFrameBitmap, f2, f3, null);
        }

        private boolean a(PointF pointF) {
            int n2 = pointF.x + this.k < (float)(this.d >> 1) ? (pointF.y + this.l < (float)(this.e >> 1) ? 1 : 4) : (pointF.y + this.l < (float)(this.e >> 1) ? 2 : 3);
            return (int)((float)n2 - (360.0f - this.m) % 360.0f / 90.0f) == 1;
        }

        final void a(float f2) {
            this.m = f2;
        }
    }
}

