/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage$WhenMappings;
import io.scanbot.sdk.persistence.PageProcessorInteractor;
import io.scanbot.sdk.persistence.PageStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\u0012J\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/scanbot/sdk/persistence/PageFileStorage;", "", "pageProcessorInteractor", "Lio/scanbot/sdk/persistence/PageProcessorInteractor;", "pageStorage", "Lio/scanbot/sdk/persistence/PageStorage;", "(Lio/scanbot/sdk/persistence/PageProcessorInteractor;Lio/scanbot/sdk/persistence/PageStorage;)V", "add", "", "image", "", "getImageURL", "Landroid/net/Uri;", "pageId", "type", "Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "getPreviewImageURI", "remove", "", "removeAll", "removeAllExcept", "", "pageIds", "", "setImageForId", "Landroid/graphics/Bitmap;", "existingPageId", "PageFileType", "scanbot-sdk_release"})
public final class PageFileStorage {
    private final PageProcessorInteractor pageProcessorInteractor;
    private final PageStorage pageStorage;

    @NotNull
    public final Uri getImageURL(@NotNull String pageId, @NotNull PageFileType type) {
        Uri uri;
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Uri uri2 = Uri.fromFile((File)this.pageStorage.getOriginalImage(pageId));
                uri = uri2;
                Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(pageStorage.getOriginalImage(pageId))");
                break;
            }
            case 2: {
                Uri uri3 = Uri.fromFile((File)this.pageStorage.getDocumentImage(pageId));
                uri = uri3;
                Intrinsics.checkExpressionValueIsNotNull((Object)uri3, (String)"Uri.fromFile(pageStorage.getDocumentImage(pageId))");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return uri;
    }

    @NotNull
    public final Uri getPreviewImageURI(@NotNull String pageId, @NotNull PageFileType type) {
        Uri uri;
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                Uri uri2 = Uri.fromFile((File)this.pageStorage.getOriginalImagePreview(pageId));
                uri = uri2;
                Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(pageStorage\u2026inalImagePreview(pageId))");
                break;
            }
            case 2: {
                Uri uri3 = Uri.fromFile((File)this.pageStorage.getDocumentImagePreview(pageId));
                uri = uri3;
                Intrinsics.checkExpressionValueIsNotNull((Object)uri3, (String)"Uri.fromFile(pageStorage\u2026mentImagePreview(pageId))");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return uri;
    }

    @NotNull
    public final String add(@NotNull byte[] image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Page page = PageProcessorInteractor.createPage$default(this.pageProcessorInteractor, image, 0, 2, null);
        return page.getPageId();
    }

    public final void setImageForId(@NotNull byte[] image, @NotNull String existingPageId, @NotNull PageFileType type) {
        File file;
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$2[type.ordinal()]) {
            case 1: {
                file2 = this.pageStorage.getOriginalImage(existingPageId);
                break;
            }
            case 2: {
                file2 = this.pageStorage.getDocumentImage(existingPageId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file3 = file2;
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$3[type.ordinal()]) {
            case 1: {
                file = this.pageStorage.getOriginalImagePreview(existingPageId);
                break;
            }
            case 2: {
                file = this.pageStorage.getDocumentImagePreview(existingPageId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file4 = file;
        this.pageProcessorInteractor.saveBitmapTo(file3, image);
        this.pageProcessorInteractor.createPreviewTo(file4, image);
    }

    public final void setImageForId(@NotNull Bitmap image, @NotNull String existingPageId, @NotNull PageFileType type) {
        File file;
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$4[type.ordinal()]) {
            case 1: {
                file2 = this.pageStorage.getOriginalImage(existingPageId);
                break;
            }
            case 2: {
                file2 = this.pageStorage.getDocumentImage(existingPageId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file3 = file2;
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$5[type.ordinal()]) {
            case 1: {
                file = this.pageStorage.getOriginalImagePreview(existingPageId);
                break;
            }
            case 2: {
                file = this.pageStorage.getDocumentImagePreview(existingPageId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file4 = file;
        this.pageProcessorInteractor.saveBitmapTo(file3, image);
        this.pageProcessorInteractor.createPreviewTo(file4, image);
    }

    public final boolean remove(@NotNull String pageId) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        return this.pageStorage.getPageDir(pageId).delete();
    }

    public final boolean removeAll() {
        return this.pageStorage.getPagesDirectory().delete();
    }

    public final void removeAllExcept(@NotNull List<String> pageIds) {
        Intrinsics.checkParameterIsNotNull(pageIds, (String)"pageIds");
        List list = new ArrayList();
        File[] fileArray = this.pageStorage.getPagesDirectory().listFiles();
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File file;
            File file2 = file = fileArray[i2];
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"listFile");
            if (pageIds.contains(file2.getName())) continue;
            list.add(file);
        }
        for (File file : list) {
            file.delete();
        }
    }

    @Inject
    public PageFileStorage(@NotNull PageProcessorInteractor pageProcessorInteractor, @NotNull PageStorage pageStorage) {
        Intrinsics.checkParameterIsNotNull((Object)pageProcessorInteractor, (String)"pageProcessorInteractor");
        Intrinsics.checkParameterIsNotNull((Object)pageStorage, (String)"pageStorage");
        this.pageProcessorInteractor = pageProcessorInteractor;
        this.pageStorage = pageStorage;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "", "(Ljava/lang/String;I)V", "ORIGINAL", "DOCUMENT", "scanbot-sdk_release"})
    public static final class PageFileType
    extends Enum<PageFileType> {
        public static final /* enum */ PageFileType ORIGINAL;
        public static final /* enum */ PageFileType DOCUMENT;
        private static final /* synthetic */ PageFileType[] $VALUES;

        static {
            PageFileType[] pageFileTypeArray = new PageFileType[2];
            PageFileType[] pageFileTypeArray2 = pageFileTypeArray;
            pageFileTypeArray[0] = ORIGINAL = new PageFileType();
            pageFileTypeArray[1] = DOCUMENT = new PageFileType();
            $VALUES = pageFileTypeArray;
        }

        public static PageFileType[] values() {
            return (PageFileType[])$VALUES.clone();
        }

        public static PageFileType valueOf(String string2) {
            return Enum.valueOf(PageFileType.class, string2);
        }
    }
}

