/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Rect;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.aztec.AztecReader;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.datamatrix.DataMatrixReader;
import com.google.zxing.maxicode.MaxiCodeReader;
import com.google.zxing.oned.CodaBarReader;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.Code93Reader;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.EAN8Reader;
import com.google.zxing.oned.ITFReader;
import com.google.zxing.oned.MultiFormatUPCEANReader;
import com.google.zxing.oned.UPCAReader;
import com.google.zxing.oned.UPCEReader;
import com.google.zxing.oned.rss.RSS14Reader;
import com.google.zxing.oned.rss.expanded.RSSExpandedReader;
import com.google.zxing.pdf417.PDF417Reader;
import com.google.zxing.qrcode.QRCodeReader;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import net.doo.snap.b.c;
import net.doo.snap.util.YUVUtil;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ZXingBarcodeDetector
implements ScanbotBarcodeDetector {
    private final Logger logger = LoggerProvider.getLogger();
    private Reader reader;
    private final SapManager sapManager;
    private AtomicBoolean barcodeScanEnabled = new AtomicBoolean(true);

    @Inject
    public ZXingBarcodeDetector(Context context) {
        this.reader = new MultiFormatReader();
        this.sapManager = c.a(context);
    }

    @Override
    public void enableBarcodeScan(boolean barcodeScanEnabled) {
        this.barcodeScanEnabled.set(barcodeScanEnabled);
    }

    @Override
    public synchronized void setBarcodeFormatsFilter(List<BarcodeFormat> barcodeFormats) {
        if (barcodeFormats.size() == 1) {
            this.reinitReader(barcodeFormats.get(0));
        } else {
            HashMap hashMap = new HashMap();
            ArrayList<com.google.zxing.BarcodeFormat> arrayList = new ArrayList<com.google.zxing.BarcodeFormat>();
            for (BarcodeFormat barcodeFormat : barcodeFormats) {
                com.google.zxing.BarcodeFormat barcodeFormat2 = this.getFormat(barcodeFormat);
                if (barcodeFormat2 == null) continue;
                arrayList.add(barcodeFormat2);
            }
            hashMap.put(DecodeHintType.POSSIBLE_FORMATS, hashMap);
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            multiFormatReader.setHints(hashMap);
            this.reader = multiFormatReader;
        }
    }

    private com.google.zxing.BarcodeFormat getFormat(BarcodeFormat barcodeFormat) {
        switch (barcodeFormat) {
            case AZTEC: {
                return com.google.zxing.BarcodeFormat.AZTEC;
            }
            case CODABAR: {
                return com.google.zxing.BarcodeFormat.CODABAR;
            }
            case CODE_39: {
                return com.google.zxing.BarcodeFormat.CODE_39;
            }
            case CODE_93: {
                return com.google.zxing.BarcodeFormat.CODE_93;
            }
            case CODE_128: {
                return com.google.zxing.BarcodeFormat.CODE_128;
            }
            case DATA_MATRIX: {
                return com.google.zxing.BarcodeFormat.DATA_MATRIX;
            }
            case EAN_8: {
                return com.google.zxing.BarcodeFormat.EAN_8;
            }
            case EAN_13: {
                return com.google.zxing.BarcodeFormat.EAN_13;
            }
            case ITF: {
                return com.google.zxing.BarcodeFormat.ITF;
            }
            case MAXICODE: {
                return com.google.zxing.BarcodeFormat.MAXICODE;
            }
            case PDF_417: {
                return com.google.zxing.BarcodeFormat.PDF_417;
            }
            case QR_CODE: {
                return com.google.zxing.BarcodeFormat.QR_CODE;
            }
            case RSS_14: {
                return com.google.zxing.BarcodeFormat.RSS_14;
            }
            case RSS_EXPANDED: {
                return com.google.zxing.BarcodeFormat.RSS_EXPANDED;
            }
            case UPC_A: {
                return com.google.zxing.BarcodeFormat.UPC_A;
            }
            case UPC_E: {
                return com.google.zxing.BarcodeFormat.UPC_E;
            }
            case UPC_EAN_EXTENSION: {
                return com.google.zxing.BarcodeFormat.UPC_EAN_EXTENSION;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BarcodeScanningResult decodeWithState(byte[] data, int width, int height, int frameOrientation) {
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        try {
            byte[] byArray = YUVUtil.rotateYUV21Image(frameOrientation, data, width, height);
            PlanarYUVLuminanceSource planarYUVLuminanceSource = frameOrientation % 180 == 0 ? new PlanarYUVLuminanceSource(byArray, width, height, 0, 0, width, height, false) : new PlanarYUVLuminanceSource(byArray, height, width, 0, 0, height, width, false);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)planarYUVLuminanceSource));
            Result result = this.reader instanceof MultiFormatReader ? ((MultiFormatReader)this.reader).decodeWithState(binaryBitmap) : this.reader.decode(binaryBitmap);
            BarcodeScanningResult barcodeScanningResult = new BarcodeScanningResult(result.getText(), result.getRawBytes(), this.getCornerPoints(result.getResultPoints()), this.getAppFormat(result.getBarcodeFormat()));
            return barcodeScanningResult;
        }
        catch (NotFoundException notFoundException) {
            this.logger.logException(notFoundException);
        }
        catch (FormatException formatException) {
            this.logger.logException(formatException);
        }
        catch (ChecksumException checksumException) {
            this.logger.logException(checksumException);
        }
        finally {
            this.reader.reset();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BarcodeScanningResult decodeWithState(byte[] data, int width, int height, int frameOrientation, Rect finderRect) {
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        try {
            byte[] byArray = YUVUtil.rotateYUV21Image(frameOrientation, data, width, height);
            PlanarYUVLuminanceSource planarYUVLuminanceSource = frameOrientation % 180 == 0 ? new PlanarYUVLuminanceSource(byArray, width, height, finderRect.left, finderRect.top, finderRect.width(), finderRect.height(), false) : new PlanarYUVLuminanceSource(byArray, height, width, finderRect.left, finderRect.top, finderRect.width(), finderRect.height(), false);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)planarYUVLuminanceSource));
            Result result = this.reader instanceof MultiFormatReader ? ((MultiFormatReader)this.reader).decodeWithState(binaryBitmap) : this.reader.decode(binaryBitmap);
            BarcodeScanningResult barcodeScanningResult = new BarcodeScanningResult(result.getText(), result.getRawBytes(), this.getCornerPoints(result.getResultPoints()), this.getAppFormat(result.getBarcodeFormat()));
            return barcodeScanningResult;
        }
        catch (NotFoundException notFoundException) {
            this.logger.logException(notFoundException);
        }
        catch (FormatException formatException) {
            this.logger.logException(formatException);
        }
        catch (ChecksumException checksumException) {
            this.logger.logException(checksumException);
        }
        finally {
            this.reader.reset();
        }
        return null;
    }

    private ResultPoint[] getCornerPoints(com.google.zxing.ResultPoint[] cornerPoints) {
        ArrayList<ResultPoint> arrayList = new ArrayList<ResultPoint>();
        for (com.google.zxing.ResultPoint resultPoint : cornerPoints) {
            if (resultPoint != null) {
                arrayList.add(new ResultPoint(resultPoint.getX(), resultPoint.getY()));
                continue;
            }
            arrayList.add(null);
        }
        return arrayList.toArray(new ResultPoint[arrayList.size()]);
    }

    private BarcodeFormat getAppFormat(com.google.zxing.BarcodeFormat zxingBarcodeFormat) {
        if (zxingBarcodeFormat == null) {
            return BarcodeFormat.UNKNOWN;
        }
        switch (zxingBarcodeFormat) {
            case AZTEC: {
                return BarcodeFormat.AZTEC;
            }
            case CODABAR: {
                return BarcodeFormat.CODABAR;
            }
            case CODE_39: {
                return BarcodeFormat.CODE_39;
            }
            case CODE_93: {
                return BarcodeFormat.CODE_93;
            }
            case CODE_128: {
                return BarcodeFormat.CODE_128;
            }
            case DATA_MATRIX: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case EAN_8: {
                return BarcodeFormat.EAN_8;
            }
            case EAN_13: {
                return BarcodeFormat.EAN_13;
            }
            case ITF: {
                return BarcodeFormat.ITF;
            }
            case MAXICODE: {
                return BarcodeFormat.MAXICODE;
            }
            case PDF_417: {
                return BarcodeFormat.PDF_417;
            }
            case QR_CODE: {
                return BarcodeFormat.QR_CODE;
            }
            case RSS_14: {
                return BarcodeFormat.RSS_14;
            }
            case RSS_EXPANDED: {
                return BarcodeFormat.RSS_EXPANDED;
            }
            case UPC_A: {
                return BarcodeFormat.UPC_A;
            }
            case UPC_E: {
                return BarcodeFormat.UPC_E;
            }
            case UPC_EAN_EXTENSION: {
                return BarcodeFormat.UPC_EAN_EXTENSION;
            }
        }
        return BarcodeFormat.UNKNOWN;
    }

    private void reinitReader(BarcodeFormat barcodeFormat) {
        switch (barcodeFormat) {
            case ALL_FORMATS: {
                this.reader = new MultiFormatReader();
                break;
            }
            case AZTEC: {
                this.reader = new AztecReader();
                break;
            }
            case CODABAR: {
                this.reader = new CodaBarReader();
                break;
            }
            case CODE_39: {
                this.reader = new Code39Reader();
                break;
            }
            case CODE_93: {
                this.reader = new Code93Reader();
                break;
            }
            case CODE_128: {
                this.reader = new Code128Reader();
                break;
            }
            case DATA_MATRIX: {
                this.reader = new DataMatrixReader();
                break;
            }
            case EAN_8: {
                this.reader = new EAN8Reader();
                break;
            }
            case EAN_13: {
                this.reader = new EAN13Reader();
                break;
            }
            case ITF: {
                this.reader = new ITFReader();
                break;
            }
            case MAXICODE: {
                this.reader = new MaxiCodeReader();
                break;
            }
            case PDF_417: {
                this.reader = new PDF417Reader();
                break;
            }
            case QR_CODE: {
                this.reader = new QRCodeReader();
                break;
            }
            case RSS_14: {
                this.reader = new RSS14Reader();
                break;
            }
            case RSS_EXPANDED: {
                this.reader = new RSSExpandedReader();
                break;
            }
            case UPC_A: {
                this.reader = new UPCAReader();
                break;
            }
            case UPC_E: {
                this.reader = new UPCEReader();
                break;
            }
            case UPC_EAN_EXTENSION: {
                this.reader = new MultiFormatUPCEANReader(null);
                break;
            }
            case UNKNOWN: {
                this.reader = new MultiFormatReader();
            }
        }
    }
}

