/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import net.doo.snap.b.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class BarcodeDetectorFrameHandler
implements PreviewBuffer.FrameHandler {
    private static final int DEFAULT_BARCODE_DETECTION_INTERVAL_IN_MS = 10000;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private final ScanbotBarcodeDetector barcodeDetector;
    private boolean enabled = true;
    private AtomicBoolean intervalEnabled = new AtomicBoolean(true);
    private long detectionIntervalInMs = 10000L;

    public static BarcodeDetectorFrameHandler attach(ScanbotCameraView cameraView, ScanbotSDK scanbotSDK) {
        BarcodeDetectorFrameHandler barcodeDetectorFrameHandler = new BarcodeDetectorFrameHandler(cameraView.getContext(), scanbotSDK);
        cameraView.getPreviewBuffer().addFrameHandler(barcodeDetectorFrameHandler);
        return barcodeDetectorFrameHandler;
    }

    public BarcodeDetectorFrameHandler(Context context, ScanbotSDK scanbotSDK) {
        this.barcodeDetector = scanbotSDK.barcodeDetector();
        this.sapManager = c.a(context);
    }

    @Override
    public synchronized boolean handleFrame(byte[] frame, int width, int height, int frameOrientation, Rect finderRect) {
        BarcodeScanningResult barcodeScanningResult;
        this.logger.logMethod();
        if (!this.enabled || !this.intervalEnabled.get()) {
            return false;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        BarcodeScanningResult barcodeScanningResult2 = barcodeScanningResult = finderRect == null ? this.barcodeDetector.decodeWithState(frame, width, height, frameOrientation) : this.barcodeDetector.decodeWithState(frame, width, height, frameOrientation, finderRect);
        if (barcodeScanningResult != null) {
            this.intervalEnabled.set(false);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    BarcodeDetectorFrameHandler.this.intervalEnabled.set(true);
                }
            }, this.detectionIntervalInMs);
        }
        return this.notifyHandlers(barcodeScanningResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDetectionInterval(long detectionIntervalInMs) {
        this.detectionIntervalInMs = detectionIntervalInMs;
        this.intervalEnabled.set(true);
    }

    public void setBarcodeFormatsFilter(List<BarcodeFormat> barcodeFormats) {
        this.barcodeDetector.setBarcodeFormatsFilter(barcodeFormats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(BarcodeScanningResult detectedBarcode) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handleResult(detectedBarcode);
            }
        }
        return bl;
    }

    public static interface ResultHandler {
        public boolean handleResult(BarcodeScanningResult var1);
    }
}

