/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ImageFormat;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.commonsware.cwac.camera.DeviceProfile;
import com.commonsware.cwac.camera.PictureTransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.doo.snap.R;
import net.doo.snap.camera.CameraOpenCallback;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.snap.Utils;
import org.jetbrains.annotations.NotNull;

class CameraView
extends com.commonsware.cwac.camera.CameraView {
    private static final int a = 5000;
    private static final int b = 3000;
    private static final int c = 1000;
    private static final int d = 75;
    private static final int e = 1000;
    private static final int f = -1000;
    private static final int g = 1000;
    private static final String h = "text";
    private static final int i = 2;
    private Camera j;
    private final Handler k = new Handler();
    private final Runnable l = new Runnable(){

        @Override
        public void run() {
            CameraView.this.cancelAutoFocus();
        }
    };
    private long m = 0L;
    private List<PointF> n = Collections.emptyList();
    private boolean o = true;
    private boolean p = false;
    private boolean q = false;
    private final Paint r;
    private Rect s;
    private final a t = new a();
    private final Logger u = LoggerProvider.getLogger();
    private AutofocusCallback v = AutofocusCallback.NULL;
    private CameraOpenCallback w = CameraOpenCallback.NULL;

    public CameraView(Context context) {
        super(context);
        this.r = new Paint();
        this.r.setColor(this.getResources().getColor(17170443));
        this.r.setStyle(Paint.Style.STROKE);
        this.r.setStrokeWidth(this.getResources().getDimension(R.dimen.touch_focus_polygon_width));
        this.r.setAntiAlias(true);
    }

    public void onCameraOpen(Camera camera) throws RuntimeException {
        this.u.logMethod();
        super.onCameraOpen(camera);
        this.j = camera;
        this.w.onCameraOpened();
    }

    public void autoFocus() {
        this.u.logMethod();
        if (System.currentTimeMillis() - this.m < 3000L || !this.isAutoFocusAvailable()) {
            this.v.onAutoFocusCompleted();
            return;
        }
        this.k.removeCallbacks(this.l);
        this.k.postDelayed(this.l, 5000L);
        this.p = true;
        try {
            Camera.Parameters parameters = this.getCameraParameters();
            Utils.enableAutoFocus(parameters);
            this.a(parameters);
            this.setCameraParameters(parameters);
            super.autoFocus();
        }
        catch (RuntimeException runtimeException) {
            this.u.logException(runtimeException);
        }
    }

    public void cancelAutoFocus() {
        this.u.logMethod();
        super.cancelAutoFocus();
        this.c(false);
        this.p = false;
        this.k.removeCallbacks(this.l);
    }

    public boolean isAutoFocusAvailable() {
        this.u.logMethod();
        return super.isAutoFocusAvailable() && !this.p;
    }

    public void a(AutofocusCallback autofocusCallback) {
        this.u.logMethod();
        this.v = autofocusCallback != null ? autofocusCallback : AutofocusCallback.NULL;
    }

    public void a(CameraOpenCallback cameraOpenCallback) {
        this.u.logMethod();
        this.w = cameraOpenCallback != null ? cameraOpenCallback : CameraOpenCallback.NULL;
    }

    private void a(Camera.Parameters parameters) {
        List<Camera.Area> list;
        if (parameters.getMaxNumFocusAreas() > 0) {
            list = this.c();
            parameters.setFocusAreas(list);
        }
        if (parameters.getMaxNumMeteringAreas() > 0) {
            list = this.c();
            parameters.setMeteringAreas(list);
        }
    }

    private List<Camera.Area> c() {
        Rect rect;
        if (this.s != null) {
            rect = new Rect(this.a((float)this.s.left / (float)this.getWidth()), this.a((float)this.s.top / (float)this.getHeight()), this.a((float)this.s.right / (float)this.getWidth()), this.a((float)this.s.bottom / (float)this.getHeight()));
        } else if (!this.n.isEmpty()) {
            float f2 = 1.0f;
            float f3 = 0.0f;
            float f4 = 1.0f;
            float f5 = 0.0f;
            for (PointF pointF : this.n) {
                if (pointF.x < f2) {
                    f2 = pointF.x;
                }
                if (pointF.x > f3) {
                    f3 = pointF.x;
                }
                if (pointF.y < f4) {
                    f4 = pointF.y;
                }
                if (!(pointF.y > f5)) continue;
                f5 = pointF.y;
            }
            float f6 = (f3 - f2) / 2.0f - 0.075f;
            float f7 = (f3 - f2) / 2.0f + 0.075f;
            float f8 = f4;
            float f9 = f5;
            rect = new Rect(this.a(f6), this.a(f8), this.a(f7), this.a(f9));
        } else {
            rect = new Rect(-75, -75, 75, 75);
        }
        Camera.Area area = new Camera.Area(rect, 1000);
        ArrayList<Camera.Area> arrayList = new ArrayList<Camera.Area>();
        arrayList.add(area);
        return arrayList;
    }

    private int a(float f2) {
        int n2 = Math.round(f2 * 1000.0f * 2.0f + -1000.0f);
        if (n2 > 1000) {
            n2 = 1000;
        }
        if (n2 < -1000) {
            n2 = -1000;
        }
        return n2;
    }

    public void onAutoFocus(boolean success, Camera camera) {
        this.u.logMethod();
        if (this.p) {
            this.c(success);
            this.k.removeCallbacks(this.l);
            this.p = false;
            super.onAutoFocus(success, camera);
        }
        this.m = success ? System.currentTimeMillis() : 0L;
        this.v.onAutoFocusCompleted();
    }

    private void c(boolean bl) {
        if (this.s != null) {
            if (this.r.getColor() != -1) {
                this.r.setAlpha(0);
                this.invalidate();
                return;
            }
            this.r.setColor(this.getResources().getColor(bl ? 17170452 : 0x1060016));
            this.invalidate();
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (CameraView.this.r.getColor() != -1) {
                        CameraView.this.r.setAlpha(0);
                        CameraView.this.invalidate();
                    }
                }
            }, 1000L);
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (event.getAction() == 0 && this.isAutoFocusAvailable() && this.o) {
            this.a(event);
            return true;
        }
        return super.onTouchEvent(event);
    }

    private void a(MotionEvent motionEvent) {
        this.r.setColor(this.getResources().getColor(17170443));
        float f2 = motionEvent.getX();
        float f3 = motionEvent.getY();
        this.s = new Rect((int)(f2 - 75.0f), (int)(f3 - 75.0f), (int)(f2 + 75.0f), (int)(f3 + 75.0f));
        this.invalidate();
        this.autoFocus();
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.s != null) {
            canvas.drawRect(this.s, this.r);
        }
    }

    public void onResume() {
        this.u.logMethod();
        super.onResume();
        this.q = true;
    }

    public void onPause() {
        this.u.logMethod();
        super.onPause();
        this.q = false;
        this.t.b();
    }

    public void startPreview() {
        Camera.Parameters parameters;
        this.u.logMethod();
        if (this.q && (parameters = this.getCameraParameters()) != null) {
            super.startPreview();
        }
    }

    protected void startPreviewSync() {
        this.u.logMethod();
        if (this.q) {
            this.n = Collections.emptyList();
            this.s = null;
            this.p = false;
            Camera.Parameters parameters = this.getCameraParameters();
            if (parameters != null) {
                super.startPreviewSync();
                this.b(parameters);
                this.a(parameters);
                this.setCameraParametersSync(parameters);
                Camera.Size size = this.getPreviewSize();
                this.t.a(size.width, size.height);
            }
        }
    }

    public void takePicture(PictureTransaction xact) {
        this.u.logMethod();
        super.takePicture(xact);
    }

    private void b(@NotNull Camera.Parameters parameters) {
        parameters.setJpegQuality(100);
        List list = parameters.getSupportedSceneModes();
        if (list != null && list.contains(h)) {
            parameters.setSceneMode(h);
        }
    }

    public void stopPreview() {
        this.u.logMethod();
        if (this.q) {
            super.stopPreview();
        }
    }

    protected void onDetachedFromWindow() {
        this.u.logMethod();
        super.onDetachedFromWindow();
        this.t.c();
    }

    public void a(boolean bl) {
        this.o = bl;
    }

    public void a() {
        this.u.logMethod();
        this.cancelAutoFocus();
        try {
            Camera.Parameters parameters = this.getCameraParameters();
            Utils.enableContinuousFocus(parameters);
            this.setCameraParameters(parameters);
        }
        catch (RuntimeException runtimeException) {
            this.u.logException(runtimeException);
        }
    }

    public PreviewBuffer b() {
        return this.t;
    }

    public void a(PictureCallback pictureCallback) {
        this.u.logMethod();
        ((net.doo.snap.camera.a)this.getCameraHost()).a(pictureCallback);
    }

    public void b(PictureCallback pictureCallback) {
        this.u.logMethod();
        ((net.doo.snap.camera.a)this.getCameraHost()).b(pictureCallback);
    }

    @RequiresApi(api=17)
    public void b(boolean bl) {
        this.u.logMethod();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.canDisableShutterSound && this.j != null) {
            try {
                this.j.enableShutterSound(bl);
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Could not work with camera?", (Throwable)runtimeException);
            }
        }
    }

    private RectF a(int n2, int n3, CameraPreviewMode cameraPreviewMode) {
        if (this.getParent() != null && this.getParent().getParent() != null) {
            int n4;
            int n5;
            ViewParent viewParent = this.getParent().getParent();
            if (!(viewParent instanceof ViewGroup)) {
                return null;
            }
            View view = ((ViewGroup)viewParent).findViewById(R.id.finder_overlay);
            if (view == null) {
                return null;
            }
            int n6 = ((View)viewParent).getMeasuredWidth();
            int n7 = ((View)viewParent).getMeasuredHeight();
            Rect rect = new Rect();
            view.getDrawingRect(rect);
            ((ViewGroup)viewParent).offsetDescendantRectToMyCoords(view, rect);
            double d2 = (double)n7 / (double)n3;
            double d3 = (double)n6 / (double)n2;
            if (cameraPreviewMode == CameraPreviewMode.FILL_IN) {
                if (d2 > d3) {
                    n5 = (int)((double)n2 * d2);
                    n4 = (int)((double)n3 * d2);
                } else {
                    n5 = (int)((double)n2 * d3);
                    n4 = (int)((double)n3 * d3);
                }
            } else if (d2 < d3) {
                n5 = (int)((double)n2 * d2);
                n4 = (int)((double)n3 * d2);
            } else {
                n5 = (int)((double)n2 * d3);
                n4 = (int)((double)n3 * d3);
            }
            int n8 = (n5 - n6) / 2;
            int n9 = (n4 - n7) / 2;
            float f2 = (float)(n9 + rect.top) / (float)n4;
            float f3 = (float)(n8 + rect.left) / (float)n5;
            float f4 = (float)(n9 + rect.bottom) / (float)n4;
            float f5 = (float)(n8 + rect.right) / (float)n5;
            return new RectF(f3, f2, f5, f4);
        }
        return null;
    }

    private class a
    implements Camera.PreviewCallback,
    PreviewBuffer {
        private final AtomicReference<byte[]> b = new AtomicReference();
        private int c = 0;
        private int d = 0;
        private final AtomicInteger e = new AtomicInteger(0);
        private final Set<PreviewBuffer.FrameHandler> f = new LinkedHashSet<PreviewBuffer.FrameHandler>();
        private final ExecutorService g = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r2) {
                Thread thread = new Thread(r2);
                thread.setName("FRAME_DISPATCHER");
                return thread;
            }
        });

        a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addFrameHandler(PreviewBuffer.FrameHandler frameHandler) {
            CameraView.this.u.logMethod();
            Set<PreviewBuffer.FrameHandler> set = this.f;
            synchronized (set) {
                this.f.add(frameHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeFrameHandler(PreviewBuffer.FrameHandler frameHandler) {
            CameraView.this.u.logMethod();
            Set<PreviewBuffer.FrameHandler> set = this.f;
            synchronized (set) {
                this.f.remove(frameHandler);
            }
        }

        private synchronized void a(int n2, int n3) {
            this.b();
            this.c = n2;
            this.d = n3;
            if (!this.a()) {
                byte[] byArray = this.b(n2, n3);
                this.b.set(byArray);
                CameraView.this.addPreviewCallbackBuffer(byArray);
            }
            CameraView.this.setPreviewCallback(this);
        }

        private boolean a() {
            return DeviceProfile.getInstance((Context)CameraView.this.getContext()).isCustomRom();
        }

        private synchronized void b() {
            CameraView.this.setPreviewCallback(null);
        }

        private byte[] b(int n2, int n3) {
            return new byte[n2 * n3 * ImageFormat.getBitsPerPixel((int)17) / 8];
        }

        private void c() {
            this.g.shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void onPreviewFrame(byte[] frame, Camera camera) {
            if (this.d()) {
                CameraView.this.u.e("Camera", "Frame rejected - too many frames in processing");
                return;
            }
            Set<PreviewBuffer.FrameHandler> set = this.f;
            synchronized (set) {
                this.a(frame);
            }
        }

        private boolean d() {
            return this.e.get() >= 2;
        }

        private void a(final byte[] byArray) {
            if (this.g.isShutdown()) {
                return;
            }
            this.e.incrementAndGet();
            final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            final int n2 = this.c;
            final int n3 = this.d;
            final int n4 = CameraView.this.getDisplayOrientation();
            Rect rect = null;
            Camera.Parameters parameters = CameraView.this.getCameraParameters();
            if (parameters != null) {
                int n5;
                int n6;
                Camera.Size object = parameters.getPreviewSize();
                if (n4 == 0 || n4 == 180) {
                    n6 = object.width < object.height ? object.height : object.width;
                    n5 = object.width < object.height ? object.width : object.height;
                } else {
                    n6 = object.width > object.height ? object.height : object.width;
                    n5 = object.width > object.height ? object.width : object.height;
                }
                CameraPreviewMode cameraPreviewMode = ((net.doo.snap.camera.a)CameraView.this.getCameraHost()).a();
                RectF rectF = CameraView.this.a(n6, n5, cameraPreviewMode);
                if (rectF != null) {
                    rect = new Rect((int)((float)n6 * rectF.left), (int)((float)n5 * rectF.top), (int)((float)n6 * rectF.right), (int)((float)n5 * rectF.bottom));
                    if (rect.left < 0 || rect.left > n6 || rect.top < 0 || rect.top > n5 || rect.right < 0 || rect.right > n6 || rect.bottom < 0 || rect.bottom > n5 || rect.width() <= 0 || rect.height() <= 0) {
                        CameraView.this.u.e("Camera", "Finder overlay layout does not fit to the Camera preview frame.");
                        throw new IllegalStateException("Finder overlay layout does not fit to the Camera preview frame.");
                    }
                }
            }
            final Rect rect2 = rect;
            for (final PreviewBuffer.FrameHandler frameHandler : this.f) {
                this.g.execute(new Runnable(){

                    @Override
                    public void run() {
                        CameraView.this.u.logMethod();
                        if (atomicBoolean.get()) {
                            return;
                        }
                        boolean bl = frameHandler.handleFrame(byArray, n2, n3, n4, rect2);
                        atomicBoolean.set(bl);
                    }
                });
            }
            this.g.execute(new Runnable(){

                @Override
                public void run() {
                    CameraView.this.u.logMethod();
                    a.this.e.decrementAndGet();
                    if (atomicBoolean.get()) {
                        return;
                    }
                    if (a.this.b.get() == byArray) {
                        CameraView.this.addPreviewCallbackBuffer(byArray);
                    }
                }
            });
        }
    }

    public static interface AutofocusCallback {
        public static final AutofocusCallback NULL = new AutofocusCallback(){

            @Override
            public void onAutoFocusCompleted() {
            }
        };

        public void onAutoFocusCompleted();
    }
}

