/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.BarcodeDetector;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.barcode.GoogleVisionBarcodeDetector$WhenMappings;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.doo.snap.b.c;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0017J2\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J%\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u00010\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cH\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0019H\u0002J\u0016\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190%H\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/scanbot/sdk/barcode/GoogleVisionBarcodeDetector;", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "barcodeScanEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "detector", "Lcom/google/android/gms/vision/barcode/BarcodeDetector;", "sapManager", "Lio/scanbot/sap/SapManager;", "decodeWithState", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "data", "", "width", "", "height", "frameOrientation", "finderRect", "Landroid/graphics/Rect;", "enableBarcodeScan", "", "", "getAppFormat", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "googleVisionFormat", "getCornerPoints", "", "Lio/scanbot/sdk/barcode/entity/ResultPoint;", "cornerPoints", "Landroid/graphics/Point;", "([Landroid/graphics/Point;)[Lio/scanbot/sdk/barcode/entity/ResultPoint;", "getGVFormat", "barcodeFormat", "setBarcodeFormatsFilter", "barcodeFormats", "", "scanbot-sdk_release"})
public final class GoogleVisionBarcodeDetector
implements ScanbotBarcodeDetector {
    private final SapManager sapManager;
    private BarcodeDetector detector;
    private final AtomicBoolean barcodeScanEnabled;
    private final Context context;

    @Override
    public void enableBarcodeScan(boolean barcodeScanEnabled) {
        this.barcodeScanEnabled.set(barcodeScanEnabled);
    }

    @Override
    public synchronized void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> barcodeFormats) {
        Intrinsics.checkParameterIsNotNull(barcodeFormats, (String)"barcodeFormats");
        BarcodeDetector barcodeDetector = this.detector;
        if (barcodeDetector == null) {
            Intrinsics.throwNpe();
        }
        barcodeDetector.release();
        int n2 = 0;
        for (BarcodeFormat barcodeFormat : barcodeFormats) {
            n2 |= this.getGVFormat(barcodeFormat);
        }
        this.detector = new BarcodeDetector.Builder(this.context).setBarcodeFormats(n2).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] data, int width, int height, int frameOrientation) {
        BarcodeScanningResult barcodeScanningResult;
        block16: {
            block15: {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                barcodeScanningResult = null;
                if (this.barcodeScanEnabled.compareAndSet(false, false)) {
                    return null;
                }
                if (!this.sapManager.isLicenseActive()) {
                    throw (Throwable)new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
                }
                if (this.detector == null) break block15;
                BarcodeDetector barcodeDetector = this.detector;
                if (barcodeDetector == null) {
                    Intrinsics.throwNpe();
                }
                if (barcodeDetector.isOperational()) break block16;
            }
            return null;
        }
        try {
            SparseArray sparseArray;
            ByteBuffer byteBuffer = MappedByteBuffer.wrap(data);
            Frame frame = new Frame.Builder().setImageData(byteBuffer, width, height, 17).build();
            BarcodeDetector barcodeDetector = this.detector;
            if (barcodeDetector == null) {
                Intrinsics.throwNpe();
            }
            if ((sparseArray = barcodeDetector.detect(frame)).size() > 0) {
                BarcodeScanningResult barcodeScanningResult2;
                Barcode barcode = (Barcode)sparseArray.valueAt(0);
                String string2 = barcode.rawValue;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"barcode.rawValue");
                String string3 = barcode.rawValue;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"barcode.rawValue");
                String string4 = string3;
                String string5 = string2;
                BarcodeScanningResult barcodeScanningResult3 = barcodeScanningResult2;
                BarcodeScanningResult barcodeScanningResult4 = barcodeScanningResult2;
                Charset charset = Charsets.UTF_8;
                String string6 = string4;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string6.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                Intrinsics.checkExpressionValueIsNotNull((Object)barcode.cornerPoints, (String)"barcode.cornerPoints");
                barcodeScanningResult3(string5, byArray2, this.getCornerPoints(barcode.cornerPoints), this.getAppFormat(barcode.format), 0L, 16, null);
                barcodeScanningResult = barcodeScanningResult4;
            }
        }
        finally {
            BarcodeDetector barcodeDetector = this.detector;
            if (barcodeDetector == null) {
                Intrinsics.throwNpe();
            }
            barcodeDetector.release();
        }
        return barcodeScanningResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] data, int width, int height, int frameOrientation, @NotNull Rect finderRect) {
        BarcodeScanningResult barcodeScanningResult;
        block15: {
            block14: {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                Intrinsics.checkParameterIsNotNull((Object)finderRect, (String)"finderRect");
                barcodeScanningResult = null;
                if (this.barcodeScanEnabled.compareAndSet(false, false)) {
                    return null;
                }
                if (!this.sapManager.isLicenseActive()) {
                    throw (Throwable)new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
                }
                if (this.detector == null) break block14;
                BarcodeDetector barcodeDetector = this.detector;
                if (barcodeDetector == null) {
                    Intrinsics.throwNpe();
                }
                if (barcodeDetector.isOperational()) break block15;
            }
            return null;
        }
        try {
            int n2 = frameOrientation == 0 || frameOrientation == 180 ? width : height;
            int n3 = frameOrientation == 0 || frameOrientation == 180 ? finderRect.width() : finderRect.height();
            int n4 = frameOrientation == 0 || frameOrientation == 180 ? finderRect.height() : finderRect.width();
            int n5 = frameOrientation == 0 || frameOrientation == 180 ? finderRect.left : finderRect.top;
            int n6 = frameOrientation == 0 || frameOrientation == 180 ? finderRect.top : n2 - finderRect.right;
            Rect rect = new Rect(n5, n6, n5 + n3, n6 + n4);
            ByteBuffer byteBuffer = MappedByteBuffer.wrap(data);
            Frame frame = new Frame.Builder().setImageData(byteBuffer, width, height, 17).build();
            BarcodeDetector barcodeDetector = this.detector;
            if (barcodeDetector == null) {
                Intrinsics.throwNpe();
            }
            SparseArray sparseArray = barcodeDetector.detect(frame);
            int n7 = sparseArray.size();
            for (int i2 = 0; i2 < n7; ++i2) {
                BarcodeScanningResult barcodeScanningResult2;
                Barcode barcode;
                Barcode barcode2 = barcode = (Barcode)sparseArray.valueAt(i2);
                Intrinsics.checkExpressionValueIsNotNull((Object)barcode2, (String)"barcode");
                if (!rect.contains(barcode2.getBoundingBox())) continue;
                String string2 = barcode.rawValue;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"barcode.rawValue");
                String string3 = barcode.rawValue;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"barcode.rawValue");
                String string4 = string3;
                String string5 = string2;
                BarcodeScanningResult barcodeScanningResult3 = barcodeScanningResult2;
                BarcodeScanningResult barcodeScanningResult4 = barcodeScanningResult2;
                Charset charset = Charsets.UTF_8;
                String string6 = string4;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string6.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                Intrinsics.checkExpressionValueIsNotNull((Object)barcode.cornerPoints, (String)"barcode.cornerPoints");
                barcodeScanningResult3(string5, byArray2, this.getCornerPoints(barcode.cornerPoints), this.getAppFormat(barcode.format), 0L, 16, null);
                barcodeScanningResult = barcodeScanningResult4;
                break;
            }
        }
        finally {
            BarcodeDetector barcodeDetector = this.detector;
            if (barcodeDetector == null) {
                Intrinsics.throwNpe();
            }
            barcodeDetector.release();
        }
        return barcodeScanningResult;
    }

    private final ResultPoint[] getCornerPoints(Point[] cornerPoints) {
        Collection collection;
        ArrayList<ResultPoint> arrayList = new ArrayList<ResultPoint>();
        for (Point collection2 : cornerPoints) {
            arrayList.add(new ResultPoint(collection2.x, collection2.y));
        }
        Collection collection3 = collection = (Collection)arrayList;
        ResultPoint[] resultPointArray = collection3.toArray(new ResultPoint[0]);
        if (resultPointArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return resultPointArray;
    }

    private final BarcodeFormat getAppFormat(int googleVisionFormat) {
        switch (googleVisionFormat) {
            case 4096: {
                return BarcodeFormat.AZTEC;
            }
            case 8: {
                return BarcodeFormat.CODABAR;
            }
            case 2: {
                return BarcodeFormat.CODE_39;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 1: {
                return BarcodeFormat.CODE_128;
            }
            case 16: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 64: {
                return BarcodeFormat.EAN_8;
            }
            case 32: {
                return BarcodeFormat.EAN_13;
            }
            case 128: {
                return BarcodeFormat.ITF;
            }
            case 2048: {
                return BarcodeFormat.PDF_417;
            }
            case 256: {
                return BarcodeFormat.QR_CODE;
            }
            case 512: {
                return BarcodeFormat.UPC_A;
            }
            case 1024: {
                return BarcodeFormat.UPC_E;
            }
        }
        return BarcodeFormat.UNKNOWN;
    }

    private final int getGVFormat(BarcodeFormat barcodeFormat) {
        switch (GoogleVisionBarcodeDetector$WhenMappings.$EnumSwitchMapping$0[barcodeFormat.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return 0;
            }
            case 7: {
                return 4096;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 16;
            }
            case 13: {
                return 64;
            }
            case 14: {
                return 32;
            }
            case 15: {
                return 128;
            }
            case 16: {
                return 2048;
            }
            case 17: {
                return 256;
            }
            case 18: {
                return 512;
            }
            case 19: {
                return 1024;
            }
        }
        return 0;
    }

    @Inject
    public GoogleVisionBarcodeDetector(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.barcodeScanEnabled = new AtomicBoolean(true);
        this.detector = new BarcodeDetector.Builder(this.context).build();
        SapManager sapManager = c.a();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"SapSingleton.getInstance()");
        this.sapManager = sapManager;
    }
}

