/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.sdk.entity.PageImageFilter;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage$WhenMappings;
import io.scanbot.sdk.persistence.PageProcessorInteractor;
import io.scanbot.sdk.persistence.PageStorage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001$B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eJ\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0019H\u0007J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u0014\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u0019J\u001e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010#\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010#\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/scanbot/sdk/persistence/PageFileStorage;", "", "pageProcessorInteractor", "Lio/scanbot/sdk/persistence/PageProcessorInteractor;", "pageStorage", "Lio/scanbot/sdk/persistence/PageStorage;", "(Lio/scanbot/sdk/persistence/PageProcessorInteractor;Lio/scanbot/sdk/persistence/PageStorage;)V", "add", "", "image", "Landroid/graphics/Bitmap;", "configuration", "Lio/scanbot/sdk/persistence/PageProcessorInteractor$Configuration;", "add$scanbot_sdk_release", "", "getFilteredPreviewImageURI", "Landroid/net/Uri;", "pageId", "filter", "Lio/scanbot/sdk/entity/PageImageFilter;", "getImageURI", "type", "Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "getPreviewImageURI", "getStoredPages", "", "remove", "", "removeAll", "removeAllExcept", "", "pageIds", "setFilteredPreviewForId", "filteredPreview", "existingPageId", "setImageForId", "PageFileType", "scanbot-sdk_release"})
public final class PageFileStorage {
    private final PageProcessorInteractor pageProcessorInteractor;
    private final PageStorage pageStorage;

    @NotNull
    public final Uri getImageURI(@NotNull String pageId, @NotNull PageFileType type) {
        Uri uri;
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Uri uri2 = Uri.fromFile((File)this.pageStorage.getOriginalImage(pageId));
                uri = uri2;
                Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(pageStorage.getOriginalImage(pageId))");
                break;
            }
            case 2: {
                Uri uri3 = Uri.fromFile((File)this.pageStorage.getDocumentImage(pageId));
                uri = uri3;
                Intrinsics.checkExpressionValueIsNotNull((Object)uri3, (String)"Uri.fromFile(pageStorage.getDocumentImage(pageId))");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return uri;
    }

    @NotNull
    public final Uri getPreviewImageURI(@NotNull String pageId, @NotNull PageFileType type) {
        Uri uri;
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                Uri uri2 = Uri.fromFile((File)this.pageStorage.getOriginalImagePreview(pageId));
                uri = uri2;
                Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(pageStorage\u2026inalImagePreview(pageId))");
                break;
            }
            case 2: {
                Uri uri3 = Uri.fromFile((File)this.pageStorage.getDocumentImagePreview(pageId));
                uri = uri3;
                Intrinsics.checkExpressionValueIsNotNull((Object)uri3, (String)"Uri.fromFile(pageStorage\u2026mentImagePreview(pageId))");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return uri;
    }

    @NotNull
    public final Uri getFilteredPreviewImageURI(@NotNull String pageId, @NotNull PageImageFilter filter) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$2[filter.ordinal()]) {
            case 1: {
                file = this.pageStorage.getFilteredImagePreview(pageId, PageStorage.ImageFilterType.BINARIZED);
                break;
            }
            case 2: {
                file = this.pageStorage.getFilteredImagePreview(pageId, PageStorage.ImageFilterType.COLOR_DOCUMENT);
                break;
            }
            case 3: {
                file = this.pageStorage.getFilteredImagePreview(pageId, PageStorage.ImageFilterType.COLOR_ENHANCED);
                break;
            }
            case 4: {
                file = this.pageStorage.getFilteredImagePreview(pageId, PageStorage.ImageFilterType.GRAY);
                break;
            }
            case 5: {
                file = this.pageStorage.getFilteredImagePreview(pageId, PageStorage.ImageFilterType.PURE_BINARIZED);
                break;
            }
            default: {
                file = this.pageStorage.getDocumentImagePreview(pageId);
            }
        }
        File file2 = file;
        Uri uri = Uri.fromFile((File)file2);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(filteredPreviewFile)");
        return uri;
    }

    @NotNull
    public final String add(@NotNull byte[] image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        return this.add$scanbot_sdk_release(image, PageProcessorInteractor.Configuration.Companion.DEFAULT());
    }

    @NotNull
    public final String add(@NotNull Bitmap image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        return this.add$scanbot_sdk_release(image, PageProcessorInteractor.Configuration.Companion.DEFAULT());
    }

    @NotNull
    public final String add$scanbot_sdk_release(@NotNull byte[] image, @NotNull PageProcessorInteractor.Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Page page = this.pageProcessorInteractor.createPage$scanbot_sdk_release(image, configuration);
        return page.getPageId();
    }

    @NotNull
    public final String add$scanbot_sdk_release(@NotNull Bitmap image, @NotNull PageProcessorInteractor.Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Page page = this.pageProcessorInteractor.createPage$scanbot_sdk_release(image, configuration);
        return page.getPageId();
    }

    public final void setImageForId(@NotNull byte[] image, @NotNull String existingPageId, @NotNull PageFileType type) {
        File file;
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$3[type.ordinal()]) {
            case 1: {
                file2 = this.pageStorage.getOriginalImage(existingPageId);
                break;
            }
            case 2: {
                file2 = this.pageStorage.getDocumentImage(existingPageId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file3 = file2;
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$4[type.ordinal()]) {
            case 1: {
                file = this.pageStorage.getOriginalImagePreview(existingPageId);
                break;
            }
            case 2: {
                file = this.pageStorage.getDocumentImagePreview(existingPageId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file4 = file;
        this.pageProcessorInteractor.saveBitmapTo(file3, image);
        this.pageProcessorInteractor.createPreviewTo(file4, image);
    }

    public final void setImageForId(@NotNull Bitmap image, @NotNull String existingPageId, @NotNull PageFileType type) {
        File file;
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$5[type.ordinal()]) {
            case 1: {
                file2 = this.pageStorage.getOriginalImage(existingPageId);
                break;
            }
            case 2: {
                file2 = this.pageStorage.getDocumentImage(existingPageId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file3 = file2;
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$6[type.ordinal()]) {
            case 1: {
                file = this.pageStorage.getOriginalImagePreview(existingPageId);
                break;
            }
            case 2: {
                file = this.pageStorage.getDocumentImagePreview(existingPageId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file4 = file;
        this.pageProcessorInteractor.saveBitmapTo(file3, image);
        this.pageProcessorInteractor.createPreviewTo(file4, image);
    }

    public final void setFilteredPreviewForId(@NotNull byte[] filteredPreview, @NotNull String existingPageId, @NotNull PageImageFilter filter) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)filteredPreview, (String)"filteredPreview");
        Intrinsics.checkParameterIsNotNull((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$7[filter.ordinal()]) {
            case 1: {
                file = this.pageStorage.getFilteredImagePreview(existingPageId, PageStorage.ImageFilterType.BINARIZED);
                break;
            }
            case 2: {
                file = this.pageStorage.getFilteredImagePreview(existingPageId, PageStorage.ImageFilterType.COLOR_DOCUMENT);
                break;
            }
            case 3: {
                file = this.pageStorage.getFilteredImagePreview(existingPageId, PageStorage.ImageFilterType.COLOR_ENHANCED);
                break;
            }
            case 4: {
                file = this.pageStorage.getFilteredImagePreview(existingPageId, PageStorage.ImageFilterType.GRAY);
                break;
            }
            case 5: {
                file = this.pageStorage.getFilteredImagePreview(existingPageId, PageStorage.ImageFilterType.PURE_BINARIZED);
                break;
            }
            default: {
                file = this.pageStorage.getDocumentImagePreview(existingPageId);
            }
        }
        File file2 = file;
        this.pageProcessorInteractor.saveBitmapTo(file2, filteredPreview);
    }

    public final void setFilteredPreviewForId(@NotNull Bitmap filteredPreview, @NotNull String existingPageId, @NotNull PageImageFilter filter) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)filteredPreview, (String)"filteredPreview");
        Intrinsics.checkParameterIsNotNull((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$8[filter.ordinal()]) {
            case 1: {
                file = this.pageStorage.getFilteredImagePreview(existingPageId, PageStorage.ImageFilterType.BINARIZED);
                break;
            }
            case 2: {
                file = this.pageStorage.getFilteredImagePreview(existingPageId, PageStorage.ImageFilterType.COLOR_DOCUMENT);
                break;
            }
            case 3: {
                file = this.pageStorage.getFilteredImagePreview(existingPageId, PageStorage.ImageFilterType.COLOR_ENHANCED);
                break;
            }
            case 4: {
                file = this.pageStorage.getFilteredImagePreview(existingPageId, PageStorage.ImageFilterType.GRAY);
                break;
            }
            case 5: {
                file = this.pageStorage.getFilteredImagePreview(existingPageId, PageStorage.ImageFilterType.PURE_BINARIZED);
                break;
            }
            default: {
                file = this.pageStorage.getDocumentImagePreview(existingPageId);
            }
        }
        File file2 = file;
        this.pageProcessorInteractor.saveBitmapTo(file2, filteredPreview);
    }

    public final boolean remove(@NotNull String pageId) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        return FilesKt.deleteRecursively((File)this.pageStorage.getPageDir(pageId));
    }

    public final boolean removeAll() {
        return FilesKt.deleteRecursively((File)this.pageStorage.getPagesDirectory());
    }

    @NotNull
    public final List<String> getStoredPages() throws IOException {
        return this.pageStorage.getStoredPages();
    }

    public final void removeAllExcept(@NotNull List<String> pageIds) {
        Intrinsics.checkParameterIsNotNull(pageIds, (String)"pageIds");
        List list = new ArrayList();
        File[] fileArray = this.pageStorage.getPagesDirectory().listFiles();
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File file;
            File file2 = file = fileArray[i2];
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"listFile");
            if (pageIds.contains(file2.getName())) continue;
            list.add(file);
        }
        for (File file : list) {
            file.delete();
        }
    }

    @Inject
    public PageFileStorage(@NotNull PageProcessorInteractor pageProcessorInteractor, @NotNull PageStorage pageStorage) {
        Intrinsics.checkParameterIsNotNull((Object)pageProcessorInteractor, (String)"pageProcessorInteractor");
        Intrinsics.checkParameterIsNotNull((Object)pageStorage, (String)"pageStorage");
        this.pageProcessorInteractor = pageProcessorInteractor;
        this.pageStorage = pageStorage;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "", "(Ljava/lang/String;I)V", "ORIGINAL", "DOCUMENT", "scanbot-sdk_release"})
    public static final class PageFileType
    extends Enum<PageFileType> {
        public static final /* enum */ PageFileType ORIGINAL;
        public static final /* enum */ PageFileType DOCUMENT;
        private static final /* synthetic */ PageFileType[] $VALUES;

        static {
            PageFileType[] pageFileTypeArray = new PageFileType[2];
            PageFileType[] pageFileTypeArray2 = pageFileTypeArray;
            pageFileTypeArray[0] = ORIGINAL = new PageFileType();
            pageFileTypeArray[1] = DOCUMENT = new PageFileType();
            $VALUES = pageFileTypeArray;
        }

        public static PageFileType[] values() {
            return (PageFileType[])$VALUES.clone();
        }

        public static PageFileType valueOf(String string2) {
            return Enum.valueOf(PageFileType.class, string2);
        }
    }
}

