/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.MediaStore;
import io.scanbot.sdk.entity.PageImageFilter;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.lib.detector.ContourDetector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/process/PageProcessor;", "", "context", "Landroid/content/Context;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "(Landroid/content/Context;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "contourDetector", "Lnet/doo/snap/lib/detector/ContourDetector;", "applyFilter", "Lio/scanbot/sdk/persistence/Page;", "page", "filter", "Lio/scanbot/sdk/entity/PageImageFilter;", "generateFilteredPreview", "Landroid/graphics/Bitmap;", "scanbot-sdk_release"})
public final class PageProcessor {
    private ContourDetector contourDetector;
    private Context context;
    private final PageFileStorage pageFileStorage;

    @NotNull
    public final Page applyFilter(@NotNull Page page, @NotNull PageImageFilter filter) throws IOException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Document image does not exists for this page.");
        }
        Bitmap bitmap2 = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        Bitmap bitmap3 = bitmap = this.contourDetector.processImageF(bitmap2, CollectionsKt.emptyList(), filter.getCode());
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"processImageF");
        this.pageFileStorage.setImageForId(bitmap3, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        return new Page(page.getPageId(), page.getPolygon(), page.getDetectionStatus(), filter);
    }

    @NotNull
    public final Bitmap generateFilteredPreview(@NotNull Page page, @NotNull PageImageFilter filter) throws IOException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Uri uri = this.pageFileStorage.getPreviewImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Document image does not exists for this page.");
        }
        Bitmap bitmap2 = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        Bitmap bitmap3 = bitmap = this.contourDetector.processImageF(bitmap2, CollectionsKt.emptyList(), filter.getCode());
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"filteredPreviewBitmap");
        this.pageFileStorage.setFilteredPreviewForId(bitmap3, page.getPageId(), filter);
        return bitmap;
    }

    @Inject
    public PageProcessor(@NotNull Context context, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        this.context = context;
        this.pageFileStorage = pageFileStorage;
        this.contourDetector = new ContourDetector();
    }
}

