/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.app.Application;
import android.content.Context;
import android.preference.PreferenceManager;
import io.scanbot.sdk.persistence.PageStorageBase;
import io.scanbot.sdk.persistence.PageStorageSettings;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.util.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/persistence/CustomPageStorage;", "Lio/scanbot/sdk/persistence/PageStorageBase;", "application", "Landroid/app/Application;", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "(Landroid/app/Application;Lio/scanbot/sdk/persistence/PageStorageSettings;)V", "getApplication", "()Landroid/app/Application;", "getPageStorageSettings", "()Lio/scanbot/sdk/persistence/PageStorageSettings;", "sdkImagesFolderName", "", "getPagesDirectory", "Ljava/io/File;", "context", "getPagesDirectory$scanbot_sdk_release", "scanbot-sdk_release"})
public final class CustomPageStorage
extends PageStorageBase {
    private final String sdkImagesFolderName = "snapping_pages";
    @NotNull
    private final Application application;
    @NotNull
    private final PageStorageSettings pageStorageSettings;

    @Override
    @NotNull
    public File getPagesDirectory() {
        return this.getPagesDirectory$scanbot_sdk_release(this.application);
    }

    @Override
    @NotNull
    public File getPagesDirectory$scanbot_sdk_release(@NotNull Application context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string2 = PreferenceManager.getDefaultSharedPreferences((Context)((Context)context)).getString("CUSTOM_SDK_FILES_PATH", "");
        if (!FileUtils.ensureDirExists(string2)) {
            throw (Throwable)new IOException("Custom SDK files path path cannot be empty.");
        }
        File file = FileUtils.getFilesDirOrShowError(string2, this.sdkImagesFolderName);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"getFilesDirOrShowError(s\u2026ath, sdkImagesFolderName)");
        return file;
    }

    @NotNull
    public final Application getApplication() {
        return this.application;
    }

    @NotNull
    public final PageStorageSettings getPageStorageSettings() {
        return this.pageStorageSettings;
    }

    @Inject
    public CustomPageStorage(@NotNull Application application, @NotNull PageStorageSettings pageStorageSettings) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)pageStorageSettings, (String)"pageStorageSettings");
        super(application, pageStorageSettings);
        this.application = application;
        this.pageStorageSettings = pageStorageSettings;
        this.sdkImagesFolderName = "snapping_pages";
    }
}

