/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.chequescanner;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.chequescanner.model.Result;
import io.scanbot.sap.SapManager;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.b.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.chequescanner.ChequeScanner;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ChequeScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private ChequeScanner chequeScanner;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private boolean enabled = true;

    public static ChequeScannerFrameHandler attach(ScanbotCameraView cameraView, ChequeScanner chequeScanner) {
        ChequeScannerFrameHandler chequeScannerFrameHandler = new ChequeScannerFrameHandler(cameraView.getContext(), chequeScanner);
        cameraView.getPreviewBuffer().addFrameHandler(chequeScannerFrameHandler);
        return chequeScannerFrameHandler;
    }

    public ChequeScannerFrameHandler(Context context, ChequeScanner chequeScanner) {
        this.chequeScanner = chequeScanner;
        this.sapManager = c.a();
    }

    @Override
    public synchronized boolean handleFrame(byte[] frame, int width, int height, int frameOrientation, Rect finderRect) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        Result result = this.chequeScanner.recognizeCheque(frame, width, height, frameOrientation);
        return this.notifyHandlers(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(Result recognitionResult) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handleResult(recognitionResult);
            }
        }
        return bl;
    }

    public static interface ResultHandler {
        public boolean handleResult(Result var1);
    }
}

