/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.util.Log;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.a.a;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.persistence.PageStorageSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.c.c;
import net.doo.snap.entity.Blob;
import net.doo.snap.injection.k;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.log.StubLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0002)*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001bJ\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer;", "", "()V", "fetchChequeBlobs", "", "fetchMRZBlobs", "fetchOCRLanguagesBlobs", "logger", "Lnet/doo/snap/util/log/Logger;", "getLogger", "()Lnet/doo/snap/util/log/Logger;", "setLogger", "(Lnet/doo/snap/util/log/Logger;)V", "useLog", "getUseLog", "()Z", "setUseLog", "(Z)V", "documentDraftExtractor", "extractor", "Lnet/doo/snap/process/draft/DocumentDraftExtractor;", "fetchBlobs", "", "application", "Landroid/app/Application;", "initialize", "license", "", "ocrBlobsPath", "sdkFilesDirectory", "Ljava/io/File;", "unreferencedSourcesProvider", "provider", "Lnet/doo/snap/persistence/cleanup/UnreferencedSourcesProvider;", "useBarcodeDetector", "barcodeDetector", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector$BarcodeDetectorType;", "usePageStorageSettings", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "withLogging", "Companion", "FetchBlobsTask", "scanbot-sdk_release"})
public final class ScanbotSDKInitializer {
    private boolean useLog;
    @Nullable
    private Logger logger;
    private boolean fetchOCRLanguagesBlobs;
    private boolean fetchMRZBlobs;
    private boolean fetchChequeBlobs;
    private static boolean initialized;
    public static final Companion Companion;

    protected final boolean getUseLog() {
        return this.useLog;
    }

    protected final void setUseLog(boolean bl) {
        this.useLog = bl;
    }

    @Nullable
    protected final Logger getLogger() {
        return this.logger;
    }

    protected final void setLogger(@Nullable Logger logger) {
        this.logger = logger;
    }

    @NotNull
    public final ScanbotSDKInitializer withLogging(boolean useLog) {
        if (useLog) {
            Log.w((String)"Scanbot SDK", (String)"Logging enabled in non-debug build, consider switching it off");
        }
        this.useLog = useLog;
        if (!useLog) {
            this.logger = new StubLogger();
        }
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer license(@NotNull Application application, @NotNull String license) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)((Context)application));
        sharedPreferences.edit().putString("SCANBOT_SDK_LICENSE_KEY", license).apply();
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer ocrBlobsPath(@NotNull Application application, @NotNull String ocrBlobsPath) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)ocrBlobsPath, (String)"ocrBlobsPath");
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)((Context)application));
        sharedPreferences.edit().putString("SCANBOT_SDK_OCR_BLOBS_PATH", ocrBlobsPath).apply();
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer fetchOCRLanguagesBlobs(boolean fetchOCRLanguagesBlobs) {
        this.fetchOCRLanguagesBlobs = fetchOCRLanguagesBlobs;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer fetchMRZBlobs(boolean fetchMRZBlobs) {
        this.fetchMRZBlobs = fetchMRZBlobs;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer fetchChequeBlobs(boolean fetchChequeBlobs) {
        this.fetchChequeBlobs = fetchChequeBlobs;
        return this;
    }

    public final void initialize(@NotNull Application application) {
        SapManager sapManager;
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        LoggerProvider.setLogger(this.logger == null ? (this.useLog ? (Logger)new DebugLog((Context)application) : (Logger)new StubLogger()) : this.logger);
        c.a((Context)application);
        SapManager sapManager2 = sapManager = c.a();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager2, (String)"sapManager");
        boolean bl = sapManager2.isLicenseActive();
        String string2 = "ScanbotSDK license is " + (bl ? "valid." : "not valid or expired.");
        LoggerProvider.getLogger().i("ScanbotSDKInitializer", string2);
        initialized = true;
        this.fetchBlobs(application);
    }

    private final void fetchBlobs(Application application) {
        new FetchBlobsTask(application, this.fetchOCRLanguagesBlobs, this.fetchMRZBlobs, this.fetchChequeBlobs).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
    }

    @NotNull
    public final ScanbotSDKInitializer documentDraftExtractor(@NotNull DocumentDraftExtractor extractor) {
        Intrinsics.checkParameterIsNotNull((Object)extractor, (String)"extractor");
        k.a = extractor;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer unreferencedSourcesProvider(@NotNull UnreferencedSourcesProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        k.b = provider;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer sdkFilesDirectory(@NotNull Application application, @NotNull File sdkFilesDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)sdkFilesDirectory, (String)"sdkFilesDirectory");
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)((Context)application));
        sharedPreferences.edit().putString("CUSTOM_SDK_FILES_PATH", sdkFilesDirectory.getPath()).apply();
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer logger(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer useBarcodeDetector(@NotNull ScanbotBarcodeDetector.BarcodeDetectorType barcodeDetector) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)barcodeDetector), (String)"barcodeDetector");
        k.c = barcodeDetector;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer usePageStorageSettings(@NotNull PageStorageSettings pageStorageSettings) {
        Intrinsics.checkParameterIsNotNull((Object)pageStorageSettings, (String)"pageStorageSettings");
        a.a.a(pageStorageSettings);
        return this;
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$setInitialized$cp(boolean bl) {
        initialized = bl;
    }

    @JvmStatic
    public static final boolean isInitialized() {
        return Companion.isInitialized();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ'\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\u0012\"\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0014"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$FetchBlobsTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "application", "Landroid/app/Application;", "fetchOCRLanguagesBlobs", "", "fetchMRZBlobs", "fetchChequeBlobs", "(Lio/scanbot/sdk/ScanbotSDKInitializer;Landroid/app/Application;ZZZ)V", "getApplication", "()Landroid/app/Application;", "getFetchChequeBlobs", "()Z", "getFetchMRZBlobs", "getFetchOCRLanguagesBlobs", "doInBackground", "params", "", "([Ljava/lang/Void;)Ljava/lang/Void;", "scanbot-sdk_release"})
    public final class FetchBlobsTask
    extends AsyncTask<Void, Void, Void> {
        @NotNull
        private final Application application;
        private final boolean fetchOCRLanguagesBlobs;
        private final boolean fetchMRZBlobs;
        private final boolean fetchChequeBlobs;

        @Nullable
        protected Void doInBackground(Void ... params) {
            Collection collection;
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            ScanbotSDK scanbotSDK = new ScanbotSDK(this.application);
            BlobManager blobManager = scanbotSDK.blobManager();
            BlobFactory blobFactory = scanbotSDK.blobFactory();
            if (this.fetchOCRLanguagesBlobs) {
                collection = new ArrayList();
                Collection<Blob> collection2 = blobFactory.ocrLanguageBlobs();
                Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"blobFactory.ocrLanguageBlobs()");
                collection.addAll(collection2);
                for (Blob blob4 : collection) {
                    if (blobManager.isBlobAvailable(blob4)) continue;
                    blobManager.fetch(blob4);
                }
            }
            if (this.fetchMRZBlobs) {
                collection = new ArrayList();
                Blob blob = blobFactory.bankDataBlob();
                Intrinsics.checkExpressionValueIsNotNull((Object)blob, (String)"blobFactory.bankDataBlob()");
                collection.add(blob);
                Blob blob2 = blobFactory.mrzTraineddataBlob();
                Intrinsics.checkExpressionValueIsNotNull((Object)blob2, (String)"blobFactory.mrzTraineddataBlob()");
                collection.add(blob2);
                Blob blob3 = blobFactory.mrzCascadeBlob();
                Intrinsics.checkExpressionValueIsNotNull((Object)blob3, (String)"blobFactory.mrzCascadeBlob()");
                collection.add(blob3);
                for (Blob blob4 : collection) {
                    if (blobManager.isBlobAvailable(blob4)) continue;
                    blobManager.fetch(blob4);
                }
            }
            if (this.fetchChequeBlobs) {
                collection = new ArrayList();
                Blob blob = blobFactory.chequeTraineddataBlob();
                Intrinsics.checkExpressionValueIsNotNull((Object)blob, (String)"blobFactory.chequeTraineddataBlob()");
                collection.add(blob);
                Blob blob5 = blobFactory.accountNumberCascadeBlob();
                Intrinsics.checkExpressionValueIsNotNull((Object)blob5, (String)"blobFactory.accountNumberCascadeBlob()");
                collection.add(blob5);
                Blob blob6 = blobFactory.routingNumberCascadeBlob();
                Intrinsics.checkExpressionValueIsNotNull((Object)blob6, (String)"blobFactory.routingNumberCascadeBlob()");
                collection.add(blob6);
                for (Blob blob4 : collection) {
                    if (blobManager.isBlobAvailable(blob4)) continue;
                    blobManager.fetch(blob4);
                }
            }
            return null;
        }

        @NotNull
        public final Application getApplication() {
            return this.application;
        }

        public final boolean getFetchOCRLanguagesBlobs() {
            return this.fetchOCRLanguagesBlobs;
        }

        public final boolean getFetchMRZBlobs() {
            return this.fetchMRZBlobs;
        }

        public final boolean getFetchChequeBlobs() {
            return this.fetchChequeBlobs;
        }

        public FetchBlobsTask(@NotNull Application application, boolean fetchOCRLanguagesBlobs, boolean fetchMRZBlobs, boolean fetchChequeBlobs) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            this.application = application;
            this.fetchOCRLanguagesBlobs = fetchOCRLanguagesBlobs;
            this.fetchMRZBlobs = fetchMRZBlobs;
            this.fetchChequeBlobs = fetchChequeBlobs;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$Companion;", "", "()V", "initialized", "", "isInitialized", "scanbot-sdk_release"})
    public static final class Companion {
        @JvmStatic
        public final boolean isInitialized() {
            return initialized;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

