/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;
import net.doo.snap.b.b;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.process.PDFProcessor;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class c
implements Composer {
    private final Logger a = LoggerProvider.getLogger();
    private final DocumentStoreStrategy b;
    private final BlobManager c;
    private final b d;
    private final PDFProcessor e;
    private final SimpleComposer f;
    private final SapManager g;

    @Inject
    public c(DocumentStoreStrategy documentStoreStrategy, BlobManager blobManager, b b2, PDFProcessor pDFProcessor, SimpleComposer simpleComposer, SapManager sapManager) {
        this.g = sapManager;
        this.b = documentStoreStrategy;
        this.c = blobManager;
        this.d = b2;
        this.e = pDFProcessor;
        this.f = simpleComposer;
    }

    @Override
    public void composeDocument(Document document, Page ... pages) throws IOException {
        if (!this.g.isLicenseActive() || !this.g.isFeatureEnabled(16)) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        try {
            long l2 = SystemClock.elapsedRealtime();
            Set<Language> set = this.c.getAllLanguagesWithAvailableOcrBlobs();
            if (set == null || set.isEmpty()) {
                this.a.d("OCR", "OCR languages blobs are not available - abort OCR");
                throw new IOException("OCR languages blobs are not available");
            }
            String string2 = this.a(document, pages, set);
            this.a(document, string2);
            this.a(document, l2);
        }
        catch (IOException iOException) {
            this.f.composeDocument(document, pages);
        }
    }

    private String a(Document document, Page[] pageArray, Set<Language> set) throws IOException {
        String string2 = this.b(document, pageArray, set);
        this.e.processPDF(document, pageArray);
        return string2;
    }

    private String b(Document document, Page[] pageArray, Set<Language> set) throws IOException {
        this.a.d("OCR", "Starting OCR with languages: " + set.toString());
        String string2 = this.c(document, pageArray, set);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String c(Document document, Page[] pageArray, Set<Language> set) throws IOException {
        String string2 = null;
        b.a a2 = this.d.a(document, pageArray, set);
        try {
            while (a2.a()) {
                this.a.d("OCR", "Page rendered: " + a2.b());
            }
            string2 = a2.b();
        }
        finally {
            a2.h();
        }
        return string2;
    }

    private void a(Document document, String string2) {
        document.setOcrStatus(OcrStatus.DONE);
        document.setOcrText(string2);
        this.a(document);
    }

    private void a(Document document, long l2) {
        if (document.getLanguage() == null) {
            return;
        }
        long l3 = SystemClock.elapsedRealtime() - l2;
        this.a.d("OCR", "Ocr total: " + (float)l3 / 1000.0f + " sec");
    }

    private void a(Document document) {
        if (document.getLanguage() != null) {
            this.a.d("OCR", "Document language assigned: " + document.getLanguage().getIsoCode());
        }
    }
}

