/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import android.util.SparseArray;
import net.doo.snap.entity.d;

public enum RotationType {
    ROTATION_0(0),
    ROTATION_90(90),
    ROTATION_180(180),
    ROTATION_270(270),
    ROTATION_360(360);

    private static final SparseArray<RotationType> degrees2Type;
    private final int degrees;

    private RotationType(int n3) {
        this.degrees = n3;
    }

    public static RotationType rotateClockwise(RotationType rotationType) {
        RotationType rotationType2 = ROTATION_0;
        switch (d.a[rotationType.ordinal()]) {
            default: {
                break;
            }
            case 5: {
                rotationType2 = ROTATION_360;
                break;
            }
            case 4: {
                rotationType2 = ROTATION_270;
                break;
            }
            case 3: {
                rotationType2 = ROTATION_180;
                break;
            }
            case 1: 
            case 2: {
                rotationType2 = ROTATION_90;
            }
        }
        return rotationType2;
    }

    public static RotationType getByDegrees(int n2) {
        RotationType rotationType = (RotationType)((Object)degrees2Type.get(n2));
        if (rotationType != null) {
            return rotationType;
        }
        throw new IllegalStateException("no rottation type for: " + n2);
    }

    static {
        degrees2Type = new SparseArray();
        for (RotationType rotationType : RotationType.values()) {
            degrees2Type.put(rotationType.degrees, (Object)rotationType);
        }
    }

    public int getDegrees() {
        return this.degrees;
    }
}

