/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import io.scanbot.sdk.d.a;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageProcessor$WhenMappings;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.process.ImageFilterType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001cB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bJ\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor;", "", "pageStorage", "Lio/scanbot/sdk/persistence/PageStorage;", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "(Lio/scanbot/sdk/persistence/PageStorage;Lio/scanbot/sdk/persistence/PageStorageSettings;)V", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "createPage", "Lio/scanbot/sdk/persistence/Page;", "srcImage", "Landroid/graphics/Bitmap;", "configuration", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "createPage$scanbot_sdk_release", "", "createPreviewTo", "previewFile", "Ljava/io/File;", "bitmap", "image", "erasePageData", "", "page", "saveBitmapTo", "file", "Configuration", "scanbot-sdk_release"})
public final class PageStorageProcessor {
    private final Logger logger;
    private final PageStorage pageStorage;
    private final PageStorageSettings pageStorageSettings;

    @NotNull
    public final Page createPage$scanbot_sdk_release(@NotNull byte[] srcImage, @NotNull Configuration configuration) {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)srcImage, (String)"srcImage");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        BitmapFactory.Options options = new BitmapFactory.Options();
        Bitmap bitmap2 = bitmap = BitmapFactory.decodeByteArray((byte[])srcImage, (int)0, (int)srcImage.length, (BitmapFactory.Options)options);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"originalBitmap");
        return this.createPage$scanbot_sdk_release(bitmap2, configuration);
    }

    @NotNull
    public final Page createPage$scanbot_sdk_release(@NotNull Bitmap srcImage, @NotNull Configuration configuration) {
        ContourDetector contourDetector;
        int n2;
        double d2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)srcImage, (String)"srcImage");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UUID.randomUUID().toString()");
        String string3 = string2;
        File file = this.pageStorage.getPageDir(string3);
        FileUtils.forceMkdir((File)file);
        Bitmap bitmap = srcImage;
        if (configuration.getImageOrientation() > 0 || configuration.getImageScale() != 1.0f) {
            object = new Matrix();
            if (configuration.getImageOrientation() > 0) {
                object.setRotate((float)configuration.getImageOrientation(), (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
            }
            if (configuration.getImageScale() != 1.0f) {
                object.postScale(configuration.getImageScale(), configuration.getImageScale());
            }
            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)object, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(orig\u2026ap.height, matrix, false)");
            bitmap = bitmap2;
        }
        this.saveBitmapTo(this.pageStorage.getOriginalImage(string3), bitmap);
        if (configuration.getCreatePreview()) {
            int n3 = bitmap.getHeight();
            int n4 = bitmap.getWidth();
            d2 = this.pageStorageSettings.getPreviewTargetMax();
            boolean bl = false;
            n2 = Math.max(n3, n4);
            double d3 = d2 / (double)n2;
            contourDetector = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * d3)), (int)((int)((double)bitmap.getHeight() * d3)), (boolean)false);
            File file2 = this.pageStorage.getOriginalImagePreview(string3);
            ContourDetector contourDetector2 = contourDetector;
            Intrinsics.checkExpressionValueIsNotNull((Object)contourDetector2, (String)"preview");
            this.saveBitmapTo(file2, (Bitmap)contourDetector2);
        }
        object = a.a.a();
        DetectionResult detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
        if (configuration.getCreateDocument()) {
            Bitmap bitmap3;
            contourDetector = new ContourDetector();
            contourDetector.setRequiredAspectRatios(configuration.getRequiredAspectRatios());
            contourDetector.setRectOfInterest(configuration.getRectOfInterest());
            DetectionResult detectionResult2 = contourDetector.detect(bitmap);
            Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult2, (String)"detector.detect(originalBitmap)");
            detectionResult = detectionResult2;
            if (detectionResult != DetectionResult.ERROR_NOTHING_DETECTED && detectionResult != DetectionResult.ERROR_TOO_DARK && detectionResult != DetectionResult.ERROR_TOO_NOISY) {
                List list = contourDetector.getPolygonF();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"detector.polygonF");
                object = list;
            }
            Bitmap bitmap4 = contourDetector.processImageF(bitmap, (List)object, ImageFilterType.NONE.getCode());
            if (configuration.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && configuration.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE) {
                Bitmap bitmap5 = BitmapUtils.scaleIfNeeded(bitmap4, configuration.getDocumentImageSizeLimit().getWidth(), configuration.getDocumentImageSizeLimit().getHeight());
                bitmap3 = bitmap5;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"BitmapUtils.scaleIfNeede\u2026entImageSizeLimit.height)");
            } else {
                Bitmap bitmap6 = bitmap4;
                bitmap3 = bitmap6;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap6, (String)"documentBitmapBeforeScaling");
            }
            Bitmap bitmap7 = bitmap3;
            this.saveBitmapTo(this.pageStorage.getDocumentImage(string3), bitmap7);
            this.saveBitmapTo(this.pageStorage.getUnfilteredDocumentImage(string3), bitmap7);
            if (configuration.getCreatePreview()) {
                int n5 = bitmap7.getHeight();
                int n6 = bitmap7.getWidth();
                d2 = this.pageStorageSettings.getPreviewTargetMax();
                boolean bl = false;
                n2 = Math.max(n5, n6);
                double d4 = d2 / (double)n2;
                Bitmap bitmap8 = Bitmap.createScaledBitmap((Bitmap)bitmap7, (int)((int)((double)bitmap7.getWidth() * d4)), (int)((int)((double)bitmap7.getHeight() * d4)), (boolean)false);
                File file3 = this.pageStorage.getDocumentImagePreview(string3);
                Bitmap bitmap9 = bitmap8;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap9, (String)"preview");
                this.saveBitmapTo(file3, bitmap9);
                this.saveBitmapTo(this.pageStorage.getUnfilteredDocumentImagePreview(string3), bitmap8);
            }
        }
        contourDetector = detectionResult;
        ImageFilterType imageFilterType = null;
        Page.Size size = new Page.Size(configuration.getDocumentImageSizeLimit().getWidth(), configuration.getDocumentImageSizeLimit().getHeight());
        return new Page(string3, (List)object, (DetectionResult)contourDetector, imageFilterType, size, 8, null);
    }

    public final void saveBitmapTo(@NotNull File file, @NotNull byte[] bitmap) {
        Bitmap bitmap2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        BitmapFactory.Options options = new BitmapFactory.Options();
        Bitmap bitmap3 = bitmap2 = BitmapFactory.decodeByteArray((byte[])bitmap, (int)0, (int)bitmap.length, (BitmapFactory.Options)options);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"originalBitmap");
        this.saveBitmapTo(file, bitmap3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveBitmapTo(@NotNull File file, @NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        FileOutputStream fileOutputStream = null;
        try {
            Bitmap.CompressFormat compressFormat;
            fileOutputStream = new FileOutputStream(file);
            switch (PageStorageProcessor$WhenMappings.$EnumSwitchMapping$0[this.pageStorageSettings.getImageFormat().ordinal()]) {
                case 1: {
                    compressFormat = Bitmap.CompressFormat.JPEG;
                    break;
                }
                case 2: {
                    compressFormat = Bitmap.CompressFormat.PNG;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Bitmap.CompressFormat compressFormat2 = compressFormat;
            bitmap.compress(compressFormat2, this.pageStorageSettings.getImageQuality(), (OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            this.logger.logException(iOException);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }

    @NotNull
    public final Bitmap createPreviewTo(@NotNull File previewFile, @NotNull byte[] image) {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)previewFile, (String)"previewFile");
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Bitmap bitmap2 = BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
        double d2 = this.pageStorageSettings.getPreviewTargetMax();
        Bitmap bitmap3 = bitmap2;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"bitmap");
        int n2 = bitmap3.getHeight();
        int n3 = bitmap2.getWidth();
        double d3 = d2;
        boolean bl = false;
        int n4 = Math.max(n2, n3);
        double d4 = d3 / (double)n4;
        Bitmap bitmap4 = bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)((int)((double)bitmap2.getWidth() * d4)), (int)((int)((double)bitmap2.getHeight() * d4)), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"preview");
        this.saveBitmapTo(previewFile, bitmap4);
        return bitmap;
    }

    @NotNull
    public final Bitmap createPreviewTo(@NotNull File previewFile, @NotNull Bitmap bitmap) {
        Bitmap bitmap2;
        Intrinsics.checkParameterIsNotNull((Object)previewFile, (String)"previewFile");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int n2 = bitmap.getHeight();
        int n3 = bitmap.getWidth();
        double d2 = this.pageStorageSettings.getPreviewTargetMax();
        boolean bl = false;
        int n4 = Math.max(n2, n3);
        double d3 = d2 / (double)n4;
        Bitmap bitmap3 = bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * d3)), (int)((int)((double)bitmap.getHeight() * d3)), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"preview");
        this.saveBitmapTo(previewFile, bitmap3);
        return bitmap2;
    }

    public final void erasePageData(@NotNull Page page) {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        try {
            File file = this.pageStorage.getPageDir(page.getPageId());
            if (file.exists() && file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
            }
        }
        catch (IOException iOException) {
            this.logger.logException(iOException);
        }
    }

    @Inject
    public PageStorageProcessor(@NotNull PageStorage pageStorage, @NotNull PageStorageSettings pageStorageSettings) {
        Intrinsics.checkParameterIsNotNull((Object)pageStorage, (String)"pageStorage");
        Intrinsics.checkParameterIsNotNull((Object)pageStorageSettings, (String)"pageStorageSettings");
        this.pageStorage = pageStorage;
        this.pageStorageSettings = pageStorageSettings;
        this.logger = LoggerProvider.getLogger();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0002+,BQ\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J\t\u0010$\u001a\u00020\u000fH\u00c6\u0003JU\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\nH\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "", "createPreview", "", "createDocument", "documentImageSizeLimit", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "imageScale", "", "imageOrientation", "", "requiredAspectRatios", "", "Lnet/doo/snap/lib/detector/PageAspectRatio;", "rectOfInterest", "Landroid/graphics/RectF;", "(ZZLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;FILjava/util/List;Landroid/graphics/RectF;)V", "getCreateDocument", "()Z", "getCreatePreview", "getDocumentImageSizeLimit", "()Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "getImageOrientation", "()I", "getImageScale", "()F", "getRectOfInterest", "()Landroid/graphics/RectF;", "getRequiredAspectRatios", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "Size", "scanbot-sdk_release"})
    public static final class Configuration {
        private final boolean createPreview;
        private final boolean createDocument;
        @NotNull
        private final Size documentImageSizeLimit;
        private final float imageScale;
        private final int imageOrientation;
        @NotNull
        private final List<PageAspectRatio> requiredAspectRatios;
        @NotNull
        private final RectF rectOfInterest;
        public static final Companion Companion = new Companion(null);

        public final boolean getCreatePreview() {
            return this.createPreview;
        }

        public final boolean getCreateDocument() {
            return this.createDocument;
        }

        @NotNull
        public final Size getDocumentImageSizeLimit() {
            return this.documentImageSizeLimit;
        }

        public final float getImageScale() {
            return this.imageScale;
        }

        public final int getImageOrientation() {
            return this.imageOrientation;
        }

        @NotNull
        public final List<PageAspectRatio> getRequiredAspectRatios() {
            return this.requiredAspectRatios;
        }

        @NotNull
        public final RectF getRectOfInterest() {
            return this.rectOfInterest;
        }

        public Configuration(boolean createPreview, boolean createDocument, @NotNull Size documentImageSizeLimit, float imageScale, int imageOrientation, @NotNull List<? extends PageAspectRatio> requiredAspectRatios, @NotNull RectF rectOfInterest) {
            Intrinsics.checkParameterIsNotNull((Object)documentImageSizeLimit, (String)"documentImageSizeLimit");
            Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
            Intrinsics.checkParameterIsNotNull((Object)rectOfInterest, (String)"rectOfInterest");
            this.createPreview = createPreview;
            this.createDocument = createDocument;
            this.documentImageSizeLimit = documentImageSizeLimit;
            this.imageScale = imageScale;
            this.imageOrientation = imageOrientation;
            this.requiredAspectRatios = requiredAspectRatios;
            this.rectOfInterest = rectOfInterest;
        }

        public /* synthetic */ Configuration(boolean bl, boolean bl2, Size size, float f2, int n2, List list, RectF rectF, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                bl = true;
            }
            if ((n3 & 2) != 0) {
                bl2 = false;
            }
            if ((n3 & 4) != 0) {
                size = new Size(0, 0, 3, null);
            }
            if ((n3 & 8) != 0) {
                f2 = 1.0f;
            }
            if ((n3 & 0x10) != 0) {
                n2 = 0;
            }
            if ((n3 & 0x20) != 0) {
                list = new ArrayList();
            }
            if ((n3 & 0x40) != 0) {
                rectF = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            }
            this(bl, bl2, size, f2, n2, list, rectF);
        }

        public Configuration() {
            this(false, false, null, 0.0f, 0, null, null, 127, null);
        }

        public final boolean component1() {
            return this.createPreview;
        }

        public final boolean component2() {
            return this.createDocument;
        }

        @NotNull
        public final Size component3() {
            return this.documentImageSizeLimit;
        }

        public final float component4() {
            return this.imageScale;
        }

        public final int component5() {
            return this.imageOrientation;
        }

        @NotNull
        public final List<PageAspectRatio> component6() {
            return this.requiredAspectRatios;
        }

        @NotNull
        public final RectF component7() {
            return this.rectOfInterest;
        }

        @NotNull
        public final Configuration copy(boolean createPreview, boolean createDocument, @NotNull Size documentImageSizeLimit, float imageScale, int imageOrientation, @NotNull List<? extends PageAspectRatio> requiredAspectRatios, @NotNull RectF rectOfInterest) {
            Intrinsics.checkParameterIsNotNull((Object)documentImageSizeLimit, (String)"documentImageSizeLimit");
            Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
            Intrinsics.checkParameterIsNotNull((Object)rectOfInterest, (String)"rectOfInterest");
            return new Configuration(createPreview, createDocument, documentImageSizeLimit, imageScale, imageOrientation, requiredAspectRatios, rectOfInterest);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, boolean bl, boolean bl2, Size size, float f2, int n2, List list, RectF rectF, int n3, Object object) {
            if ((n3 & 1) != 0) {
                bl = configuration.createPreview;
            }
            if ((n3 & 2) != 0) {
                bl2 = configuration.createDocument;
            }
            if ((n3 & 4) != 0) {
                size = configuration.documentImageSizeLimit;
            }
            if ((n3 & 8) != 0) {
                f2 = configuration.imageScale;
            }
            if ((n3 & 0x10) != 0) {
                n2 = configuration.imageOrientation;
            }
            if ((n3 & 0x20) != 0) {
                list = configuration.requiredAspectRatios;
            }
            if ((n3 & 0x40) != 0) {
                rectF = configuration.rectOfInterest;
            }
            return configuration.copy(bl, bl2, size, f2, n2, list, rectF);
        }

        @NotNull
        public String toString() {
            return "Configuration(createPreview=" + this.createPreview + ", createDocument=" + this.createDocument + ", documentImageSizeLimit=" + this.documentImageSizeLimit + ", imageScale=" + this.imageScale + ", imageOrientation=" + this.imageOrientation + ", requiredAspectRatios=" + this.requiredAspectRatios + ", rectOfInterest=" + this.rectOfInterest + ")";
        }

        public int hashCode() {
            int n2 = this.createPreview ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = n2 * 31;
            int n4 = this.createDocument ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            Size size = this.documentImageSizeLimit;
            List<PageAspectRatio> list = this.requiredAspectRatios;
            RectF rectF = this.rectOfInterest;
            return (((((n3 + n4) * 31 + (size != null ? ((Object)size).hashCode() : 0)) * 31 + Float.floatToIntBits(this.imageScale)) * 31 + this.imageOrientation) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (rectF != null ? rectF.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Configuration)) break block3;
                    Configuration configuration = (Configuration)object;
                    if (this.createPreview != configuration.createPreview || this.createDocument != configuration.createDocument || !Intrinsics.areEqual((Object)this.documentImageSizeLimit, (Object)configuration.documentImageSizeLimit) || Float.compare(this.imageScale, configuration.imageScale) != 0 || this.imageOrientation != configuration.imageOrientation || !Intrinsics.areEqual(this.requiredAspectRatios, configuration.requiredAspectRatios) || !Intrinsics.areEqual((Object)this.rectOfInterest, (Object)configuration.rectOfInterest)) break block3;
                }
                return true;
            }
            return false;
        }

        @JvmStatic
        @NotNull
        public static final Configuration DEFAULT() {
            return Companion.DEFAULT();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "Ljava/io/Serializable;", "width", "", "height", "(II)V", "getHeight", "()I", "getWidth", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "scanbot-sdk_release"})
        public static final class Size
        implements Serializable {
            private final int width;
            private final int height;

            public final int getWidth() {
                return this.width;
            }

            public final int getHeight() {
                return this.height;
            }

            public Size(int width, int height) {
                this.width = width;
                this.height = height;
            }

            public /* synthetic */ Size(int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n4 & 1) != 0) {
                    n2 = Integer.MAX_VALUE;
                }
                if ((n4 & 2) != 0) {
                    n3 = Integer.MAX_VALUE;
                }
                this(n2, n3);
            }

            public Size() {
                this(0, 0, 3, null);
            }

            public final int component1() {
                return this.width;
            }

            public final int component2() {
                return this.height;
            }

            @NotNull
            public final Size copy(int width, int height) {
                return new Size(width, height);
            }

            public static /* synthetic */ Size copy$default(Size size, int n2, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n2 = size.width;
                }
                if ((n4 & 2) != 0) {
                    n3 = size.height;
                }
                return size.copy(n2, n3);
            }

            @NotNull
            public String toString() {
                return "Size(width=" + this.width + ", height=" + this.height + ")";
            }

            public int hashCode() {
                return this.width * 31 + this.height;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Size)) break block3;
                        Size size = (Size)object;
                        if (this.width != size.width || this.height != size.height) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Companion;", "", "()V", "DEFAULT", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "scanbot-sdk_release"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final Configuration DEFAULT() {
                return new Configuration(false, false, null, 0.0f, 0, null, null, 127, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

