/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.net.Uri;
import android.provider.MediaStore;
import io.scanbot.sdk.b.a;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.ImageFilterType;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.bitmap.BitmapUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\rH\u0002J\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/scanbot/sdk/process/PageProcessor;", "", "context", "Landroid/content/Context;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "(Landroid/content/Context;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "applyFilter", "Lio/scanbot/sdk/persistence/Page;", "page", "filter", "Lio/scanbot/sdk/process/ImageFilterType;", "calculateRotationDegree", "", "times", "", "cropAndRotate", "polygon", "", "Landroid/graphics/PointF;", "detectDocument", "generateFilteredPreview", "Landroid/graphics/Bitmap;", "rotate", "rotateAndSavePageImage", "", "bitmap", "rotationDegree", "pageId", "", "pageType", "Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "rotateBitmap", "degree", "scaleBitmapIfNeeded", "imageSizeLimit", "Lio/scanbot/sdk/persistence/Page$Size;", "scanbot-sdk_release"})
public final class PageProcessor {
    private Context context;
    private final PageFileStorage pageFileStorage;

    @NotNull
    public final Page applyFilter(@NotNull Page page, @NotNull ImageFilterType filter) throws IOException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Unfiltered document image does not exists for this page.");
        }
        Bitmap bitmap2 = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        ContourDetector contourDetector = new ContourDetector();
        Bitmap bitmap3 = bitmap = contourDetector.processImageF(bitmap2, CollectionsKt.emptyList(), filter.getCode());
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"filteredBitmap");
        this.pageFileStorage.setImageForId(bitmap3, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        return Page.copy$default(page, null, null, null, filter, null, 23, null);
    }

    @NotNull
    public final Bitmap generateFilteredPreview(@NotNull Page page, @NotNull ImageFilterType filter) throws IOException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Unfiltered document image does not exists for this page.");
        }
        Bitmap bitmap2 = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        ContourDetector contourDetector = new ContourDetector();
        Bitmap bitmap3 = bitmap = contourDetector.processImageAndRelease(bitmap2, CollectionsKt.emptyList(), filter.getCode());
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"filteredBitmap");
        return this.pageFileStorage.generateAndSetFilteredPreviewForId(bitmap3, page.getPageId(), filter);
    }

    @NotNull
    public final Page detectDocument(@NotNull Page page) throws IOException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Original image does not exists for this page.");
        }
        Bitmap bitmap2 = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        ContourDetector contourDetector = new ContourDetector();
        DetectionResult detectionResult = contourDetector.detect(bitmap2);
        Bitmap bitmap3 = contourDetector.processImageF(bitmap2, contourDetector.getPolygonF(), page.getFilter().getCode());
        if (page.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && page.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE) {
            Bitmap bitmap4 = BitmapUtils.scaleIfNeeded(bitmap3, page.getDocumentImageSizeLimit().getWidth(), page.getDocumentImageSizeLimit().getHeight());
            bitmap = bitmap4;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"BitmapUtils.scaleIfNeede\u2026entImageSizeLimit.height)");
        } else {
            Bitmap bitmap5 = bitmap3;
            bitmap = bitmap5;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"documentBitmapBeforeScaling");
        }
        Bitmap bitmap6 = bitmap;
        Bitmap bitmap7 = page.getFilter() != ImageFilterType.NONE ? contourDetector.processImageF(bitmap2, contourDetector.getPolygonF(), ImageFilterType.NONE.getCode()) : bitmap6;
        this.pageFileStorage.setImageForId(bitmap6, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        Bitmap bitmap8 = bitmap7;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap8, (String)"unfilteredDocumentBitmap");
        this.pageFileStorage.setImageForId(bitmap8, page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        this.pageFileStorage.removeFilteredPreviewImages(page.getPageId());
        List list = contourDetector.getPolygonF();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"detector.polygonF");
        DetectionResult detectionResult2 = detectionResult;
        Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult2, (String)"detectionResult");
        return Page.copy$default(page, null, list, detectionResult2, null, null, 25, null);
    }

    @NotNull
    public final Page rotate(@NotNull Page page, int times) throws IOException {
        Object object;
        Bitmap bitmap;
        Bitmap bitmap2;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Original image does not exists for this page.");
        }
        float f2 = this.calculateRotationDegree(times);
        Bitmap bitmap3 = bitmap2 = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"originalBitmap");
        this.rotateAndSavePageImage(bitmap3, f2, page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        bitmap2.recycle();
        Uri uri2 = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        if (new File(uri2.getPath()).exists()) {
            Bitmap bitmap4 = bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri2);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"documentBitmap");
            this.rotateAndSavePageImage(bitmap4, f2, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
            bitmap.recycle();
        }
        bitmap = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (new File(uri2.getPath()).exists()) {
            Bitmap bitmap5 = object = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)bitmap);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"unfilteredDocumentBitmap");
            this.rotateAndSavePageImage(bitmap5, f2, page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
            object.recycle();
        }
        this.pageFileStorage.removeFilteredPreviewImages(page.getPageId());
        object = page.getPolygon();
        Collection collection = (Collection)object;
        boolean bl = false;
        if (!collection.isEmpty()) {
            object = a.a.a(page.getPolygon(), f2);
        }
        return Page.copy$default(page, null, (List)object, null, null, null, 29, null);
    }

    @NotNull
    public final Page cropAndRotate(@NotNull Page page, int times, @NotNull List<? extends PointF> polygon) throws IOException {
        Bitmap bitmap;
        Bitmap bitmap2;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
        String string2 = page.getPageId();
        Uri uri = this.pageFileStorage.getImageURI(string2, PageFileStorage.PageFileType.ORIGINAL);
        if (!new File(uri.getPath()).exists()) {
            throw (Throwable)new IOException("Original image does not exists for this page.");
        }
        float f2 = this.calculateRotationDegree(times);
        Bitmap bitmap3 = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
        ContourDetector contourDetector = new ContourDetector();
        Bitmap bitmap4 = bitmap2 = contourDetector.processImageF(bitmap3, polygon, ImageFilterType.NONE.getCode());
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"unfilteredDocumentBitmap");
        bitmap2 = this.rotateBitmap(bitmap4, f2);
        bitmap2 = this.scaleBitmapIfNeeded(bitmap2, page.getDocumentImageSizeLimit());
        this.pageFileStorage.setImageForId(bitmap2, string2, PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        bitmap2.recycle();
        Bitmap bitmap5 = bitmap = contourDetector.processImageF(bitmap3, polygon, page.getFilter().getCode());
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"documentBitmap");
        bitmap = this.rotateBitmap(bitmap5, f2);
        bitmap = this.scaleBitmapIfNeeded(bitmap, page.getDocumentImageSizeLimit());
        this.pageFileStorage.setImageForId(bitmap, string2, PageFileStorage.PageFileType.DOCUMENT);
        bitmap.recycle();
        Bitmap bitmap6 = bitmap3;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap6, (String)"originalBitmap");
        this.rotateAndSavePageImage(bitmap6, f2, string2, PageFileStorage.PageFileType.ORIGINAL);
        bitmap3.recycle();
        this.pageFileStorage.removeFilteredPreviewImages(string2);
        List<? extends PointF> list = polygon;
        Collection collection = list;
        boolean bl = false;
        if (!collection.isEmpty()) {
            list = a.a.a(polygon, f2);
        }
        return Page.copy$default(page, null, list, null, null, null, 29, null);
    }

    private final float calculateRotationDegree(int times) {
        return -1 * times * 90;
    }

    private final void rotateAndSavePageImage(Bitmap bitmap, float rotationDegree, String pageId, PageFileStorage.PageFileType pageType) {
        Bitmap bitmap2 = this.rotateBitmap(bitmap, rotationDegree);
        this.pageFileStorage.setImageForId(bitmap2, pageId, pageType);
        bitmap2.recycle();
    }

    private final Bitmap rotateBitmap(Bitmap bitmap, float degree) {
        Matrix matrix = new Matrix();
        matrix.postRotate(degree);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(bitm\u2026ap.height, matrix, false)");
        return bitmap2;
    }

    private final Bitmap scaleBitmapIfNeeded(Bitmap bitmap, Page.Size imageSizeLimit) {
        Bitmap bitmap2;
        if (imageSizeLimit.getHeight() != Integer.MAX_VALUE && imageSizeLimit.getWidth() != Integer.MAX_VALUE) {
            Bitmap bitmap3 = BitmapUtils.scaleIfNeeded(bitmap, imageSizeLimit.getWidth(), imageSizeLimit.getHeight());
            bitmap2 = bitmap3;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"BitmapUtils.scaleIfNeede\u2026h, imageSizeLimit.height)");
        } else {
            bitmap2 = bitmap;
        }
        return bitmap2;
    }

    @Inject
    public PageProcessor(@NotNull Context context, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        this.context = context;
        this.pageFileStorage = pageFileStorage;
    }
}

