/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import io.scanbot.sdk.b.b;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.doo.snap.R;
import net.doo.snap.ScanbotSDKInitializer;
import net.doo.snap.lib.detector.Line2D;
import net.doo.snap.ui.MagnifierView;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.snap.PolygonHelper;
import org.jetbrains.annotations.Nullable;

public class EditPolygonImageView
extends AppCompatImageView {
    private static final int CORNERS_COUNT = 4;
    public static final List<PointF> DEFAULT_POLYGON = new ArrayList<PointF>(){
        {
            this.add(new PointF(0.0f, 0.0f));
            this.add(new PointF(1.0f, 0.0f));
            this.add(new PointF(1.0f, 1.0f));
            this.add(new PointF(0.0f, 1.0f));
        }
    };
    private EditPolygonAnimationEndListener editPolygonAnimationEndListener = null;
    private final float magneticLineTreshold;
    private final int edgeColor;
    private final int edgeColorOnLine;
    private final Drawable cornerDrawable;
    private final Drawable edgeDrawable;
    private Paint paint;
    private Paint paintOnLine;
    private Paint handlePaint;
    private PolygonHelper polygonHelper;
    private float rotationScale = 1.0f;
    private final List<Line2D> horizontalLines2D = new ArrayList<Line2D>();
    private final List<Line2D> verticalLines2D = new ArrayList<Line2D>();
    private final List<PolygonHelper.Line> horizontalLines = new ArrayList<PolygonHelper.Line>();
    private final List<PolygonHelper.Line> verticalLines = new ArrayList<PolygonHelper.Line>();
    private PointF finger = new PointF();
    private List<PointF> polygon;
    private List<PointF> corners;
    private List<PolygonHelper.Edge> edges;
    private float offsetX;
    private float offsetY;
    private Bitmap cornerBitmap;
    private Bitmap edgeBitmap;
    private int handleSize;
    private PointF selectedCorner;
    private PolygonHelper.Edge selectedEdge;
    private PointF tmpPointA = new PointF();
    private PointF tmpPointB = new PointF();
    private float medianX;
    private float medianY;
    private PriorityQueue<PointF> pointsQueue = new PriorityQueue<PointF>(4, new Comparator<PointF>(){

        public int a(PointF pointF, PointF pointF2) {
            double d2 = Math.atan2(pointF.y - EditPolygonImageView.this.medianY, pointF.x - EditPolygonImageView.this.medianX);
            double d3 = Math.atan2(pointF2.y - EditPolygonImageView.this.medianY, pointF2.x - EditPolygonImageView.this.medianX);
            return Double.compare(d2, d3);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((PointF)object, (PointF)object2);
        }
    });
    @Nullable
    private MagnifierView magnifierView;
    private float[] imageMatrix = new float[9];
    private RectF touchRect = new RectF();
    private float polygonStrokeWidth;
    private int lastKnownImageWidth = -1;
    private int lastKnownImageHeight = -1;
    private float scaleLandscape = 1.0f;
    private float scalePortrait = 1.0f;

    public static List<PointF> getDefaultPolygon() {
        return new ArrayList<PointF>(){
            {
                this.add(new PointF(0.0f, 0.0f));
                this.add(new PointF(1.0f, 0.0f));
                this.add(new PointF(1.0f, 1.0f));
                this.add(new PointF(0.0f, 1.0f));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditPolygonImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        int n2;
        if (!io.scanbot.sdk.ScanbotSDKInitializer.isInitialized() && !ScanbotSDKInitializer.isInitialized()) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.EditPolygonImageView, 0, 0);
        try {
            this.edgeColor = typedArray.getColor(R.styleable.EditPolygonImageView_edgeColor, 0);
            this.edgeColorOnLine = typedArray.getColor(R.styleable.EditPolygonImageView_edgeColorOnLine, this.edgeColor);
            this.cornerDrawable = typedArray.getDrawable(R.styleable.EditPolygonImageView_cornerImageSrc);
            this.edgeDrawable = typedArray.getDrawable(R.styleable.EditPolygonImageView_edgeImageSrc);
            this.magneticLineTreshold = typedArray.getDimension(R.styleable.EditPolygonImageView_magneticLineTreshold, this.getResources().getDimension(R.dimen.magnetic_line_treshold));
            this.polygonStrokeWidth = typedArray.getDimension(R.styleable.EditPolygonImageView_editPolygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
            this.handleSize = typedArray.getDimensionPixelSize(R.styleable.EditPolygonImageView_editPolygonHandleSize, this.getResources().getDimensionPixelSize(R.dimen.edit_polygon_handle_size));
        }
        finally {
            typedArray.recycle();
        }
        this.polygon = Collections.emptyList();
        this.paint = new Paint();
        this.paint.setColor(this.edgeColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.polygonStrokeWidth);
        this.paint.setAntiAlias(true);
        this.paint.setStrokeCap(Paint.Cap.SQUARE);
        this.paintOnLine = new Paint();
        this.paintOnLine.setColor(this.edgeColorOnLine);
        this.paintOnLine.setStyle(Paint.Style.STROKE);
        this.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
        this.paintOnLine.setAntiAlias(true);
        this.paintOnLine.setStrokeCap(Paint.Cap.SQUARE);
        this.handlePaint = new Paint();
        this.handlePaint.setAntiAlias(true);
        this.handlePaint.setFilterBitmap(true);
        this.polygonHelper = new PolygonHelper();
        this.corners = new ArrayList<PointF>();
        for (n2 = 0; n2 < 4; ++n2) {
            this.corners.add(new PointF());
        }
        this.edges = new ArrayList<PolygonHelper.Edge>();
        for (n2 = 0; n2 < this.corners.size(); ++n2) {
            PolygonHelper.Edge edge = new PolygonHelper.Edge();
            edge.pointA = this.corners.get(n2);
            edge.pointB = this.corners.get((n2 + 1) % 4);
            edge.pointFarA = this.corners.get((n2 + 3) % 4);
            edge.pointFarB = this.corners.get((n2 + 2) % 4);
            this.edges.add(edge);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.cornerBitmap = BitmapUtils.drawableToBitmap(this.cornerDrawable);
        this.edgeBitmap = BitmapUtils.drawableToBitmap(this.edgeDrawable);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cornerBitmap.recycle();
        this.edgeBitmap.recycle();
        this.editPolygonAnimationEndListener = null;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.onImageSizeUpdated();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    public void setPolygon(final List<PointF> polygon) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!polygon.isEmpty()) {
                    EditPolygonImageView.this.polygon = polygon;
                    if (!EditPolygonImageView.this.corners.isEmpty()) {
                        EditPolygonImageView.this.polygonHelper.getDrawingPolygon(polygon, EditPolygonImageView.this.corners);
                    }
                    EditPolygonImageView.this.invalidate();
                }
            }
        });
    }

    public List<PointF> getPolygon() {
        if (!this.corners.isEmpty() && !this.polygon.isEmpty()) {
            this.polygonHelper.getPolygonFromDrawingPolygon(this.corners, this.polygon);
        }
        return this.polygon;
    }

    public void setRotation(float rotation) {
        if (rotation % 90.0f != 0.0f) {
            return;
        }
        float f2 = this.getRotation() - rotation;
        float f3 = this.getRotationScale(this.getRotation(), f2);
        if (this.magnifierView != null) {
            this.magnifierView.setImageRotation(rotation);
        }
        this.setScaleX(f3);
        this.setScaleY(f3);
        this.invalidate();
        super.setRotation(rotation);
    }

    public void setLines(final List<Line2D> horizontalLines, final List<Line2D> verticalLines) {
        this.post(new Runnable(){

            @Override
            public void run() {
                PolygonHelper.Line line2;
                ArrayList<Line2D> arrayList = new ArrayList<Line2D>(horizontalLines.size());
                for (Line2D object2 : horizontalLines) {
                    arrayList.add(new Line2D(new PointF(object2.getStart().x, object2.getStart().y), new PointF(object2.getEnd().x, object2.getEnd().y)));
                }
                EditPolygonImageView.this.horizontalLines2D.clear();
                EditPolygonImageView.this.horizontalLines2D.addAll(EditPolygonImageView.this.polygonHelper.scaleLines(arrayList));
                EditPolygonImageView.this.horizontalLines.clear();
                for (Line2D line2D : arrayList) {
                    line2 = new PolygonHelper.Line();
                    line2.calculateLine(line2D.getStart(), line2D.getEnd());
                    EditPolygonImageView.this.horizontalLines.add(line2);
                }
                ArrayList arrayList2 = new ArrayList(verticalLines.size());
                for (PolygonHelper.Line line2 : verticalLines) {
                    arrayList2.add(new Line2D(new PointF(line2.getStart().x, line2.getStart().y), new PointF(line2.getEnd().x, line2.getEnd().y)));
                }
                EditPolygonImageView.this.verticalLines2D.clear();
                EditPolygonImageView.this.verticalLines2D.addAll(EditPolygonImageView.this.polygonHelper.scaleLines(arrayList2));
                EditPolygonImageView.this.verticalLines.clear();
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    line2 = (Line2D)iterator.next();
                    PolygonHelper.Line line3 = new PolygonHelper.Line();
                    line3.calculateLine(line2.getStart(), line2.getEnd());
                    EditPolygonImageView.this.verticalLines.add(line3);
                }
            }
        });
    }

    public void setEdgeColor(int color) {
        this.paint.setColor(color);
    }

    public void setEdgeColorOnLine(int color) {
        this.paintOnLine.setColor(color);
    }

    public void setEdgeWidth(float width) {
        this.polygonStrokeWidth = width;
        this.paint.setStrokeWidth(this.polygonStrokeWidth);
        this.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
    }

    public void rotateClockwise() {
        float f2 = this.getRotation();
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        float f3 = 90.0f;
        float f4 = this.getRotationScale(f2, 90.0f);
        this.animate().rotationBy(90.0f).scaleX(f4).scaleY(f4).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (EditPolygonImageView.this.magnifierView != null) {
                    EditPolygonImageView.this.magnifierView.setImageRotation(EditPolygonImageView.this.getRotation());
                }
                if (EditPolygonImageView.this.editPolygonAnimationEndListener != null) {
                    EditPolygonImageView.this.editPolygonAnimationEndListener.onAnimationEnded();
                }
                EditPolygonImageView.this.invalidate();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).start();
    }

    public void rotateCounterClockwise() {
        float f2 = this.getRotation();
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        float f3 = -90.0f;
        float f4 = this.getRotationScale(f2, -90.0f);
        this.animate().rotationBy(-90.0f).scaleX(f4).scaleY(f4).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (EditPolygonImageView.this.magnifierView != null) {
                    EditPolygonImageView.this.magnifierView.setImageRotation(EditPolygonImageView.this.getRotation());
                }
                if (EditPolygonImageView.this.editPolygonAnimationEndListener != null) {
                    EditPolygonImageView.this.editPolygonAnimationEndListener.onAnimationEnded();
                }
                EditPolygonImageView.this.invalidate();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).start();
    }

    private float getRotationScale(float currentRotation, float rotateBy) {
        float f2 = Math.abs((currentRotation + rotateBy) % 360.0f);
        if (f2 / 90.0f % 2.0f == 0.0f) {
            return this.scalePortrait;
        }
        return this.scaleLandscape;
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.checkWhetherImageSizeUpdated();
        if (!this.polygon.isEmpty()) {
            canvas.save();
            canvas.translate(this.offsetX, this.offsetY);
            for (PolygonHelper.Edge edge : this.edges) {
                canvas.drawLine(edge.pointA.x, edge.pointA.y, edge.pointB.x, edge.pointB.y, edge.isDetectedLine ? this.paintOnLine : this.paint);
            }
            if (this.selectedCorner != null) {
                this.drawHandle(canvas, this.selectedCorner, this.cornerBitmap, 0.0f);
                canvas.save();
                canvas.translate(-this.offsetX, -this.offsetY);
                if (this.magnifierView != null) {
                    PointF pointF = new PointF(this.selectedCorner.x / ((float)this.getWidth() - 2.0f * this.offsetX), this.selectedCorner.y / ((float)this.getHeight() - 2.0f * this.offsetY));
                    this.magnifierView.drawMagnifier(pointF);
                }
                canvas.restore();
            } else if (this.selectedEdge != null) {
                this.drawHandle(canvas, this.selectedEdge.getHandle(), this.edgeBitmap, this.selectedEdge.getAngleInDegrees());
            } else {
                for (PolygonHelper.Edge edge : this.edges) {
                    this.drawHandle(canvas, edge.getHandle(), this.edgeBitmap, edge.getAngleInDegrees());
                }
                for (PointF pointF : this.corners) {
                    this.drawHandle(canvas, pointF, this.cornerBitmap, 0.0f);
                }
            }
            canvas.restore();
        }
    }

    private void checkWhetherImageSizeUpdated() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return;
        }
        if (drawable.getIntrinsicWidth() != this.lastKnownImageWidth || drawable.getIntrinsicHeight() != this.lastKnownImageHeight) {
            this.lastKnownImageWidth = drawable.getIntrinsicWidth();
            this.lastKnownImageHeight = drawable.getIntrinsicHeight();
            this.onImageSizeUpdated();
        }
    }

    private void drawHandle(Canvas canvas, PointF point, Bitmap handle, float degrees) {
        canvas.save();
        if (degrees != 0.0f) {
            canvas.rotate(degrees, point.x, point.y);
        }
        float f2 = 1.0f / this.getRotationScale(this.getRotation(), 0.0f);
        canvas.scale(f2, f2, point.x, point.y);
        canvas.drawBitmap(handle, point.x - (float)(handle.getWidth() >> 1), point.y - (float)(handle.getHeight() >> 1), this.handlePaint);
        canvas.restore();
    }

    private void keepInsideView(PointF point) {
        float f2 = Math.max(0.0f, Math.min(point.x, (float)this.getWidth() - 2.0f * this.offsetX));
        float f3 = Math.max(0.0f, Math.min(point.y, (float)this.getHeight() - 2.0f * this.offsetY));
        point.set(f2, f3);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                int n2 = this.handleSize >> 1;
                this.touchRect.set(event.getX() - this.offsetX - (float)n2, event.getY() - this.offsetY - (float)n2, event.getX() - this.offsetX + (float)n2, event.getY() - this.offsetY + (float)n2);
                for (PointF object : this.corners) {
                    if (!this.touchRect.contains(object.x, object.y)) continue;
                    this.selectedCorner = object;
                    this.invalidate();
                    return true;
                }
                for (PolygonHelper.Edge edge : this.edges) {
                    PointF pointF = edge.getHandle();
                    if (!this.touchRect.contains(pointF.x, pointF.y)) continue;
                    this.selectedEdge = edge;
                    edge.prevX = event.getX();
                    edge.prevY = event.getY();
                    edge.lineA.calculateLine(edge.pointA, edge.pointFarA);
                    edge.lineB.calculateLine(edge.pointB, edge.pointFarB);
                    this.finger.set(pointF);
                    this.invalidate();
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.selectedCorner != null) {
                    this.selectedCorner.set(event.getX() - this.offsetX, event.getY() - this.offsetY);
                    this.keepInsideView(this.selectedCorner);
                    this.ensureNoPolygonIntersection();
                    this.invalidate();
                } else if (this.selectedEdge != null) {
                    double d2;
                    PolygonHelper.Line pointF2;
                    int pointF;
                    float f2 = event.getX() - this.selectedEdge.prevX;
                    float f3 = event.getY() - this.selectedEdge.prevY;
                    this.finger.offset(f2, f3);
                    this.tmpPointA.set(this.selectedEdge.pointA);
                    this.tmpPointB.set(this.selectedEdge.pointB);
                    double d3 = Double.MAX_VALUE;
                    Line2D line2D = null;
                    if (this.selectedEdge.isHorizontal()) {
                        for (pointF = 0; pointF < this.horizontalLines.size(); ++pointF) {
                            pointF2 = this.horizontalLines.get(pointF);
                            d2 = pointF2.getDistanceToPoint(this.finger);
                            if (!(d2 < d3)) continue;
                            d3 = d2;
                            line2D = this.horizontalLines2D.get(pointF);
                        }
                    } else {
                        for (pointF = 0; pointF < this.verticalLines.size(); ++pointF) {
                            pointF2 = this.verticalLines.get(pointF);
                            d2 = pointF2.getDistanceToPoint(this.finger);
                            if (!(d2 < d3)) continue;
                            d3 = d2;
                            line2D = this.verticalLines2D.get(pointF);
                        }
                    }
                    if (line2D != null && d3 < (double)this.magneticLineTreshold) {
                        this.selectedEdge.pointA.set(line2D.getStart());
                        this.selectedEdge.pointB.set(line2D.getEnd());
                        this.selectedEdge.isDetectedLine = true;
                    } else {
                        this.selectedEdge.isDetectedLine = false;
                        PointF pointF3 = this.selectedEdge.getHandle();
                        float f4 = this.finger.x - pointF3.x;
                        float f5 = this.finger.y - pointF3.y;
                        this.selectedEdge.pointA.offset(f4, f5);
                        this.selectedEdge.pointB.offset(f4, f5);
                    }
                    this.selectedEdge.edgeLine.calculateLine(this.selectedEdge.pointA, this.selectedEdge.pointB);
                    PointF pointF4 = this.selectedEdge.edgeLine.getIntersectionPoint(this.selectedEdge.lineA);
                    if (Float.isNaN(pointF4.x) || Float.isNaN(pointF4.y)) {
                        this.restoreSelectedEdge();
                        return false;
                    }
                    this.selectedEdge.pointA.set(pointF4);
                    PointF pointF5 = this.selectedEdge.edgeLine.getIntersectionPoint(this.selectedEdge.lineB);
                    if (Float.isNaN(pointF5.x) || Float.isNaN(pointF5.y)) {
                        this.restoreSelectedEdge();
                        return false;
                    }
                    this.selectedEdge.pointB.set(pointF5);
                    this.keepInsideView(this.selectedEdge.pointA);
                    this.keepInsideView(this.selectedEdge.pointB);
                    this.selectedEdge.prevX = event.getX();
                    this.selectedEdge.prevY = event.getY();
                    this.invalidate();
                }
                return true;
            }
            case 1: 
            case 3: {
                this.selectedCorner = null;
                this.selectedEdge = null;
                if (this.magnifierView != null) {
                    this.magnifierView.eraseMagnifier();
                }
                this.invalidate();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private void restoreSelectedEdge() {
        this.selectedEdge.pointA.set(this.tmpPointA);
        this.selectedEdge.pointB.set(this.tmpPointB);
        this.selectedEdge.edgeLine.calculateLine(this.selectedEdge.pointA, this.selectedEdge.pointB);
    }

    private void ensureNoPolygonIntersection() {
        this.calculateMedian();
        if (this.ensureCornersOrder()) {
            this.ensureEdgesOrder();
        }
    }

    private boolean ensureCornersOrder() {
        boolean bl = false;
        this.pointsQueue.addAll(this.corners);
        for (int i2 = 0; i2 < 4; ++i2) {
            PointF pointF = (PointF)this.pointsQueue.remove();
            if (!pointF.equals((Object)this.corners.get(i2))) {
                bl = true;
            }
            this.corners.set(i2, pointF);
        }
        return bl;
    }

    private void calculateMedian() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            PointF pointF = this.corners.get(i2);
            f2 += pointF.x;
            f3 += pointF.y;
        }
        this.medianX = f2 / 4.0f;
        this.medianY = f3 / 4.0f;
    }

    private void ensureEdgesOrder() {
        for (int i2 = 0; i2 < 4; ++i2) {
            PolygonHelper.Edge edge = this.edges.get(i2);
            edge.pointA = this.corners.get(i2);
            edge.pointB = this.corners.get((i2 + 1) % 4);
            edge.pointFarA = this.corners.get((i2 + 3) % 4);
            edge.pointFarB = this.corners.get((i2 + 2) % 4);
        }
    }

    private void onImageSizeUpdated() {
        if (this.getDrawable() != null) {
            this.offsetX = 0.0f;
            this.offsetY = 0.0f;
            this.getImageMatrix().getValues(this.imageMatrix);
            Drawable drawable = this.getDrawable();
            int n2 = drawable.getIntrinsicWidth();
            int n3 = drawable.getIntrinsicHeight();
            RectF rectF = new RectF(0.0f, 0.0f, (float)n2 * this.getScaleX(), (float)n3 * this.getScaleY());
            this.scalePortrait = b.a((View)this, 0.0f, rectF) * this.getScaleX();
            this.scaleLandscape = b.a((View)this, 90.0f, rectF) * this.getScaleY();
            if ((float)n2 * this.scalePortrait < (float)this.getWidth()) {
                this.offsetX = this.getWidth() - (int)((float)n2 * this.scalePortrait) >> 1;
            }
            if ((float)n3 * this.scalePortrait < (float)this.getHeight()) {
                this.offsetY = this.getHeight() - (int)((float)n3 * this.scalePortrait) >> 1;
            }
            this.polygonHelper.setImageSize((int)((float)n2 * this.scalePortrait), (int)((float)n3 * this.scalePortrait));
            this.scaleLandscape /= this.scalePortrait;
            this.scalePortrait = 1.0f;
            if (this.getRotation() / 90.0f % 2.0f == 1.0f) {
                this.setScaleX(this.scaleLandscape);
                this.setScaleY(this.scaleLandscape);
            }
            if (!this.polygon.isEmpty()) {
                this.polygonHelper.getDrawingPolygon(this.polygon, this.corners);
            }
        }
    }

    void setMagnifier(MagnifierView magnifier) {
        this.magnifierView = magnifier;
        this.invalidate();
    }

    public void setEditPolygonAnimationEndListener(EditPolygonAnimationEndListener editPolygonAnimationEndListener) {
        this.editPolygonAnimationEndListener = editPolygonAnimationEndListener;
    }

    public static interface EditPolygonAnimationEndListener {
        public void onAnimationEnded();
    }
}

