/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.graphics.Rect;
import android.graphics.RectF;
import crl.android.pdfwriter.PDFWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.pdf.PdfUtils;
import org.apache.commons.io.IOUtils;

public class SimpleComposer
implements Composer {
    private final DocumentStoreStrategy a;
    private final PageStoreStrategy b;

    @Inject
    public SimpleComposer(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy) {
        this.a = documentStoreStrategy;
        this.b = pageStoreStrategy;
    }

    @Override
    public void composeDocument(Document document, Page ... pages) throws IOException {
        if (document.getSize() > 0L) {
            throw new IOException("Document already exists");
        }
        PDFWriter pDFWriter = new PDFWriter();
        this.a(pDFWriter, pages);
        this.a(document, pDFWriter);
    }

    private void a(PDFWriter pDFWriter, Page[] pageArray) throws IOException {
        for (Page page : pageArray) {
            String string2 = this.b.getImageFile(page.getId(), Page.ImageType.OPTIMIZED).getPath();
            Rect rect = BitmapUtils.getBitmapBounds(string2);
            int n2 = page.getRotationType().getDegrees();
            RectF rectF = PdfUtils.calculatePageBounds(page.getPageSize(), rect, n2);
            int n3 = (int)rectF.width();
            int n4 = (int)rectF.height();
            pDFWriter.newPage(n3, n4);
            pDFWriter.addJPGImageKeepRatio(n3, n4, -n2, string2);
        }
        pDFWriter.setDocumentInfo("/Creator (Scanbot for Android)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Document document, PDFWriter pDFWriter) throws IOException {
        File file = this.a.getDocumentFile(document.getId(), document.getName());
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            pDFWriter.write((OutputStream)bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
    }
}

