/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.inject.Inject;
import net.doo.snap.R;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.Cleaner;
import net.doo.snap.process.DocumentProcessingResult;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.h;
import net.doo.snap.process.util.DocumentDraft;
import net.doo.snap.util.bitmap.BitmapLruCache;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class DocumentProcessor {
    private final DocumentStoreStrategy a;
    private final PageStoreStrategy b;
    private final BitmapLruCache c;
    private final ComposerFactory d;
    private final a e;
    private final h<Document> f;
    private final Cleaner g;
    private final Logger h = LoggerProvider.getLogger();

    @Inject
    public DocumentProcessor(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, Resources resources, BitmapLruCache bitmapLruCache, ComposerFactory composerFactory, h<Document> documentProcessorMonitor, Cleaner cleaner) {
        this.a = documentStoreStrategy;
        this.b = pageStoreStrategy;
        this.c = bitmapLruCache;
        this.d = composerFactory;
        this.f = documentProcessorMonitor;
        this.g = cleaner;
        this.e = new a(resources, documentStoreStrategy, pageStoreStrategy);
    }

    public DocumentProcessingResult processDocument(@NotNull DocumentDraft documentDraft) throws IOException {
        Document document = documentDraft.getDocument();
        Page[] pageArray = documentDraft.getPages();
        this.a(document, pageArray);
        this.f.a(document);
        this.c.evictAll();
        this.g.cleanUpPagesData(pageArray);
        return new DocumentProcessingResult(document, Arrays.asList(pageArray), this.a.getDocumentFile(document.getId(), document.getName()));
    }

    private void a(Document document, Page[] pageArray) throws IOException {
        this.a.ensureDocumentDirectory(document.getId());
        if (document.getSize() < 0L) {
            for (int i2 = 0; i2 < pageArray.length; ++i2) {
                Page page = pageArray[i2];
                if (i2 != 0) continue;
                this.e.a(document, page);
            }
        }
        Composer composer = this.d.composerForDocument(document);
        this.h.d("Processing", "(" + document.getName() + ") Using composer: " + composer.getClass().getSimpleName());
        composer.composeDocument(document, pageArray);
    }

    private static class a {
        private final Resources a;
        private final DocumentStoreStrategy b;
        private PageStoreStrategy c;

        a(Resources resources, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy) {
            this.a = resources;
            this.b = documentStoreStrategy;
            this.c = pageStoreStrategy;
        }

        private void a(Document document, Page page) throws IOException {
            int n2 = (int)this.a.getDimension(R.dimen.document_thumbnail_size);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            String string2 = this.c.getImageFile(page.getId(), Page.ImageType.OPTIMIZED).getPath();
            BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
            int n3 = Math.max(options.outHeight, options.outWidth);
            int n4 = n3 / n2;
            if (n4 < 1) {
                n4 = 1;
            }
            BitmapFactory.Options options2 = new BitmapFactory.Options();
            options2.inSampleSize = n4;
            Bitmap bitmap = BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options2);
            if (BitmapUtils.isBitmapValid(bitmap)) {
                this.a(page.getRotationType().getDegrees(), n2, bitmap, this.b.getThumbnailFile(document.getId()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(int n2, int n3, Bitmap bitmap, File file) throws FileNotFoundException {
            float f2 = (float)n3 / (float)Math.max(bitmap.getWidth(), bitmap.getHeight());
            Matrix matrix = new Matrix();
            matrix.preRotate((float)n2, (float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2));
            matrix.postScale(f2, f2);
            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fileOutputStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
        }
    }
}

