/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.barcodescanner.BarCodeScanner;
import io.scanbot.barcodescanner.model.BarCodeItem;
import io.scanbot.barcodescanner.model.BarCodeScannerDocumentFormat;
import io.scanbot.barcodescanner.model.BarCodeScannerResult;
import io.scanbot.barcodescanner.model.BarCodeType;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.barcode.DefaultScanbotBarcodeDetector$WhenMappings;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.doo.snap.c.c;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J2\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020 H\u0002J\u0016\u0010$\u001a\u00020\u001d2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020 0&H\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/scanbot/sdk/barcode/DefaultScanbotBarcodeDetector;", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "barcodeFormatsFilter", "Ljava/util/ArrayList;", "Lio/scanbot/barcodescanner/model/BarCodeType;", "Lkotlin/collections/ArrayList;", "barcodeScanEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "sapManager", "Lio/scanbot/sap/SapManager;", "scanner", "Lio/scanbot/barcodescanner/BarCodeScanner;", "decodeWithState", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "data", "", "width", "", "height", "frameOrientation", "finderRect", "Landroid/graphics/Rect;", "enableBarcodeScan", "", "", "getAppFormat", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "zxingBarcodeFormat", "getCoreFormat", "barcodeFormat", "setBarcodeFormatsFilter", "barcodeFormats", "", "scanbot-sdk_release"})
public final class DefaultScanbotBarcodeDetector
implements ScanbotBarcodeDetector {
    private final Logger logger;
    private BarCodeScanner scanner;
    private final SapManager sapManager;
    private final ArrayList<BarCodeType> barcodeFormatsFilter;
    private final AtomicBoolean barcodeScanEnabled;

    @Override
    public void enableBarcodeScan(boolean barcodeScanEnabled) {
        this.barcodeScanEnabled.set(barcodeScanEnabled);
    }

    @Override
    public synchronized void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> barcodeFormats) {
        Collection<BarCodeType> collection;
        Intrinsics.checkParameterIsNotNull(barcodeFormats, (String)"barcodeFormats");
        this.barcodeFormatsFilter.clear();
        Iterable iterable = barcodeFormats;
        ArrayList<BarCodeType> arrayList = this.barcodeFormatsFilter;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            BarcodeFormat barcodeFormat = (BarcodeFormat)((Object)t2);
            collection = collection2;
            boolean bl3 = false;
            BarCodeType barCodeType = this.getCoreFormat(barcodeFormat);
            collection.add(barCodeType);
        }
        collection = (List)collection2;
        arrayList.addAll(collection);
    }

    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] data, int width, int height, int frameOrientation) {
        BarCodeScannerResult barCodeScannerResult;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw (Throwable)new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        BarCodeScannerResult barCodeScannerResult2 = barCodeScannerResult = this.scanner.detectAndDecode(data, (List)this.barcodeFormatsFilter, width, height, frameOrientation);
        if (barCodeScannerResult2 == null || !barCodeScannerResult2.success) {
            return null;
        }
        List list = barCodeScannerResult.detectedBarCodes;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"codeScannerResult.detectedBarCodes");
        Iterable iterable = list;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            byte[] byArray;
            BarCodeItem barCodeItem = (BarCodeItem)t2;
            Collection collection2 = collection;
            boolean bl3 = false;
            String string2 = barCodeItem.rawString;
            if (string2 == null) {
                string2 = "";
            }
            if (barCodeItem.rawString != null) {
                byte[] byArray2;
                String string3;
                String string4 = string2;
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String string5 = string3;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string5.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
                string2 = string4;
                byArray = byArray2;
            } else {
                byArray = null;
            }
            BarCodeScannerDocumentFormat barCodeScannerDocumentFormat = barCodeItem.documentFormat;
            BarcodeFormat barcodeFormat = this.getAppFormat(barCodeItem.type);
            ResultPoint[] resultPointArray = null;
            byte[] byArray3 = byArray;
            String string6 = string2;
            BarcodeItem barcodeItem = new BarcodeItem(string6, byArray3, resultPointArray, barcodeFormat, barCodeScannerDocumentFormat);
            collection2.add(barcodeItem);
        }
        List list2 = (List)collection;
        return new BarcodeScanningResult(list2, 0L, 2, null);
    }

    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] data, int width, int height, int frameOrientation, @NotNull Rect finderRect) {
        BarCodeScannerResult barCodeScannerResult;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)finderRect, (String)"finderRect");
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw (Throwable)new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        BarCodeScannerResult barCodeScannerResult2 = barCodeScannerResult = this.scanner.detectAndDecodeInArea(data, (List)this.barcodeFormatsFilter, finderRect, width, height, frameOrientation);
        if (barCodeScannerResult2 == null || !barCodeScannerResult2.success) {
            return null;
        }
        List list = barCodeScannerResult.detectedBarCodes;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"codeScannerResult.detectedBarCodes");
        Iterable iterable = list;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            byte[] byArray;
            BarCodeItem barCodeItem = (BarCodeItem)t2;
            Collection collection2 = collection;
            boolean bl3 = false;
            String string2 = barCodeItem.rawString;
            if (string2 == null) {
                string2 = "";
            }
            if (barCodeItem.rawString != null) {
                byte[] byArray2;
                String string3;
                String string4 = string2;
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String string5 = string3;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string5.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
                string2 = string4;
                byArray = byArray2;
            } else {
                byArray = null;
            }
            BarCodeScannerDocumentFormat barCodeScannerDocumentFormat = barCodeItem.documentFormat;
            BarcodeFormat barcodeFormat = this.getAppFormat(barCodeItem.type);
            ResultPoint[] resultPointArray = null;
            byte[] byArray3 = byArray;
            String string6 = string2;
            BarcodeItem barcodeItem = new BarcodeItem(string6, byArray3, resultPointArray, barcodeFormat, barCodeScannerDocumentFormat);
            collection2.add(barcodeItem);
        }
        List list2 = (List)collection;
        return new BarcodeScanningResult(list2, 0L, 2, null);
    }

    private final BarcodeFormat getAppFormat(BarCodeType zxingBarcodeFormat) {
        if (zxingBarcodeFormat == null) {
            return BarcodeFormat.UNKNOWN;
        }
        switch (DefaultScanbotBarcodeDetector$WhenMappings.$EnumSwitchMapping$0[zxingBarcodeFormat.ordinal()]) {
            case 1: {
                return BarcodeFormat.AZTEC;
            }
            case 2: {
                return BarcodeFormat.CODABAR;
            }
            case 3: {
                return BarcodeFormat.CODE_39;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 5: {
                return BarcodeFormat.CODE_128;
            }
            case 6: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 7: {
                return BarcodeFormat.EAN_8;
            }
            case 8: {
                return BarcodeFormat.EAN_13;
            }
            case 9: {
                return BarcodeFormat.ITF;
            }
            case 10: {
                return BarcodeFormat.MAXICODE;
            }
            case 11: {
                return BarcodeFormat.PDF_417;
            }
            case 12: {
                return BarcodeFormat.QR_CODE;
            }
            case 13: {
                return BarcodeFormat.RSS_14;
            }
            case 14: {
                return BarcodeFormat.RSS_EXPANDED;
            }
            case 15: {
                return BarcodeFormat.UPC_A;
            }
            case 16: {
                return BarcodeFormat.UPC_E;
            }
            case 17: {
                return BarcodeFormat.UPC_EAN_EXTENSION;
            }
        }
        return BarcodeFormat.UNKNOWN;
    }

    private final BarCodeType getCoreFormat(BarcodeFormat barcodeFormat) {
        switch (DefaultScanbotBarcodeDetector$WhenMappings.$EnumSwitchMapping$1[barcodeFormat.ordinal()]) {
            case 1: {
                return BarCodeType.AZTEC;
            }
            case 2: {
                return BarCodeType.CODABAR;
            }
            case 3: {
                return BarCodeType.CODE_39;
            }
            case 4: {
                return BarCodeType.CODE_93;
            }
            case 5: {
                return BarCodeType.CODE_128;
            }
            case 6: {
                return BarCodeType.DATA_MATRIX;
            }
            case 7: {
                return BarCodeType.EAN_8;
            }
            case 8: {
                return BarCodeType.EAN_13;
            }
            case 9: {
                return BarCodeType.ITF;
            }
            case 10: {
                return BarCodeType.MAXICODE;
            }
            case 11: {
                return BarCodeType.PDF_417;
            }
            case 12: {
                return BarCodeType.QR_CODE;
            }
            case 13: {
                return BarCodeType.RSS_14;
            }
            case 14: {
                return BarCodeType.RSS_EXPANDED;
            }
            case 15: {
                return BarCodeType.UPC_A;
            }
            case 16: {
                return BarCodeType.UPC_E;
            }
            case 17: {
                return BarCodeType.UPC_EAN_EXTENSION;
            }
        }
        return BarCodeType.UNKNOWN;
    }

    @Inject
    public DefaultScanbotBarcodeDetector(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.logger = LoggerProvider.getLogger();
        this.barcodeFormatsFilter = new ArrayList();
        this.barcodeScanEnabled = new AtomicBoolean(true);
        this.scanner = new BarCodeScanner();
        SapManager sapManager = c.a();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"SapSingleton.getInstance()");
        this.sapManager = sapManager;
    }
}

