/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.blob;

import android.content.res.AssetManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import net.doo.snap.a.a;
import net.doo.snap.entity.Blob;
import net.doo.snap.persistence.BlobStoreStrategy;
import org.jetbrains.annotations.NotNull;

public class BlobFactory {
    private static final String PDF_FONT = "pdf.ttf";
    private static final String BANKS_DATA_FILENAME = "banks.csv";
    private static final String MRZ_TRAINEDDATA_FILENAME = "ocrb.traineddata";
    private static final String MRZ_CASCADE_FILENAME = "mrz.xml";
    private static final String CHEQUE_OCRA_TRAINEDDATA_FILENAME = "ocra.traineddata";
    private static final String CHEQUE_MICR_TRAINEDDATA_FILENAME = "micr.traineddata";
    private final BlobStoreStrategy blobStoreStrategy;
    private final a blobsStorage;
    private final AssetManager assetManager;

    @Inject
    public BlobFactory(BlobStoreStrategy blobStoreStrategy, a blobsStorage, AssetManager assetManager) {
        this.blobStoreStrategy = blobStoreStrategy;
        this.blobsStorage = blobsStorage;
        this.assetManager = assetManager;
    }

    @NotNull
    public Collection<Blob> ocrLanguageBlobs() throws IOException {
        HashSet<Blob> hashSet = new HashSet<Blob>();
        File file = this.blobStoreStrategy.getOCRDataDirectory();
        String string2 = this.blobsStorage.a().toString();
        String[] stringArray = this.assetManager.list(string2);
        if (stringArray != null) {
            for (String string3 : stringArray) {
                File file2 = new File(string2, string3);
                hashSet.add(new Blob(new File(file, file2.getName()).getPath(), file2.getPath()));
            }
        }
        Blob blob = new Blob(new File(file, PDF_FONT).getPath(), PDF_FONT);
        hashSet.add(blob);
        return hashSet;
    }

    @NotNull
    public Blob bankDataBlob() throws IOException {
        File file = this.blobStoreStrategy.getBanksDataFile();
        return new Blob(file.getPath(), BANKS_DATA_FILENAME);
    }

    @NotNull
    public Blob mrzTraineddataBlob() throws IOException {
        File file = this.blobStoreStrategy.getMRZTraindataFile();
        return new Blob(file.getPath(), MRZ_TRAINEDDATA_FILENAME);
    }

    @NotNull
    public Blob mrzCascadeBlob() throws IOException {
        File file = this.blobStoreStrategy.getMRZCascadeFile();
        return new Blob(file.getPath(), MRZ_CASCADE_FILENAME);
    }

    @NotNull
    public Blob chequeOCRATraineddataBlob() throws IOException {
        File file = this.blobStoreStrategy.getChequeOCRATraindataFile();
        return new Blob(file.getPath(), CHEQUE_OCRA_TRAINEDDATA_FILENAME);
    }

    @NotNull
    public Blob chequeMICRTraineddataBlob() throws IOException {
        File file = this.blobStoreStrategy.getChequeMICRTraindataFile();
        return new Blob(file.getPath(), CHEQUE_MICR_TRAINEDDATA_FILENAME);
    }
}

