/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.barcodescanner.BarCodeScanner;
import io.scanbot.barcodescanner.model.BarCodeItem;
import io.scanbot.barcodescanner.model.BarCodeScannerDocumentFormat;
import io.scanbot.barcodescanner.model.BarCodeScannerResult;
import io.scanbot.barcodescanner.model.BarCodeType;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.barcode.DefaultScanbotBarcodeDetector$WhenMappings;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.doo.snap.c.c;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J2\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020 H\u0002J\u0016\u0010$\u001a\u00020\u001d2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020 0&H\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/scanbot/sdk/barcode/DefaultScanbotBarcodeDetector;", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "barcodeFormatsFilter", "Ljava/util/ArrayList;", "Lio/scanbot/barcodescanner/model/BarCodeType;", "Lkotlin/collections/ArrayList;", "barcodeScanEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "sapManager", "Lio/scanbot/sap/SapManager;", "scanner", "Lio/scanbot/barcodescanner/BarCodeScanner;", "decodeWithState", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "data", "", "width", "", "height", "frameOrientation", "finderRect", "Landroid/graphics/Rect;", "enableBarcodeScan", "", "", "getAppFormat", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "zxingBarcodeFormat", "getCoreFormat", "barcodeFormat", "setBarcodeFormatsFilter", "barcodeFormats", "", "scanbot-sdk_release"})
public final class DefaultScanbotBarcodeDetector
implements ScanbotBarcodeDetector {
    private final Logger logger;
    private BarCodeScanner scanner;
    private final SapManager sapManager;
    private final ArrayList<BarCodeType> barcodeFormatsFilter;
    private final AtomicBoolean barcodeScanEnabled;

    private final BarcodeFormat getAppFormat(BarCodeType barCodeType) {
        if (barCodeType == null) {
            return BarcodeFormat.UNKNOWN;
        }
        switch (DefaultScanbotBarcodeDetector$WhenMappings.$EnumSwitchMapping$0[barCodeType.ordinal()]) {
            default: {
                return BarcodeFormat.UNKNOWN;
            }
            case 17: {
                return BarcodeFormat.UPC_EAN_EXTENSION;
            }
            case 16: {
                return BarcodeFormat.UPC_E;
            }
            case 15: {
                return BarcodeFormat.UPC_A;
            }
            case 14: {
                return BarcodeFormat.RSS_EXPANDED;
            }
            case 13: {
                return BarcodeFormat.RSS_14;
            }
            case 12: {
                return BarcodeFormat.QR_CODE;
            }
            case 11: {
                return BarcodeFormat.PDF_417;
            }
            case 10: {
                return BarcodeFormat.MAXICODE;
            }
            case 9: {
                return BarcodeFormat.ITF;
            }
            case 8: {
                return BarcodeFormat.EAN_13;
            }
            case 7: {
                return BarcodeFormat.EAN_8;
            }
            case 6: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 5: {
                return BarcodeFormat.CODE_128;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 3: {
                return BarcodeFormat.CODE_39;
            }
            case 2: {
                return BarcodeFormat.CODABAR;
            }
            case 1: 
        }
        return BarcodeFormat.AZTEC;
    }

    private final BarCodeType getCoreFormat(BarcodeFormat barcodeFormat) {
        switch (DefaultScanbotBarcodeDetector$WhenMappings.$EnumSwitchMapping$1[barcodeFormat.ordinal()]) {
            default: {
                return BarCodeType.UNKNOWN;
            }
            case 17: {
                return BarCodeType.UPC_EAN_EXTENSION;
            }
            case 16: {
                return BarCodeType.UPC_E;
            }
            case 15: {
                return BarCodeType.UPC_A;
            }
            case 14: {
                return BarCodeType.RSS_EXPANDED;
            }
            case 13: {
                return BarCodeType.RSS_14;
            }
            case 12: {
                return BarCodeType.QR_CODE;
            }
            case 11: {
                return BarCodeType.PDF_417;
            }
            case 10: {
                return BarCodeType.MAXICODE;
            }
            case 9: {
                return BarCodeType.ITF;
            }
            case 8: {
                return BarCodeType.EAN_13;
            }
            case 7: {
                return BarCodeType.EAN_8;
            }
            case 6: {
                return BarCodeType.DATA_MATRIX;
            }
            case 5: {
                return BarCodeType.CODE_128;
            }
            case 4: {
                return BarCodeType.CODE_93;
            }
            case 3: {
                return BarCodeType.CODE_39;
            }
            case 2: {
                return BarCodeType.CODABAR;
            }
            case 1: 
        }
        return BarCodeType.AZTEC;
    }

    @Inject
    public DefaultScanbotBarcodeDetector(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.logger = LoggerProvider.getLogger();
        this.barcodeFormatsFilter = new ArrayList();
        this.barcodeScanEnabled = new AtomicBoolean(true);
        this.scanner = new BarCodeScanner();
        SapManager sapManager = c.a();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"SapSingleton.getInstance()");
        this.sapManager = sapManager;
    }

    @Override
    public void enableBarcodeScan(boolean bl) {
        this.barcodeScanEnabled.set(bl);
    }

    @Override
    public synchronized void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> object) {
        ArrayList<BarCodeType> arrayList;
        DefaultScanbotBarcodeDetector defaultScanbotBarcodeDetector = this;
        Intrinsics.checkParameterIsNotNull(object, (String)"barcodeFormats");
        defaultScanbotBarcodeDetector.barcodeFormatsFilter.clear();
        ArrayList<BarCodeType> arrayList2 = defaultScanbotBarcodeDetector.barcodeFormatsFilter;
        ArrayList<BarCodeType> arrayList3 = arrayList;
        arrayList = new ArrayList<BarCodeType>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList3.add(this.getCoreFormat((BarcodeFormat)((Object)object.next())));
        }
        arrayList2.addAll(arrayList3);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] object, int n2, int n3, int n4) {
        ArrayList<BarcodeItem> arrayList;
        void var4_7;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"data");
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            new BarcodeScanningResult(BarcodeScanningResult.ERROR_LICENSE_INVALID);
        }
        if ((object = this.scanner.detectAndDecode((byte[])object, this.barcodeFormatsFilter, n2, n3, (int)var4_7)) == null || !((BarCodeScannerResult)object).success) return null;
        object = ((BarCodeScannerResult)object).detectedBarCodes;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"codeScannerResult.detectedBarCodes");
        ArrayList<BarcodeItem> arrayList2 = arrayList;
        arrayList = new ArrayList<BarcodeItem>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Charset charset;
            BarCodeItem barCodeItem = (BarCodeItem)object.next();
            String string = barCodeItem.rawString;
            if (string == null) {
                string = "";
            }
            Object object2 = barCodeItem.rawString;
            if (object2 != null) {
                charset = Charsets.UTF_8;
                if (object2 == null) throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                byte[] byArray = ((String)object2).getBytes(charset);
                object2 = byArray;
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            } else {
                object2 = null;
            }
            BarcodeFormat barcodeFormat = this.getAppFormat(barCodeItem.type);
            charset = barCodeItem.documentFormat;
            arrayList2.add(new BarcodeItem(string, (byte[])object2, null, barcodeFormat, (BarCodeScannerDocumentFormat)charset));
        }
        return new BarcodeScanningResult(arrayList2, 0L, 2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] object, int n2, int n3, int n4, @NotNull Rect object2) {
        ArrayList<BarcodeItem> arrayList;
        void var4_7;
        void var5_9;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)var5_9, (String)"finderRect");
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            new BarcodeScanningResult(BarcodeScanningResult.ERROR_LICENSE_INVALID);
        }
        if ((object = this.scanner.detectAndDecodeInArea((byte[])object, this.barcodeFormatsFilter, (Rect)var5_9, n2, n3, (int)var4_7)) == null || !((BarCodeScannerResult)object).success) return null;
        object = ((BarCodeScannerResult)object).detectedBarCodes;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"codeScannerResult.detectedBarCodes");
        ArrayList<BarcodeItem> arrayList2 = arrayList;
        arrayList = new ArrayList<BarcodeItem>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            void var5_14;
            Charset charset;
            BarCodeItem barCodeItem = (BarCodeItem)object.next();
            String string = barCodeItem.rawString;
            if (string == null) {
                string = "";
            }
            String string2 = barCodeItem.rawString;
            if (string2 != null) {
                charset = Charsets.UTF_8;
                if (string2 == null) throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            } else {
                Object var5_13 = null;
            }
            BarcodeFormat barcodeFormat = this.getAppFormat(barCodeItem.type);
            charset = barCodeItem.documentFormat;
            arrayList2.add(new BarcodeItem(string, (byte[])var5_14, null, barcodeFormat, (BarCodeScannerDocumentFormat)charset));
        }
        return new BarcodeScanningResult(arrayList2, 0L, 2, null);
    }
}

