/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.BarcodeDetector;
import io.scanbot.barcodescanner.model.BarCodeScannerDocumentFormat;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.barcode.GoogleVisionBarcodeDetector$WhenMappings;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.doo.snap.c.c;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J2\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J%\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u00010\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cH\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0019H\u0002J\u0016\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190%H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/scanbot/sdk/barcode/GoogleVisionBarcodeDetector;", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "barcodeScanEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "detector", "Lcom/google/android/gms/vision/barcode/BarcodeDetector;", "sapManager", "Lio/scanbot/sap/SapManager;", "decodeWithState", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "data", "", "width", "", "height", "frameOrientation", "finderRect", "Landroid/graphics/Rect;", "enableBarcodeScan", "", "", "getAppFormat", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "googleVisionFormat", "getCornerPoints", "", "Lio/scanbot/sdk/barcode/entity/ResultPoint;", "cornerPoints", "Landroid/graphics/Point;", "([Landroid/graphics/Point;)[Lio/scanbot/sdk/barcode/entity/ResultPoint;", "getGVFormat", "barcodeFormat", "setBarcodeFormatsFilter", "barcodeFormats", "", "scanbot-sdk_release"})
public final class GoogleVisionBarcodeDetector
implements ScanbotBarcodeDetector {
    private final SapManager sapManager;
    private BarcodeDetector detector;
    private final AtomicBoolean barcodeScanEnabled;
    private final Context context;

    private final ResultPoint[] getCornerPoints(Point[] pointArray) {
        ArrayList arrayList;
        ResultPoint[] resultPointArray = arrayList;
        arrayList = new ArrayList();
        for (Point point : pointArray) {
            resultPointArray.add(new ResultPoint(point.x, point.y));
        }
        if ((resultPointArray = resultPointArray.toArray(new ResultPoint[0])) != null) {
            return resultPointArray;
        }
        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
    }

    private final BarcodeFormat getAppFormat(int n2) {
        switch (n2) {
            default: {
                return BarcodeFormat.UNKNOWN;
            }
            case 4096: {
                return BarcodeFormat.AZTEC;
            }
            case 2048: {
                return BarcodeFormat.PDF_417;
            }
            case 1024: {
                return BarcodeFormat.UPC_E;
            }
            case 512: {
                return BarcodeFormat.UPC_A;
            }
            case 256: {
                return BarcodeFormat.QR_CODE;
            }
            case 128: {
                return BarcodeFormat.ITF;
            }
            case 64: {
                return BarcodeFormat.EAN_8;
            }
            case 32: {
                return BarcodeFormat.EAN_13;
            }
            case 16: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 8: {
                return BarcodeFormat.CODABAR;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 2: {
                return BarcodeFormat.CODE_39;
            }
            case 1: 
        }
        return BarcodeFormat.CODE_128;
    }

    private final int getGVFormat(BarcodeFormat barcodeFormat) {
        switch (GoogleVisionBarcodeDetector$WhenMappings.$EnumSwitchMapping$0[barcodeFormat.ordinal()]) {
            default: {
                return 0;
            }
            case 19: {
                return 1024;
            }
            case 18: {
                return 512;
            }
            case 17: {
                return 256;
            }
            case 16: {
                return 2048;
            }
            case 15: {
                return 128;
            }
            case 14: {
                return 32;
            }
            case 13: {
                return 64;
            }
            case 12: {
                return 16;
            }
            case 11: {
                return 1;
            }
            case 10: {
                return 4;
            }
            case 9: {
                return 2;
            }
            case 8: {
                return 8;
            }
            case 7: {
                return 4096;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
        }
        return 0;
    }

    @Inject
    public GoogleVisionBarcodeDetector(@NotNull Context context) {
        GoogleVisionBarcodeDetector googleVisionBarcodeDetector = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        googleVisionBarcodeDetector.context = context;
        googleVisionBarcodeDetector.barcodeScanEnabled = new AtomicBoolean(true);
        googleVisionBarcodeDetector.detector = new BarcodeDetector.Builder(this.context).build();
        SapManager sapManager = c.a();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"SapSingleton.getInstance()");
        googleVisionBarcodeDetector.sapManager = sapManager;
    }

    @Override
    public void enableBarcodeScan(boolean bl) {
        this.barcodeScanEnabled.set(bl);
    }

    @Override
    public synchronized void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> barcodeDetector) {
        BarcodeDetector barcodeDetector2 = barcodeDetector;
        Intrinsics.checkParameterIsNotNull(barcodeDetector2, (String)"barcodeFormats");
        if (barcodeDetector2.isEmpty()) {
            barcodeDetector = this.detector;
            if (barcodeDetector == null) {
                Intrinsics.throwNpe();
            }
            barcodeDetector.release();
            this.detector = new BarcodeDetector.Builder(this.context).build();
        } else {
            Object object = this.detector;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            object.release();
            int n2 = 0;
            object = barcodeDetector.iterator();
            while (object.hasNext()) {
                n2 |= this.getGVFormat((BarcodeFormat)((Object)object.next()));
            }
            this.detector = new BarcodeDetector.Builder(this.context).setBarcodeFormats(n2).build();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] object, int n2, int n3, int n4) {
        GoogleVisionBarcodeDetector googleVisionBarcodeDetector;
        ArrayList<BarcodeItem> arrayList;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"data");
        ArrayList<BarcodeItem> arrayList2 = arrayList;
        arrayList = new ArrayList<BarcodeItem>();
        if (googleVisionBarcodeDetector.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!googleVisionBarcodeDetector.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            return new BarcodeScanningResult(BarcodeScanningResult.ERROR_LICENSE_INVALID);
        }
        BarcodeDetector barcodeDetector = googleVisionBarcodeDetector.detector;
        if (barcodeDetector == null) return null;
        if (barcodeDetector == null) {
            Intrinsics.throwNpe();
        }
        if (!barcodeDetector.isOperational()) {
            return null;
        }
        try {
            int n5;
            void var2_7;
            Frame.Builder builder;
            ByteBuffer byteBuffer = MappedByteBuffer.wrap(object);
            Frame.Builder builder2 = builder;
            builder2();
            Frame frame = builder.setImageData(byteBuffer, (int)var2_7, n5, 17).build();
            BarcodeDetector barcodeDetector2 = googleVisionBarcodeDetector.detector;
            if (barcodeDetector2 == null) {
                Intrinsics.throwNpe();
            }
            SparseArray sparseArray = barcodeDetector2.detect(frame);
            Intrinsics.checkExpressionValueIsNotNull((Object)sparseArray, (String)"barcodes");
            n5 = sparseArray.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                sparseArray.keyAt(i2);
                Barcode barcode = (Barcode)sparseArray.valueAt(i2);
                String string = barcode.rawValue;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.rawValue");
                ResultPoint[] resultPointArray = barcode.rawValue;
                Intrinsics.checkExpressionValueIsNotNull((Object)resultPointArray, (String)"value.rawValue");
                Charset charset = Charsets.UTF_8;
                if (barcode.rawValue != null) {
                    byte[] byArray = resultPointArray.getBytes(charset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    Intrinsics.checkExpressionValueIsNotNull((Object)barcode.cornerPoints, (String)"value.cornerPoints");
                    resultPointArray = googleVisionBarcodeDetector.getCornerPoints(barcode.cornerPoints);
                    BarcodeFormat barcodeFormat = googleVisionBarcodeDetector.getAppFormat(barcode.format);
                    BarCodeScannerDocumentFormat barCodeScannerDocumentFormat = null;
                    int n6 = 16;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    arrayList2.add(new BarcodeItem(string, byArray, resultPointArray, barcodeFormat, barCodeScannerDocumentFormat, n6, defaultConstructorMarker));
                    continue;
                }
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
        }
        catch (Throwable throwable) {
            googleVisionBarcodeDetector = googleVisionBarcodeDetector.detector;
            if (googleVisionBarcodeDetector == null) {
                Intrinsics.throwNpe();
            }
            googleVisionBarcodeDetector.release();
            throw throwable;
        }
        googleVisionBarcodeDetector = googleVisionBarcodeDetector.detector;
        if (googleVisionBarcodeDetector == null) {
            Intrinsics.throwNpe();
        }
        googleVisionBarcodeDetector.release();
        return new BarcodeScanningResult(arrayList2, 0L, 2, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] var1_1, int var2_3, int var3_5, int var4_8, @NotNull Rect var5_11) {
        block28: {
            block27: {
                block31: {
                    block30: {
                        block29: {
                            Intrinsics.checkParameterIsNotNull((Object)var1_1 /* !! */ , (String)"data");
                            Intrinsics.checkParameterIsNotNull((Object)var5_11 /* !! */ , (String)"finderRect");
                            var6_12 = v0;
                            v0 = new ArrayList<BarcodeItem>();
                            if (this.barcodeScanEnabled.compareAndSet(false, false)) {
                                return null;
                            }
                            if (!this.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
                                return new BarcodeScanningResult(BarcodeScanningResult.ERROR_LICENSE_INVALID);
                            }
                            var7_13 = this.detector;
                            if (var7_13 == null) break block28;
                            if (var7_13 == null) {
                                Intrinsics.throwNpe();
                            }
                            if (!var7_13.isOperational()) break block28;
                            var7_14 = var4_8 != 0 && var4_8 != 180 ? var3_5 : var2_3;
                            if (var4_8 == 0 || var4_8 == 180) ** GOTO lbl19
                            var8_16 = var5_11 /* !! */ .height();
                            break block29;
lbl19:
                            // 1 sources

                            var8_16 = var5_11 /* !! */ .width();
                        }
                        if (var4_8 == 0 || var4_8 == 180) ** GOTO lbl25
                        var9_18 = var5_11 /* !! */ .width();
                        break block30;
lbl25:
                        // 1 sources

                        var9_18 = var5_11 /* !! */ .height();
                    }
                    if (var4_8 == 0 || var4_8 == 180) ** GOTO lbl31
                    var10_20 = var5_11 /* !! */ .top;
                    break block31;
lbl31:
                    // 1 sources

                    var10_20 = var5_11 /* !! */ .left;
                }
                if (var4_8 == 0 || var4_8 == 180) break block27;
                var4_8 = var7_14 - var5_11 /* !! */ .right;
                ** GOTO lbl40
            }
            var4_8 = var5_11 /* !! */ .top;
lbl40:
            // 2 sources

            v1 = this;
            v2 = var1_1 /* !! */ ;
            v3 = v4;
            var1_1 /* !! */  = (byte[])v4;
            v3(var10_20, var4_8, var10_20 + var8_16, var4_8 + var9_18);
            var4_9 = MappedByteBuffer.wrap(v2);
            var5_11 /* !! */  = v5;
            v6 = var5_11 /* !! */ ;
            v7 = var4_9;
            v8 = var2_3;
            v9 = var3_5;
            var5_11 /* !! */ ();
            var2_4 = v6.setImageData(v7, v8, v9, 17).build();
            var3_6 = v1.detector;
            if (var3_6 != null) ** GOTO lbl59
            Intrinsics.throwNpe();
lbl59:
            // 2 sources

            var2_4 = var3_6.detect(var2_4);
            v10 = var2_4;
            try {
                var4_10 = v10.size();
            }
            catch (Throwable var1_2) {
                this = this.detector;
                if (this == null) {
                    Intrinsics.throwNpe();
                }
                this.release();
                throw var1_2;
            }
            for (var3_7 = 0; var3_7 < var4_10; ++var3_7) {
                v11 /* !! */  = var1_1 /* !! */ ;
                v12 = (Barcode)var2_4.valueAt(var3_7);
                v13 = var5_11 /* !! */ ;
                Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"barcode");
                if (!v11 /* !! */ .contains(v12.getBoundingBox())) continue;
                v14 = var5_11 /* !! */ ;
                v15 = v14;
                v16 = v14.rawValue;
                Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"barcode.rawValue");
                v17 = v15.rawValue;
                v18 = var8_17 = v15.rawValue;
                Intrinsics.checkExpressionValueIsNotNull((Object)v18, (String)"barcode.rawValue");
                var9_19 /* !! */  = Charsets.UTF_8;
                if (v17 != null) {
                    v19 = var6_12;
                    v20 = this;
                    v21 = var5_11 /* !! */ ;
                    v22 = this;
                    v23 = var5_11 /* !! */ ;
                    v24 = var8_17.getBytes(var9_19 /* !! */ );
                    v25 = v24;
                    var5_11 /* !! */  = (Rect)v24;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v25, (String)"(this as java.lang.String).getBytes(charset)");
                    v26 = v23.cornerPoints;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v26, (String)"barcode.cornerPoints");
                    var8_17 = v22.getCornerPoints(v23.cornerPoints);
                    var9_19 /* !! */  = v20.getAppFormat(v21.format);
                    var10_21 = null;
                    var11_22 = 16;
                    var12_23 = null;
                    v19.add(new BarcodeItem(var7_15, (byte[])var5_11 /* !! */ , var8_17, (BarcodeFormat)var9_19 /* !! */ , var10_21, var11_22, var12_23));
                    continue;
                }
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            this = this.detector;
            if (this == null) {
                Intrinsics.throwNpe();
            }
            this.release();
            return new BarcodeScanningResult(var6_12, 0L, 2, null);
        }
        return null;
    }
}

