/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.persistence.PolygonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.R;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ContourDetectorFrameHandler
implements PreviewBuffer.FrameHandler {
    private final ContourDetector contourDetector;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    protected final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private final int finderInnerThresholdPx;
    private final int finderOuterThresholdPx;
    protected boolean enabled = true;
    private List<PageAspectRatio> requiredPageAspectRatios = null;

    public static ContourDetectorFrameHandler attach(ScanbotCameraView scanbotCameraView) {
        ContourDetectorFrameHandler contourDetectorFrameHandler;
        ContourDetectorFrameHandler contourDetectorFrameHandler2 = contourDetectorFrameHandler;
        contourDetectorFrameHandler2(scanbotCameraView.getContext());
        scanbotCameraView.getPreviewBuffer().addFrameHandler(contourDetectorFrameHandler2);
        return contourDetectorFrameHandler;
    }

    public ContourDetectorFrameHandler(Context context) {
        this.contourDetector = new ContourDetector();
        this.sapManager = c.a();
        this.finderInnerThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_inner_threshold);
        this.finderOuterThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_outer_threshold);
    }

    private DetectionResult detectOffCenter(PreviewBuffer.FrameHandler.Frame frame, DetectionResult detectionResult, List<PointF> list) {
        Rect rect = frame.finderRect;
        if (!(rect == null || rect.isEmpty() || detectionResult != DetectionResult.OK && detectionResult != DetectionResult.OK_BUT_BAD_ASPECT_RATIO && detectionResult != DetectionResult.OK_BUT_TOO_SMALL && detectionResult != DetectionResult.OK_BUT_BAD_ANGLES)) {
            Rect rect2;
            list = PolygonHelper.rotatePolygon(list, frame.frameOrientation);
            int n2 = frame.frameOrientation % 180 == 0 ? 1 : 0;
            int n3 = n2 != 0 ? frame.width : frame.height;
            n2 = n2 != 0 ? frame.height : frame.width;
            Rect rect3 = rect2;
            float f2 = n3;
            float f3 = n2;
            rect2 = new Rect((int)(list.get((int)0).x * f2), (int)(list.get((int)0).y * f3), (int)(list.get((int)2).x * f2), (int)(list.get((int)2).y * f3));
            if (this.checkOuterThreshold(frame.finderRect, rect3)) {
                detectionResult = DetectionResult.OK_OFF_CENTER;
            } else if (!this.requiredPageAspectRatios.isEmpty() && this.checkInnerThreshold(frame.finderRect, rect3)) {
                detectionResult = DetectionResult.OK_BUT_TOO_SMALL;
            }
        }
        return detectionResult;
    }

    private boolean checkInnerThreshold(Rect rect, Rect rect2) {
        int n2 = this.finderInnerThresholdPx;
        return rect2.left - rect.left > n2 || rect2.top - rect.top > n2 || rect.bottom - rect2.bottom > n2 || rect.right - rect2.right > n2;
    }

    private boolean checkOuterThreshold(Rect rect, Rect rect2) {
        int n2 = this.finderOuterThresholdPx;
        return rect.left - rect2.left > n2 || rect.top - rect2.top > n2 || rect2.bottom - rect.bottom > n2 || rect2.right - rect.right > n2;
    }

    private void setRectOfInterest(int n2, RectF rectF) {
        if (rectF != null) {
            Matrix matrix;
            ContourDetectorFrameHandler contourDetectorFrameHandler = contourDetectorFrameHandler2;
            ContourDetectorFrameHandler contourDetectorFrameHandler2 = matrix;
            contourDetectorFrameHandler2();
            contourDetectorFrameHandler2.setRotate(n2, 0.5f, 0.5f);
            matrix.mapRect(rectF);
            contourDetectorFrameHandler.contourDetector.setRectOfInterest(rectF);
        }
    }

    private void fixRequiredAspectRatios(int n2) {
        ArrayList<PageAspectRatio> arrayList = this.requiredPageAspectRatios;
        if (arrayList != null && !arrayList.isEmpty()) {
            ArrayList<PageAspectRatio> arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<PageAspectRatio>();
            for (PageAspectRatio pageAspectRatio : this.requiredPageAspectRatios) {
                PageAspectRatio pageAspectRatio2;
                if (n2 % 180 == 0) {
                    PageAspectRatio pageAspectRatio3;
                    pageAspectRatio2 = pageAspectRatio3;
                    pageAspectRatio3 = new PageAspectRatio(pageAspectRatio.width, pageAspectRatio.height);
                } else {
                    PageAspectRatio pageAspectRatio4;
                    pageAspectRatio2 = pageAspectRatio4;
                    pageAspectRatio4 = new PageAspectRatio(pageAspectRatio.height, pageAspectRatio.width);
                }
                arrayList.add(pageAspectRatio2);
            }
            this.contourDetector.setRequiredAspectRatios(arrayList);
        }
    }

    @Override
    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame frame) {
        ContourDetectorFrameHandler contourDetectorFrameHandler = this;
        contourDetectorFrameHandler.logger.logMethod();
        if (!contourDetectorFrameHandler.enabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.EdgeDetection).booleanValue()) {
            this.notifyHandlers(new DetectedFrame(1));
            return false;
        }
        ContourDetectorFrameHandler contourDetectorFrameHandler2 = this;
        ContourDetectorFrameHandler contourDetectorFrameHandler3 = this;
        this.fixRequiredAspectRatios(frame.frameOrientation);
        contourDetectorFrameHandler3.setRectOfInterest(frame.frameOrientation, frame.visibleRect);
        List list = this.contourDetector.getPolygonF();
        DetectionResult detectionResult = contourDetectorFrameHandler2.detectOffCenter(frame, contourDetectorFrameHandler3.contourDetector.detect(frame.frame, frame.width, frame.height), list);
        return contourDetectorFrameHandler2.notifyHandlers(new DetectedFrame(detectionResult, list, frame.frameOrientation, frame.width, frame.height, this.contourDetector.getDetectionScore(), frame.finderRect, this.requiredPageAspectRatios));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(resultHandler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(resultHandler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final void setAcceptedAngleScore(double d2) {
        if (!(d2 < 0.0) && !(d2 > 100.0)) {
            this.contourDetector.setAcceptedAngleScore(d2);
            return;
        }
        throw new IllegalArgumentException("Invalid acceptedAngleScore value.");
    }

    public final void setAcceptedSizeScore(double d2) {
        if (!(d2 < 0.0) && !(d2 > 100.0)) {
            this.contourDetector.setAcceptedSizeScore(d2);
            return;
        }
        throw new IllegalArgumentException("Invalid acceptedSizeScore value.");
    }

    public final void setRequiredAspectRatios(List<PageAspectRatio> list) {
        this.requiredPageAspectRatios = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean notifyHandlers(DetectedFrame detectedFrame) {
        ContourDetectorFrameHandler contourDetectorFrameHandler = this;
        boolean bl = false;
        Set<ResultHandler> set = contourDetectorFrameHandler.handlers;
        synchronized (set) {
            Iterator<ResultHandler> iterator = contourDetectorFrameHandler.handlers.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return bl;
                }
                bl |= iterator.next().handleResult(detectedFrame);
            }
        }
    }

    public static class DetectedFrame {
        public static final int NO_ERROR = -1;
        public static final int ERROR_LICENSE_INVALID = 1;
        public final DetectionResult detectionResult;
        public final List<PointF> polygon;
        public final int frameOrientation;
        public final int frameWidth;
        public final int frameHeight;
        public final double detectionScore;
        public final int errorCode;
        public final Rect finderRect;
        public final List<PageAspectRatio> requiredPageAspectRatios;

        @Deprecated
        public DetectedFrame(DetectionResult detectionResult, List<PointF> list, int n2, int n3, int n4) {
            DetectedFrame detectedFrame = this;
            this.detectionResult = detectionResult;
            this.frameOrientation = n2;
            this.frameWidth = n3;
            this.frameHeight = n4;
            detectedFrame.polygon = Collections.unmodifiableList(list);
            detectedFrame.detectionScore = 0.0;
            detectedFrame.errorCode = -1;
            detectedFrame.finderRect = null;
            detectedFrame.requiredPageAspectRatios = null;
        }

        public DetectedFrame(DetectionResult detectionResult, List<PointF> list, int n2, int n3, int n4, double d2, Rect rect, List<PageAspectRatio> list2) {
            DetectedFrame detectedFrame = this;
            this.detectionResult = detectionResult;
            this.frameOrientation = n2;
            this.frameWidth = n3;
            this.frameHeight = n4;
            this.polygon = Collections.unmodifiableList(list);
            detectedFrame.detectionScore = d2;
            detectedFrame.errorCode = -1;
            this.finderRect = rect;
            this.requiredPageAspectRatios = list2;
        }

        public DetectedFrame(int n2) {
            DetectedFrame detectedFrame = this;
            this.detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
            this.frameOrientation = 0;
            this.frameWidth = 0;
            this.frameHeight = 0;
            this.polygon = Collections.emptyList();
            this.detectionScore = 0.0;
            detectedFrame.errorCode = n2;
            detectedFrame.finderRect = null;
            detectedFrame.requiredPageAspectRatios = null;
        }
    }

    public static interface ResultHandler {
        public boolean handleResult(DetectedFrame var1);
    }
}

