/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.dcscanner;

import android.content.Context;
import io.scanbot.dcscanner.model.DisabilityCertificateRecognizerResultInfo;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.dcscanner.DCScanner;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class DCScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private DCScanner dcScanner;
    private final Set<ResultHandler> handlers;
    private final SapManager sapManager;
    private final Logger logger;
    private boolean enabled;

    public static DCScannerFrameHandler attach(ScanbotCameraView scanbotCameraView, DCScanner dCScanner) {
        DCScannerFrameHandler dCScannerFrameHandler;
        DCScannerFrameHandler dCScannerFrameHandler2 = dCScannerFrameHandler;
        dCScannerFrameHandler2(scanbotCameraView.getContext(), dCScanner);
        scanbotCameraView.getPreviewBuffer().addFrameHandler(dCScannerFrameHandler2);
        return dCScannerFrameHandler;
    }

    public DCScannerFrameHandler(Context context, DCScanner dCScanner) {
        DCScannerFrameHandler dCScannerFrameHandler = this;
        this.handlers = new LinkedHashSet<ResultHandler>();
        this.logger = LoggerProvider.getLogger();
        this.enabled = true;
        dCScannerFrameHandler.dcScanner = dCScanner;
        dCScannerFrameHandler.sapManager = c.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean notifyHandlers(DisabilityCertificateRecognizerResultInfo disabilityCertificateRecognizerResultInfo) {
        DCScannerFrameHandler dCScannerFrameHandler = this;
        boolean bl = false;
        Set<ResultHandler> set = dCScannerFrameHandler.handlers;
        synchronized (set) {
            Iterator<ResultHandler> iterator = dCScannerFrameHandler.handlers.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return bl;
                }
                bl |= iterator.next().handleResult(disabilityCertificateRecognizerResultInfo);
            }
        }
    }

    @Override
    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame frame) {
        DCScannerFrameHandler dCScannerFrameHandler = this;
        dCScannerFrameHandler.logger.logMethod();
        if (!dCScannerFrameHandler.enabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.DisabilityCertRecognition).booleanValue()) {
            return false;
        }
        DCScannerFrameHandler dCScannerFrameHandler2 = this;
        return dCScannerFrameHandler2.notifyHandlers(dCScannerFrameHandler2.dcScanner.recognizeDC(frame.frame, frame.width, frame.height, frame.frameOrientation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(resultHandler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(resultHandler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public static interface ResultHandler {
        public boolean handleResult(DisabilityCertificateRecognizerResultInfo var1);
    }
}

