/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.bitmap;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BitmapUtils {
    public static Rect getBitmapBounds(String string2) {
        Rect rect = new Rect();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        int n2 = options.outWidth;
        int n3 = options.outHeight;
        rect.set(0, 0, n2, n3);
        return rect;
    }

    public static boolean isBitmapValid(Bitmap bitmap) {
        return bitmap != null && !bitmap.isRecycled();
    }

    public static Rect getContentBounds(Bitmap bitmap) throws NullPointerException {
        if (bitmap != null) {
            Bitmap bitmap2 = bitmap;
            int n2 = bitmap2.getWidth();
            int n3 = bitmap2.getHeight();
            int n4 = 0;
            int n5 = 0;
            for (int i2 = 0; i2 < bitmap.getHeight(); ++i2) {
                for (int i3 = 0; i3 < bitmap.getWidth(); ++i3) {
                    if (bitmap.getPixel(i3, i2) == 0) continue;
                    if (i3 < n2) {
                        n2 = i3;
                    }
                    if (i2 < n3) {
                        n3 = i2;
                    }
                    if (i3 > n4) {
                        n4 = i3;
                    }
                    if (i2 <= n5) continue;
                    n5 = i2;
                }
            }
            return new Rect(n2, n3, n4, n5);
        }
        throw new NullPointerException("Bitmap is null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void compress(Bitmap bitmap, Bitmap.CompressFormat compressFormat, int n2, File file) throws IOException {
        Throwable throwable2;
        FileOutputStream fileOutputStream;
        block4: {
            FileOutputStream fileOutputStream2;
            int n3;
            Bitmap.CompressFormat compressFormat2;
            Bitmap bitmap2;
            FileOutputStream fileOutputStream3;
            Object var4_4 = null;
            try {
                FileOutputStream fileOutputStream4;
                fileOutputStream3 = fileOutputStream = fileOutputStream4;
                bitmap2 = bitmap;
                compressFormat2 = compressFormat;
                n3 = n2;
                FileOutputStream fileOutputStream5 = fileOutputStream;
                fileOutputStream2 = fileOutputStream5;
                fileOutputStream5(file);
            }
            catch (Throwable throwable2) {
                fileOutputStream = var4_4;
                break block4;
            }
            try {
                bitmap2.compress(compressFormat2, n3, (OutputStream)fileOutputStream2);
            }
            catch (Throwable throwable2) {
                break block4;
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream3);
            return;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        throw throwable2;
    }

    public static Bitmap createPreview(Resources resources, int n2, int n3, int n4) {
        BitmapFactory.Options options;
        BitmapFactory.Options options2;
        if (n2 <= 0) {
            return null;
        }
        BitmapFactory.Options options3 = options2 = options;
        options3();
        options3.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)n2, (BitmapFactory.Options)options3);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, n3, n4);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)resources, (int)n2, (BitmapFactory.Options)options);
    }

    public static Bitmap createPreview(byte[] byArray, int n2, int n3) {
        BitmapFactory.Options options;
        if (byArray == null) {
            return null;
        }
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options2);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, n2, n3);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options2);
    }

    public static Bitmap createPreview(Bitmap bitmap, int n2, int n3) {
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = bitmap;
        n2 = BitmapUtils.calculateInSampleSize(n2, n3, bitmap.getWidth(), bitmap.getHeight());
        return Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)(bitmap2.getWidth() / n2), (int)(bitmap.getHeight() / n2), (boolean)false);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int n2, int n3) {
        BitmapFactory.Options options2 = options;
        int n4 = options2.outHeight;
        return BitmapUtils.calculateInSampleSize(n2, n3, options2.outWidth, n4);
    }

    private static int calculateInSampleSize(int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n4 > n5 ? 1 : 0;
        if (n7 != (n6 = n2 > n3)) {
            int n8 = n4;
            n4 = n5;
            n5 = n8;
        }
        n7 = 1;
        if (n5 > n3 || n4 > n2) {
            int n9 = n4;
            n4 = n5 / 2;
            n5 = n9 / 2;
            while (n4 / n7 > n3 && n5 / n7 > n2) {
                n7 *= 2;
            }
        }
        return n7;
    }

    public static Bitmap decodeQuietly(@Nullable String string2, @Nullable BitmapFactory.Options options) {
        File file;
        if (StringUtils.isEmpty((String)string2)) {
            return null;
        }
        File file2 = file;
        if (new File(string2).exists() && file2.isFile()) {
            return BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        }
        return null;
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap().copy(Bitmap.Config.ARGB_8888, true);
        }
        if (drawable.getIntrinsicWidth() > 0 && drawable.getIntrinsicHeight() > 0) {
            bitmapDrawable = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        } else {
            bitmapDrawable = Bitmap.Config.ARGB_8888;
            bitmapDrawable = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)bitmapDrawable);
        }
        Canvas canvas = new Canvas((Bitmap)bitmapDrawable);
        int n2 = canvas.getWidth();
        int n3 = canvas.getHeight();
        drawable.setBounds(0, 0, n2, n3);
        drawable.draw(canvas);
        return bitmapDrawable;
    }

    public static Bitmap scaleIfNeeded(Bitmap bitmap, int n2, int n3) {
        if (n2 >= bitmap.getHeight() && n3 >= bitmap.getWidth()) {
            return bitmap;
        }
        float f2 = Math.min((float)n3 / (float)bitmap.getWidth(), (float)n2 / (float)bitmap.getHeight());
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)Math.round(f2 * (float)bitmap.getWidth()), (int)Math.round(f2 * (float)bitmap.getHeight()), (boolean)false);
    }
}

