/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.log;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.a;

public final class DebugLog
implements Logger {
    public static final String LOG_DIRECTORY = "debug_logs";
    public static final String LOG_EXTENSION = ".txt";
    private static final String LOG_FIELD_SEPARATOR = " | ";
    private static final String UNKNOWN_SIGNATURE = "[unknown]";
    private static final String DEFAULT_PACKAGE_NAME = "default";
    private static final String NO_APPLICATION_INFO_MESSAGE = "[No application info]";
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss.SSS] ");
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("([A-Z]*|(^[a-z]))[_\\da-z\\$]*");
    private static boolean prepared = false;
    private static boolean savingEnabled = true;
    private static boolean echoEnabled = true;
    private static Logger.Level savingLevel;
    private static Logger.Level echoLevel;
    private static String packageName;

    public DebugLog(Context context) {
        prepared = true;
        if (context != null) {
            Context context2 = context;
            packageName = context2.getPackageName();
            this.printVersionInfo(context2);
        } else {
            packageName = DEFAULT_PACKAGE_NAME;
        }
    }

    private void printVersionInfo(Context object) {
        StringBuilder stringBuilder;
        PackageInfo packageInfo;
        block8: {
            block7: {
                StringBuilder stringBuilder2;
                String string2 = packageName;
                packageInfo = object.getPackageManager().getPackageInfo(string2, 0);
                int n2 = packageInfo.applicationInfo.labelRes;
                stringBuilder = stringBuilder2;
                stringBuilder2 = new StringBuilder();
                if (n2 == 0) break block7;
                object = object.getString(n2);
                break block8;
            }
            object = UNKNOWN_SIGNATURE;
        }
        StringBuilder stringBuilder3 = stringBuilder.append((String)object);
        StringBuilder stringBuilder4 = stringBuilder3.append(" v").append(packageInfo.versionName);
        try {
            object = stringBuilder4.append(" #").append(packageInfo.versionCode).toString();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.logException(nameNotFoundException);
            object = NO_APPLICATION_INFO_MESSAGE;
        }
        this.i("APP_INFO", (String)object);
    }

    private void logMessage(String string2, String string3, Logger.Level level) {
        if (!prepared) {
            return;
        }
        if (echoEnabled && level.ordinal() >= echoLevel.ordinal()) {
            this.echoMessage(string2, string3, level);
        }
        if (savingEnabled && level.ordinal() >= savingLevel.ordinal()) {
            this.logToFile(string2, string3, level);
        }
    }

    private void echoMessage(String string2, String string3, Logger.Level level) {
        switch (a.a[level.ordinal()]) {
            default: {
                break;
            }
            case 5: {
                Log.v((String)string2, (String)string3);
                break;
            }
            case 4: {
                Log.i((String)string2, (String)string3);
                break;
            }
            case 3: {
                Log.w((String)string2, (String)string3);
                break;
            }
            case 2: {
                Log.e((String)string2, (String)string3);
                break;
            }
            case 1: {
                Log.d((String)string2, (String)string3);
            }
        }
    }

    private synchronized void logToFile(String string2, String string3, Logger.Level level) {
        Writer writer = this.getLogWriter();
        if (writer != null) {
            try {
                Writer writer2 = writer;
                writer2.write(this.buildLogMessage(string2, string3, level));
                this.closeSafely(writer2);
            }
            catch (Throwable throwable) {
                this.closeSafely(writer);
                throw throwable;
            }
            catch (IOException iOException) {
                this.closeSafely(writer);
            }
        }
    }

    private void closeSafely(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {}
    }

    private String buildLogMessage(String string2, String string3, Logger.Level level) {
        String string4 = string2 != null ? string2.replace('|', '/') : "";
        return TIME_FORMAT.format(new Date()) + (Object)((Object)level) + LOG_FIELD_SEPARATOR + (String)string4 + LOG_FIELD_SEPARATOR + string3 + "\r\n";
    }

    private Writer getLogWriter() {
        FileWriter fileWriter;
        File file;
        Object var1_1 = null;
        File file2 = Environment.getExternalStorageDirectory();
        ((DebugLog)object2).prepareLogsFolder(file2);
        File file3 = file;
        file = new File(file2, ((DebugLog)object2).getLogFilename());
        Object object = object2 = fileWriter;
        try {
            ((FileWriter)object)(file3, true);
        }
        catch (IOException iOException) {
            Object object2 = var1_1;
        }
        return object2;
    }

    private void prepareLogsFolder(File file) {
        File file2;
        File file3 = file2;
        if (!new File(file, LOG_DIRECTORY).exists()) {
            file3.mkdir();
        }
    }

    private String getLogFilename() {
        return LOG_DIRECTORY + File.separatorChar + packageName + LOG_EXTENSION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String tokenizeClassName(String string2) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        try {
            Matcher matcher = CLASS_NAME_PATTERN.matcher(string2);
            while (matcher.find()) {
                String string3 = string2.substring(matcher.start(), matcher.end());
                if (TextUtils.isEmpty((CharSequence)string3.trim())) continue;
                arrayList2.add(string3.toUpperCase());
            }
            if (arrayList2.isEmpty()) return string2;
            return TextUtils.join((CharSequence)"_", (Iterable)arrayList2);
        }
        catch (Exception exception) {}
        return string2;
    }

    private String getCallerClassName() {
        Object object;
        block6: {
            try {
                object = Thread.currentThread().getStackTrace();
                if (((StackTraceElement[])object).length <= 4) break block6;
            }
            catch (Exception exception) {}
            Object object2 = object = object[4].getClassName();
            int n2 = ((String)object2).lastIndexOf(".");
            if (n2 < 0) break block6;
            ++n2;
            if (n2 >= ((String)object).length()) break block6;
            object = ((String)object).substring(n2);
        }
        object = UNKNOWN_SIGNATURE;
        return this.tokenizeClassName((String)object);
    }

    private String getCallerMethodName() {
        Object object;
        block3: {
            try {
                object = Thread.currentThread().getStackTrace();
                if (((StackTraceElement[])object).length <= 4) break block3;
            }
            catch (Exception exception) {}
            object = object[4].getMethodName();
        }
        object = UNKNOWN_SIGNATURE;
        return object;
    }

    static {
        echoLevel = savingLevel = Logger.Level.Verbose;
        packageName = DEFAULT_PACKAGE_NAME;
    }

    @Override
    public void d(String string2, String string3) {
        this.logMessage(string2, string3, Logger.Level.Debug);
    }

    @Override
    public void w(String string2, String string3) {
        this.logMessage(string2, string3, Logger.Level.Warning);
    }

    @Override
    public void e(String string2, String string3) {
        this.logMessage(string2, string3, Logger.Level.Error);
    }

    @Override
    public void i(String string2, String string3) {
        this.logMessage(string2, string3, Logger.Level.Information);
    }

    public void e(String string2, String string3, Throwable throwable) {
        this.e(string2, "Exception in " + string3 + ": " + throwable.getClass().getName() + LOG_FIELD_SEPARATOR + throwable.getMessage());
    }

    public void d(String string2) {
        DebugLog debugLog = this;
        debugLog.d(debugLog.getCallerClassName(), string2);
    }

    public void i(String string2) {
        DebugLog debugLog = this;
        debugLog.i(debugLog.getCallerClassName(), string2);
    }

    public void w(String string2) {
        DebugLog debugLog = this;
        debugLog.w(debugLog.getCallerClassName(), string2);
    }

    public void e(String string2) {
        DebugLog debugLog = this;
        debugLog.e(debugLog.getCallerClassName(), string2);
    }

    @Override
    public void logException(Throwable throwable) {
        if (!prepared) {
            return;
        }
        DebugLog debugLog = this;
        String string2 = debugLog.getCallerClassName();
        String string3 = debugLog.getCallerMethodName();
        if (throwable != null) {
            this.e(string2, string3, throwable);
        } else {
            this.e(string2, string3, new Exception("Unknown exception"));
        }
    }

    @Override
    public void logMethod() {
        if (!prepared) {
            return;
        }
        DebugLog debugLog = this;
        debugLog.i(debugLog.getCallerClassName(), this.getCallerMethodName());
    }
}

