/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.RequiresApi;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.PictureTransaction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.ScanbotSDKInitializer;
import net.doo.snap.camera.CameraOpenCallback;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.CameraStateCallback;
import net.doo.snap.camera.CameraTakePictureCallback;
import net.doo.snap.camera.CameraView;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.a;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.snap.Utils;
import net.doo.snap.util.thread.ExecutionUtils;

public class ScanbotCameraView
extends FrameLayout {
    private static final int TAKE_PICTURE_DELAY_MS = 500;
    private CameraView cameraView;
    private a cameraHost;
    private boolean resumed = false;
    private c state = c.a;
    private final Set<CameraStateCallback> stateCallbacks = new LinkedHashSet<CameraStateCallback>();
    private final Set<CameraTakePictureCallback> takePictureCallbacks = new LinkedHashSet<CameraTakePictureCallback>();
    private final Logger logger = LoggerProvider.getLogger();

    public ScanbotCameraView(Context context) {
        super(context);
        this.initView(context);
    }

    public ScanbotCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    /*
     * WARNING - void declaration
     */
    private void initView(Context context) {
        FrameLayout.LayoutParams layoutParams;
        void var1_1;
        if (!io.scanbot.sdk.ScanbotSDKInitializer.isInitialized() && !ScanbotSDKInitializer.isInitialized()) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
        }
        ScanbotCameraView scanbotCameraView = scanbotCameraView2;
        scanbotCameraView.cameraView = new CameraView((Context)var1_1);
        scanbotCameraView.cameraHost = new a((Context)var1_1);
        scanbotCameraView.cameraView.setCameraHost((CameraHost)scanbotCameraView2.cameraHost);
        scanbotCameraView.cameraView.a(scanbotCameraView2.new b());
        ScanbotCameraView scanbotCameraView2 = layoutParams;
        new FrameLayout.LayoutParams((int)-1, (int)-1).gravity = 17;
        scanbotCameraView.addView((View)scanbotCameraView.cameraView, 0, (ViewGroup.LayoutParams)scanbotCameraView2);
    }

    private void notifyResumedState() {
        Iterator<CameraStateCallback> this_ = ((ScanbotCameraView)((Object)this_)).stateCallbacks.iterator();
        while (this_.hasNext()) {
            ((CameraStateCallback)this_.next()).onResume();
        }
    }

    private void notifyPausedState() {
        Iterator<CameraStateCallback> this_ = ((ScanbotCameraView)((Object)this_)).stateCallbacks.iterator();
        while (this_.hasNext()) {
            ((CameraStateCallback)this_.next()).onPause();
        }
    }

    private void notifyTakePictureCancelled() {
        Iterator<CameraTakePictureCallback> this_ = ((ScanbotCameraView)((Object)this_)).takePictureCallbacks.iterator();
        while (this_.hasNext()) {
            ((CameraTakePictureCallback)this_.next()).onTakePictureCancelled();
        }
    }

    private void performSnapping() {
        PictureTransaction pictureTransaction;
        block5: {
            this.state = c.c;
            Camera.Parameters parameters = this.cameraView.getCameraParameters();
            pictureTransaction = new PictureTransaction((CameraHost)this.cameraHost).needBitmap(false).needByteArray(true).useSingleShotMode(true);
            if (parameters == null) break block5;
            pictureTransaction = pictureTransaction.flashMode(parameters.getFlashMode());
        }
        try {
            this.cameraView.takePicture(pictureTransaction);
        }
        catch (IllegalStateException illegalStateException) {
            this.state = c.a;
            this.notifyTakePictureCancelled();
        }
    }

    static /* synthetic */ c access$202(ScanbotCameraView x0, c x1) {
        x0.state = x1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean changed2, int left, int top, int right, int bottom) {
        void var1_2;
        ScanbotCameraView scanbotCameraView = this;
        this.logger.logMethod();
        super.onLayout(changed2, left, top, right, bottom);
        View changed2 = scanbotCameraView.cameraView.getChildAt(0);
        if (changed2 == null) {
            return;
        }
        void v1 = var1_2;
        int n2 = this.getChildCount();
        int n3 = View.MeasureSpec.makeMeasureSpec((int)v1.getWidth(), (int)Integer.MIN_VALUE);
        int n4 = View.MeasureSpec.makeMeasureSpec((int)v1.getHeight(), (int)Integer.MIN_VALUE);
        for (int i2 = 1; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            if (view instanceof CameraView) continue;
            view.measure(n3, n4);
            view.layout(var1_2.getLeft(), var1_2.getTop(), var1_2.getRight(), var1_2.getBottom());
        }
    }

    public PreviewBuffer getPreviewBuffer() {
        return this.cameraView.b();
    }

    public void onResume() {
        ScanbotCameraView scanbotCameraView = this;
        ExecutionUtils.ensureMainThread();
        scanbotCameraView.logger.logMethod();
        if (scanbotCameraView.resumed) {
            return;
        }
        ScanbotCameraView scanbotCameraView2 = this;
        scanbotCameraView2.resumed = net.doo.snap.c.c.a().isLicenseActive();
        scanbotCameraView2.state = c.a;
        scanbotCameraView2.cameraView.onResume();
        scanbotCameraView2.notifyResumedState();
    }

    public void onPause() {
        ScanbotCameraView scanbotCameraView = this;
        ExecutionUtils.ensureMainThread();
        scanbotCameraView.logger.logMethod();
        if (!scanbotCameraView.resumed) {
            return;
        }
        ScanbotCameraView scanbotCameraView2 = this;
        scanbotCameraView2.resumed = false;
        scanbotCameraView2.state = c.a;
        scanbotCameraView2.cameraView.onPause();
        scanbotCameraView2.notifyPausedState();
    }

    public void startPreview() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        if (!scanbotCameraView.resumed) {
            return;
        }
        this.state = c.a;
        this.cameraView.startPreview();
    }

    public void stopPreview() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        if (!scanbotCameraView.resumed) {
            return;
        }
        this.state = c.a;
        this.cameraView.stopPreview();
    }

    /*
     * WARNING - void declaration
     */
    public void takePicture(boolean aquireFocus) {
        void var1_1;
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        c c2 = c.a;
        if (scanbotCameraView.state != c2) {
            ScanbotCameraView scanbotCameraView2 = this;
            scanbotCameraView2.state = c2;
            scanbotCameraView2.notifyTakePictureCancelled();
            if (!scanbotCameraView2.resumed) {
                return;
            }
        }
        if (var1_1 != false) {
            this.state = c.b;
            this.autoFocus();
        } else {
            this.performSnapping();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void useFlash(boolean useFlash) {
        ScanbotCameraView scanbotCameraView = this_;
        scanbotCameraView.logger.logMethod();
        if (!scanbotCameraView.resumed) {
            return;
        }
        if (Utils.isFlashSupported(this_.cameraView.getCameraParameters())) {
            void var1_1;
            Object this_ = this_.cameraView;
            String string = var1_1 != false ? "torch" : "off";
            this_.setFlashMode(string);
        }
    }

    public void setAutoFocusOnTouch(boolean autoFocusOnTouch) {
        this.cameraView.a(autoFocusOnTouch);
    }

    public void autoFocus() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        if (!scanbotCameraView.resumed) {
            return;
        }
        this.cameraView.autoFocus();
    }

    public void continuousFocus() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        if (!scanbotCameraView.resumed) {
            return;
        }
        this.cameraView.a();
    }

    public void addPictureCallback(PictureCallback pictureCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.a(pictureCallback);
    }

    public void removePictureCallback(PictureCallback pictureCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.b(pictureCallback);
    }

    void addCameraStateCallback(CameraStateCallback cameraStateCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.stateCallbacks.add(cameraStateCallback);
    }

    void removeCameraStateCallback(CameraStateCallback cameraStateCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.stateCallbacks.remove(cameraStateCallback);
    }

    void addTakePictureCallback(CameraTakePictureCallback cameraTakePictureCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.takePictureCallbacks.add(cameraTakePictureCallback);
    }

    void removeTakePictureCallback(CameraTakePictureCallback cameraTakePictureCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.takePictureCallbacks.remove(cameraTakePictureCallback);
    }

    public void setCameraOpenCallback(CameraOpenCallback cameraOpenCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.a(cameraOpenCallback);
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        ScanbotCameraView scanbotCameraView = this_;
        scanbotCameraView.logger.logMethod();
        ScanbotCameraView this_ = scanbotCameraView.cameraView.getCameraParameters();
        if (this_ != null) {
            return this_.getSupportedPictureSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        ScanbotCameraView scanbotCameraView = this_;
        scanbotCameraView.logger.logMethod();
        ScanbotCameraView this_ = scanbotCameraView.cameraView.getCameraParameters();
        if (this_ != null) {
            return this_.getSupportedPreviewSizes();
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - void declaration
     */
    public void setPictureSize(Camera.Size pictureSize) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraHost.a(pictureSize);
        Camera.Parameters parameters = scanbotCameraView.cameraView.getCameraParameters();
        if (parameters != null) {
            void var1_1;
            parameters.setPictureSize(var1_1.width, var1_1.height);
            this.cameraView.setCameraParameters(parameters);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewSize(Camera.Size previewSize) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraHost.b(previewSize);
        Camera.Parameters parameters = scanbotCameraView.cameraView.getCameraParameters();
        if (parameters != null) {
            void var1_1;
            parameters.setPreviewSize(var1_1.width, var1_1.height);
            this.cameraView.setCameraParameters(parameters);
        }
    }

    public void setAutoFocusSound(boolean enabled) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraHost.a(enabled);
    }

    @RequiresApi(api=17)
    public void setShutterSound(boolean enabled) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraHost.b(enabled);
        scanbotCameraView.cameraView.b(enabled);
    }

    public void setPreviewMode(CameraPreviewMode mode) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraHost.a(mode);
    }

    @Deprecated
    public void lockToPortrait() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.lockToPortrait();
    }

    @Deprecated
    public void lockToLandscape() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.lockToLandscape();
    }

    public void lockToPortrait(boolean lockPicture) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.lockToPortrait(lockPicture);
    }

    public void lockToLandscape(boolean lockPicture) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.lockToLandscape(lockPicture);
    }

    public void unlockOrientation() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.unlockOrientation();
    }

    private static enum c {
        a,
        b,
        c;

    }

    private class b
    implements CameraView.AutofocusCallback {
        private b() {
        }

        @Override
        public void onAutoFocusCompleted() {
            b b2 = this;
            b2.ScanbotCameraView.this.logger.logMethod();
            b2.ScanbotCameraView.this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ScanbotCameraView.this.state == c.b) {
                        ScanbotCameraView.this.performSnapping();
                    } else {
                        a a2 = this;
                        ScanbotCameraView.access$202(a2.ScanbotCameraView.this, c.a);
                        a2.ScanbotCameraView.this.notifyTakePictureCancelled();
                    }
                }
            }, 500L);
        }
    }
}

