/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import android.graphics.Point;
import android.graphics.PointF;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.PDFPageSize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.doo.snap.entity.RotationType;

public class Page
implements Parcelable {
    public static final String FILTERED_FOLDER = "filtered";
    public static Parcelable.Creator<Page> CREATOR = new Parcelable.Creator<Page>(){

        public Page createFromParcel(Parcel source) {
            return new Page(source);
        }

        public Page[] newArray(int size) {
            return new Page[size];
        }
    };
    private final String id;
    private final Bundle parameters;
    private ImageFilterType imageFilterType;
    private RotationType rotationType;
    private List<PointF> polygon;
    private SparseArray<Point> imageSizes;
    private boolean processed;
    private PDFPageSize pageSize;

    public Page() {
        this.imageFilterType = ImageFilterType.NONE;
        this.rotationType = RotationType.ROTATION_0;
        this.polygon = new ArrayList<PointF>(this){
            final /* synthetic */ Page a;
            {
                a a2 = this;
                a2.a = this$0;
                a2.add(new PointF(0.0f, 0.0f));
                a2.add(new PointF(1.0f, 0.0f));
                a2.add(new PointF(1.0f, 1.0f));
                a2.add(new PointF(0.0f, 1.0f));
            }
        };
        this.imageSizes = new SparseArray();
        this.processed = false;
        this.pageSize = PDFPageSize.FROM_IMAGE;
        this.id = UUID.randomUUID().toString();
        this.parameters = new Bundle();
    }

    public Page(String id2) {
        Page page = this;
        this.imageFilterType = ImageFilterType.NONE;
        this.rotationType = RotationType.ROTATION_0;
        this.polygon = new /* invalid duplicate definition of identical inner class */;
        this.imageSizes = new SparseArray();
        this.processed = false;
        this.pageSize = PDFPageSize.FROM_IMAGE;
        page.id = id2;
        page.parameters = new Bundle();
    }

    /*
     * WARNING - void declaration
     */
    private Page(Parcel in) {
        void var1_1;
        this.imageFilterType = ImageFilterType.NONE;
        this.rotationType = RotationType.ROTATION_0;
        this.polygon = new /* invalid duplicate definition of identical inner class */;
        this.imageSizes = new SparseArray();
        this.processed = false;
        this.pageSize = PDFPageSize.FROM_IMAGE;
        this.id = in.readString();
        this.parameters = in.readBundle();
        int n2 = in.readInt();
        ImageFilterType imageFilterType = n2 == -1 ? null : ImageFilterType.values()[n2];
        this.imageFilterType = imageFilterType;
        int n3 = var1_1.readInt();
        RotationType rotationType = n3 == -1 ? null : RotationType.values()[n3];
        void v0 = var1_1;
        this.rotationType = rotationType;
        v0.readTypedList(this.polygon, PointF.CREATOR);
        this.imageSizes = v0.readSparseArray(SparseArray.class.getClassLoader());
    }

    public String getId() {
        return this.id;
    }

    public ImageFilterType getImageFilterType() {
        return this.imageFilterType;
    }

    public void setImageFilterType(ImageFilterType imageFilterType) {
        this.imageFilterType = imageFilterType;
    }

    public RotationType getRotationType() {
        return this.rotationType;
    }

    public void setRotationType(RotationType rotationType) {
        this.rotationType = rotationType;
    }

    public List<PointF> getPolygon() {
        List<PointF> this_ = ((Page)((Object)this_)).polygon;
        if (this_ == null) {
            return Collections.emptyList();
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    public void setPolygon(List<PointF> polygon) {
        void var1_1;
        if (polygon != null && var1_1.size() == 4) {
            this.polygon = var1_1;
            return;
        }
    }

    public void setImageSize(ImageType imageType, int width, int height) {
        this.imageSizes.put(imageType.ordinal(), (Object)new Point(width, height));
    }

    public Point getImageSize(ImageType imageType) {
        return (Point)this.imageSizes.get(imageType.ordinal());
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public Bundle getParameters() {
        return this.parameters;
    }

    public void setPageSize(PDFPageSize pageSize) {
        this.pageSize = pageSize;
    }

    public PDFPageSize getPageSize() {
        return this.pageSize;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o2) {
        void var1_1;
        if (this_ == o2) {
            return true;
        }
        if (!(var1_1 instanceof Page)) {
            return false;
        }
        Page page = this_;
        Page this_ = (Page)var1_1;
        return page.id.equals(this_.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(Parcel dest, int flags2) {
        void var1_1;
        void var2_3;
        dest.writeString(this.id);
        dest.writeBundle(this.parameters);
        ImageFilterType flags2 = this.imageFilterType;
        int n2 = flags2 == null ? -1 : var2_3.ordinal();
        var1_1.writeInt(n2);
        RotationType rotationType = this.rotationType;
        int n3 = rotationType == null ? -1 : rotationType.ordinal();
        var1_1.writeInt(n3);
        var1_1.writeTypedList(this.polygon);
        var1_1.writeSparseArray(this.imageSizes);
    }

    public static enum ImageType {
        ORIGINAL("original"),
        PREVIEW("preview"),
        OPTIMIZED_PREVIEW("optimized_preview"),
        OPTIMIZED("optimized"),
        OVERLAY("overlay"),
        OVERLAY_TMP("overlay_tmp");

        private String fileName;

        private ImageType(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

