/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.blob;

import android.content.res.AssetManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import net.doo.snap.b.a;
import net.doo.snap.entity.Blob;
import net.doo.snap.persistence.BlobStoreStrategy;
import org.jetbrains.annotations.NotNull;

public class BlobFactory {
    private static final String PDF_FONT = "pdf.ttf";
    private static final String BANKS_DATA_FILENAME = "banks.csv";
    private static final String MRZ_TRAINEDDATA_FILENAME = "ocrb.traineddata";
    private static final String MRZ_CASCADE_FILENAME = "mrz.xml";
    private static final String BARCODE_SCANNER_MODEL_FILENAME = "barcode_detector.tflite";
    private static final String FILTER_PREDICTION_MODEL_FILENAME = "FilterPrediction.tflite";
    private static final String CHEQUE_DIGIT_RECOGNITION_MODEL_FILENAME = "ChequeDigitRecognizerModel.tflite";
    private final BlobStoreStrategy blobStoreStrategy;
    private final a blobsStorage;
    private final AssetManager assetManager;

    @Inject
    public BlobFactory(BlobStoreStrategy blobStoreStrategy, a blobsStorage, AssetManager assetManager) {
        this.blobStoreStrategy = blobStoreStrategy;
        this.blobsStorage = blobsStorage;
        this.assetManager = assetManager;
    }

    @NotNull
    public Collection<Blob> ocrLanguageBlobs() throws IOException {
        HashSet hashSet;
        BlobFactory blobFactory = this_;
        HashSet this_ = hashSet;
        hashSet = new HashSet();
        File file = blobFactory.blobStoreStrategy.getOCRDataDirectory();
        String string = blobFactory.blobsStorage.a().toString();
        String[] stringArray = blobFactory.assetManager.list(string);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                File file2;
                File file3 = file2;
                file2 = new File(string, string2);
                this_.add(new Blob(new File(file, file3.getName()).getPath(), file3.getPath()));
            }
        }
        HashSet hashSet2 = this_;
        hashSet2.add(new Blob(new File(file, PDF_FONT).getPath(), PDF_FONT));
        return hashSet2;
    }

    @NotNull
    public Blob bankDataBlob() throws IOException {
        File this_ = ((BlobFactory)((Object)this_)).blobStoreStrategy.getBanksDataFile();
        return new Blob(this_.getPath(), BANKS_DATA_FILENAME);
    }

    @NotNull
    public Blob mrzTraineddataBlob() throws IOException {
        File this_ = ((BlobFactory)((Object)this_)).blobStoreStrategy.getMRZTraindataFile();
        return new Blob(this_.getPath(), MRZ_TRAINEDDATA_FILENAME);
    }

    @NotNull
    public Blob mrzCascadeBlob() throws IOException {
        File this_ = ((BlobFactory)((Object)this_)).blobStoreStrategy.getMRZCascadeFile();
        return new Blob(this_.getPath(), MRZ_CASCADE_FILENAME);
    }

    @NotNull
    public Blob chequeDigitRecognitionModelBlob() throws IOException {
        File this_ = ((BlobFactory)((Object)this_)).blobStoreStrategy.getChequeDigitRecognitionModelFile();
        return new Blob(this_.getPath(), CHEQUE_DIGIT_RECOGNITION_MODEL_FILENAME);
    }

    @NotNull
    public Blob barcodeScannerModelBlob() throws IOException {
        File this_ = ((BlobFactory)((Object)this_)).blobStoreStrategy.getBarcodeScannerModelFile();
        return new Blob(this_.getPath(), BARCODE_SCANNER_MODEL_FILENAME);
    }

    @NotNull
    public Blob filterPredictionModelBlob() throws IOException {
        File this_ = ((BlobFactory)((Object)this_)).blobStoreStrategy.getFilterPredictionModelFile();
        return new Blob(this_.getPath(), FILTER_PREDICTION_MODEL_FILENAME);
    }
}

