/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.hicscanner;

import android.graphics.Bitmap;
import android.graphics.Rect;
import io.scanbot.hicscanner.HICRecognizer;
import io.scanbot.hicscanner.model.HealthInsuranceCardRecognitionResult;
import io.scanbot.sdk.hicscanner.HealthInsuranceCardScanner;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.blob.BlobManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\fH\u0016J*\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J2\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J*\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\fH\u0016J*\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J2\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/scanbot/sdk/hicscanner/DefaultHealthInsuranceCardScanner;", "Lio/scanbot/sdk/hicscanner/HealthInsuranceCardScanner;", "blobManager", "Lnet/doo/snap/blob/BlobManager;", "(Lnet/doo/snap/blob/BlobManager;)V", "hicRecognizer", "Lio/scanbot/hicscanner/HICRecognizer;", "detectAndRecognize", "Lio/scanbot/hicscanner/model/HealthInsuranceCardRecognitionResult;", "image", "", "width", "", "height", "orientation", "detectAndRecognizeBitmap", "Landroid/graphics/Bitmap;", "detectAndRecognizeJPEG", "detectAndRecognizeWithFinderOverlay", "finderRect", "Landroid/graphics/Rect;", "recognize", "recognizeBitmap", "recognizeJPEG", "recognizeWithFinderOverlay", "scanbot-sdk_release"})
public final class DefaultHealthInsuranceCardScanner
implements HealthInsuranceCardScanner {
    private final HICRecognizer hicRecognizer;

    @Inject
    public DefaultHealthInsuranceCardScanner(@NotNull BlobManager blobManager) {
        DefaultHealthInsuranceCardScanner defaultHealthInsuranceCardScanner = this_;
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        try {
            File file = blobManager.getOCRBlobsDirectory();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.ocrBlobsDirectory");
            String this_ = file.getPath();
        }
        catch (IOException iOException) {
            throw new RuntimeException("HIC scanner OCR blob is not available.");
        }
        defaultHealthInsuranceCardScanner.hicRecognizer = new HICRecognizer(this_);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult recognize(@NotNull byte[] image, int width, int height, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        return this.hicRecognizer.recognizeFromNV21(image, width, height, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult recognizeWithFinderOverlay(@NotNull byte[] image, int width, int height, int orientation, @NotNull Rect finderRect) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)finderRect, (String)"finderRect");
        return this.hicRecognizer.recognizeInAreaFromNV21(image, width, height, finderRect, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult recognizeJPEG(@NotNull byte[] image, int width, int height, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        return this.hicRecognizer.recognizeFromJPEG(image, width, height, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult recognizeBitmap(@NotNull Bitmap image, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        return this.hicRecognizer.recognizeFromBitmap(image, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult detectAndRecognize(@NotNull byte[] image, int width, int height, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        return this.hicRecognizer.detectAndRecognizeFromNV21(image, width, height, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult detectAndRecognizeWithFinderOverlay(@NotNull byte[] image, int width, int height, int orientation, @NotNull Rect finderRect) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)finderRect, (String)"finderRect");
        return this.hicRecognizer.detectAndRecognizeInAreaFromNV21(image, width, height, finderRect, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult detectAndRecognizeJPEG(@NotNull byte[] image, int width, int height, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        return this.hicRecognizer.detectAndRecognizeFromJPEG(image, width, height, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult detectAndRecognizeBitmap(@NotNull Bitmap image, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        return this.hicRecognizer.detectAndRecognizeFromBitmap(image, orientation);
    }
}

