/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.sdk.persistence.PageFileStorage$WhenMappings;
import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.process.ImageFilterType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001'B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eJ\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\bJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0014\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u001cJ\u000e\u0010#\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\bJ\u001e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010&\u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010&\u001a\u00020!2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/scanbot/sdk/persistence/PageFileStorage;", "", "pageStorageProcessor", "Lio/scanbot/sdk/persistence/PageStorageProcessor;", "pageStorage", "Lio/scanbot/sdk/persistence/PageStorage;", "(Lio/scanbot/sdk/persistence/PageStorageProcessor;Lio/scanbot/sdk/persistence/PageStorage;)V", "add", "", "image", "Landroid/graphics/Bitmap;", "configuration", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "add$sdk_bundle_release", "", "generateAndSetFilteredPreviewForId", "filteredImage", "existingPageId", "filter", "Lio/scanbot/sdk/process/ImageFilterType;", "getFilteredPreviewImageURI", "Landroid/net/Uri;", "pageId", "getImageURI", "type", "Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "getPreviewImageURI", "getStoredPages", "", "remove", "", "removeAll", "removeAllExcept", "", "pageIds", "removeFilteredPreviewImages", "setFilteredPreviewForId", "filteredPreview", "setImageForId", "PageFileType", "sdk-bundle_release"})
public final class PageFileStorage {
    private final PageStorageProcessor pageStorageProcessor;
    private final PageStorage pageStorage;

    @Inject
    public PageFileStorage(@NotNull PageStorageProcessor pageStorageProcessor, @NotNull PageStorage pageStorage) {
        Intrinsics.checkParameterIsNotNull((Object)pageStorageProcessor, (String)"pageStorageProcessor");
        Intrinsics.checkParameterIsNotNull((Object)pageStorage, (String)"pageStorage");
        this.pageStorageProcessor = pageStorageProcessor;
        this.pageStorage = pageStorage;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Uri getImageURI(@NotNull String pageId, @NotNull PageFileType type) {
        PageFileStorage pageFileStorage;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        int n2 = PageFileStorage$WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) throw new NoWhenBranchMatchedException();
                pageFileStorage = Uri.fromFile((File)pageFileStorage.pageStorage.getUnfilteredDocumentImage((String)var1_1));
                Intrinsics.checkExpressionValueIsNotNull((Object)pageFileStorage, (String)"Uri.fromFile(pageStorage\u2026redDocumentImage(pageId))");
                return pageFileStorage;
            } else {
                pageFileStorage = Uri.fromFile((File)pageFileStorage.pageStorage.getDocumentImage((String)var1_1));
                Intrinsics.checkExpressionValueIsNotNull((Object)pageFileStorage, (String)"Uri.fromFile(pageStorage.getDocumentImage(pageId))");
            }
            return pageFileStorage;
        } else {
            pageFileStorage = Uri.fromFile((File)pageFileStorage.pageStorage.getOriginalImage((String)var1_1));
            Intrinsics.checkExpressionValueIsNotNull((Object)pageFileStorage, (String)"Uri.fromFile(pageStorage.getOriginalImage(pageId))");
        }
        return pageFileStorage;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Uri getPreviewImageURI(@NotNull String pageId, @NotNull PageFileType type) {
        PageFileStorage pageFileStorage;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        int n2 = PageFileStorage$WhenMappings.$EnumSwitchMapping$1[type.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) throw new NoWhenBranchMatchedException();
                pageFileStorage = Uri.fromFile((File)pageFileStorage.pageStorage.getUnfilteredDocumentImagePreview((String)var1_1));
                Intrinsics.checkExpressionValueIsNotNull((Object)pageFileStorage, (String)"Uri.fromFile(pageStorage\u2026mentImagePreview(pageId))");
                return pageFileStorage;
            } else {
                pageFileStorage = Uri.fromFile((File)pageFileStorage.pageStorage.getDocumentImagePreview((String)var1_1));
                Intrinsics.checkExpressionValueIsNotNull((Object)pageFileStorage, (String)"Uri.fromFile(pageStorage\u2026mentImagePreview(pageId))");
            }
            return pageFileStorage;
        } else {
            pageFileStorage = Uri.fromFile((File)pageFileStorage.pageStorage.getOriginalImagePreview((String)var1_1));
            Intrinsics.checkExpressionValueIsNotNull((Object)pageFileStorage, (String)"Uri.fromFile(pageStorage\u2026inalImagePreview(pageId))");
        }
        return pageFileStorage;
    }

    @NotNull
    public final Uri getFilteredPreviewImageURI(@NotNull String pageId, @NotNull ImageFilterType filter) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Uri uri = Uri.fromFile((File)this.pageStorage.getFilteredImagePreview(pageId, filter));
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(pageStorage\u2026ePreview(pageId, filter))");
        return uri;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeFilteredPreviewImages(@NotNull String pageId) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        for (ImageFilterType imageFilterType : ImageFilterType.values()) {
            void var1_1;
            File object = this.pageStorage.getFilteredImagePreview((String)var1_1, imageFilterType);
            if (!object.exists()) continue;
            object.delete();
        }
    }

    @NotNull
    public final String add(@NotNull byte[] image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        return this.add$sdk_bundle_release(image, PageStorageProcessor.Configuration.Companion.DEFAULT());
    }

    @NotNull
    public final String add(@NotNull Bitmap image) {
        Bitmap bitmap = image;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"image");
        return this.add$sdk_bundle_release(bitmap, PageStorageProcessor.Configuration.Companion.DEFAULT());
    }

    @NotNull
    public final String add$sdk_bundle_release(@NotNull byte[] image, @NotNull PageStorageProcessor.Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        return this.pageStorageProcessor.createPage$sdk_bundle_release(image, configuration).getPageId();
    }

    @NotNull
    public final String add$sdk_bundle_release(@NotNull Bitmap image, @NotNull PageStorageProcessor.Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        return this.pageStorageProcessor.createPage$sdk_bundle_release(image, configuration).getPageId();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setImageForId(@NotNull byte[] image, @NotNull String existingPageId, @NotNull PageFileType type) {
        void var1_1;
        void var3_3;
        File file;
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        int n2 = PageFileStorage$WhenMappings.$EnumSwitchMapping$2[type.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) throw new NoWhenBranchMatchedException();
                file = this.pageStorage.getUnfilteredDocumentImage((String)((Object)file2));
            } else {
                file = this.pageStorage.getDocumentImage((String)((Object)file2));
            }
        } else {
            file = this.pageStorage.getOriginalImage((String)((Object)file2));
        }
        int n3 = PageFileStorage$WhenMappings.$EnumSwitchMapping$3[var3_3.ordinal()];
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 != 3) throw new NoWhenBranchMatchedException();
                file2 = this.pageStorage.getUnfilteredDocumentImagePreview((String)((Object)file2));
            } else {
                file2 = this.pageStorage.getDocumentImagePreview((String)((Object)file2));
            }
        } else {
            file2 = this.pageStorage.getOriginalImagePreview((String)((Object)file2));
        }
        PageFileStorage pageFileStorage = this;
        pageFileStorage.pageStorageProcessor.saveBitmapTo(file, (byte[])var1_1);
        pageFileStorage.pageStorageProcessor.createPreviewTo(file2, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setImageForId(@NotNull Bitmap image, @NotNull String existingPageId, @NotNull PageFileType type) {
        void var1_1;
        void var3_3;
        File file;
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        int n2 = PageFileStorage$WhenMappings.$EnumSwitchMapping$4[type.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) throw new NoWhenBranchMatchedException();
                file = this.pageStorage.getUnfilteredDocumentImage((String)((Object)file2));
            } else {
                file = this.pageStorage.getDocumentImage((String)((Object)file2));
            }
        } else {
            file = this.pageStorage.getOriginalImage((String)((Object)file2));
        }
        int n3 = PageFileStorage$WhenMappings.$EnumSwitchMapping$5[var3_3.ordinal()];
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 != 3) throw new NoWhenBranchMatchedException();
                file2 = this.pageStorage.getUnfilteredDocumentImagePreview((String)((Object)file2));
            } else {
                file2 = this.pageStorage.getDocumentImagePreview((String)((Object)file2));
            }
        } else {
            file2 = this.pageStorage.getOriginalImagePreview((String)((Object)file2));
        }
        PageFileStorage pageFileStorage = this;
        pageFileStorage.pageStorageProcessor.saveBitmapTo(file, (Bitmap)var1_1);
        pageFileStorage.pageStorageProcessor.createPreviewTo(file2, (Bitmap)var1_1);
    }

    public final void setFilteredPreviewForId(@NotNull byte[] filteredPreview, @NotNull String existingPageId, @NotNull ImageFilterType filter) {
        PageFileStorage pageFileStorage = this_;
        Intrinsics.checkParameterIsNotNull((Object)filteredPreview, (String)"filteredPreview");
        Intrinsics.checkParameterIsNotNull((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        File this_ = pageFileStorage.pageStorage.getFilteredImagePreview(existingPageId, filter);
        pageFileStorage.pageStorageProcessor.saveBitmapTo(this_, filteredPreview);
    }

    public final void setFilteredPreviewForId(@NotNull Bitmap filteredPreview, @NotNull String existingPageId, @NotNull ImageFilterType filter) {
        PageFileStorage pageFileStorage = this_;
        Intrinsics.checkParameterIsNotNull((Object)filteredPreview, (String)"filteredPreview");
        Intrinsics.checkParameterIsNotNull((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        File this_ = pageFileStorage.pageStorage.getFilteredImagePreview(existingPageId, filter);
        pageFileStorage.pageStorageProcessor.saveBitmapTo(this_, filteredPreview);
    }

    @NotNull
    public final Bitmap generateAndSetFilteredPreviewForId(@NotNull byte[] filteredImage, @NotNull String existingPageId, @NotNull ImageFilterType filter) {
        PageFileStorage pageFileStorage = this_;
        Intrinsics.checkParameterIsNotNull((Object)filteredImage, (String)"filteredImage");
        Intrinsics.checkParameterIsNotNull((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        File this_ = pageFileStorage.pageStorage.getFilteredImagePreview(existingPageId, filter);
        return pageFileStorage.pageStorageProcessor.createPreviewTo(this_, filteredImage);
    }

    @NotNull
    public final Bitmap generateAndSetFilteredPreviewForId(@NotNull Bitmap filteredImage, @NotNull String existingPageId, @NotNull ImageFilterType filter) {
        PageFileStorage pageFileStorage = this_;
        Intrinsics.checkParameterIsNotNull((Object)filteredImage, (String)"filteredImage");
        Intrinsics.checkParameterIsNotNull((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        File this_ = pageFileStorage.pageStorage.getFilteredImagePreview(existingPageId, filter);
        return pageFileStorage.pageStorageProcessor.createPreviewTo(this_, filteredImage);
    }

    public final boolean remove(@NotNull String pageId) {
        Intrinsics.checkParameterIsNotNull((Object)pageId, (String)"pageId");
        return FilesKt.deleteRecursively((File)this.pageStorage.getPageDir(pageId));
    }

    public final boolean removeAll() {
        return FilesKt.deleteRecursively((File)this.pageStorage.getPagesDirectory());
    }

    @NotNull
    public final List<String> getStoredPages() throws IOException {
        return this.pageStorage.getStoredPages();
    }

    /*
     * WARNING - void declaration
     */
    public final void removeAllExcept(@NotNull List<String> pageIds) {
        ArrayList arrayList;
        PageFileStorage pageFileStorage = this_;
        Intrinsics.checkParameterIsNotNull(pageIds, (String)"pageIds");
        Iterator<File> this_ = arrayList;
        arrayList = new ArrayList();
        for (File file : pageFileStorage.pageStorage.getPagesDirectory().listFiles()) {
            void var1_1;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"listFile");
            if (var1_1.contains(file.getName())) continue;
            this_.add(file);
        }
        this_ = this_.iterator();
        while (this_.hasNext()) {
            ((File)this_.next()).delete();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "", "(Ljava/lang/String;I)V", "ORIGINAL", "DOCUMENT", "UNFILTERED_DOCUMENT", "sdk-bundle_release"})
    public static final class PageFileType
    extends Enum<PageFileType> {
        public static final /* enum */ PageFileType ORIGINAL;
        public static final /* enum */ PageFileType DOCUMENT;
        public static final /* enum */ PageFileType UNFILTERED_DOCUMENT;
        private static final /* synthetic */ PageFileType[] $VALUES;

        static {
            PageFileType pageFileType;
            PageFileType pageFileType2;
            PageFileType pageFileType3;
            PageFileType[] pageFileTypeArray = new PageFileType[3];
            PageFileType pageFileType4 = pageFileType3;
            ORIGINAL = new PageFileType();
            pageFileTypeArray[0] = pageFileType4;
            pageFileType4 = pageFileType2;
            DOCUMENT = new PageFileType();
            pageFileTypeArray[1] = pageFileType4;
            pageFileType4 = pageFileType;
            UNFILTERED_DOCUMENT = new PageFileType();
            pageFileTypeArray[2] = pageFileType4;
            $VALUES = pageFileTypeArray;
        }

        public static PageFileType[] values() {
            return (PageFileType[])$VALUES.clone();
        }

        public static PageFileType valueOf(String string) {
            return Enum.valueOf(PageFileType.class, string);
        }
    }
}

