/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.net.Uri;
import android.provider.MediaStore;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.CropOperation;
import io.scanbot.sdk.process.FilterOperation;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.process.Operation;
import io.scanbot.sdk.process.RotateOperation;
import io.scanbot.sdk.process.TuneOperation;
import io.scanbot.sdk.utils.PolygonHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.bitmap.BitmapUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ,\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J$\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eJ:\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u001c\u001a\u00020\u0011H\u0002J\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ,\u0010\u001e\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J2\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0016\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0011J0\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001aH\u0002J\u0018\u0010+\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/scanbot/sdk/process/PageProcessor;", "", "context", "Landroid/content/Context;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "(Landroid/content/Context;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "applyFilter", "Lio/scanbot/sdk/persistence/Page;", "page", "filter", "Lio/scanbot/sdk/process/ImageFilterType;", "applyFilterTunes", "tunes", "", "Lio/scanbot/sdk/process/TuneOperation;", "filterOrder", "", "calculateRotationDegree", "times", "cropAndRotate", "polygon", "Landroid/graphics/PointF;", "cropApplyFiltersTunesFromPage", "Landroid/graphics/Bitmap;", "processor", "Lio/scanbot/sdk/process/ImageProcessor;", "originalBitmap", "degrees", "detectDocument", "generateFilteredPreview", "getOperationsForFilterAndTunes", "Lio/scanbot/sdk/process/Operation;", "rotate", "rotateAndSavePageImage", "", "bitmap", "rotationDegree", "pageId", "", "pageType", "Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "imageProcessor", "scaleBitmapIfNeeded", "imageSizeLimit", "Lio/scanbot/sdk/persistence/Page$Size;", "sdk-bundle_release"})
public final class PageProcessor {
    private Context context;
    private final PageFileStorage pageFileStorage;

    /*
     * WARNING - void declaration
     */
    private final Bitmap cropApplyFiltersTunesFromPage(ImageProcessor processor, Bitmap originalBitmap, List<? extends PointF> polygon, Page page, int degrees) {
        void var2_2;
        void var1_1;
        void var3_3;
        polygon = CollectionsKt.toMutableList((Collection)CollectionsKt.listOf((Object)new CropOperation(polygon)));
        polygon.addAll(this.getOperationsForFilterAndTunes(page.getFilterOrder(), page.getFilter(), page.getTunes()));
        if (degrees != 0) {
            void var5_5;
            var3_3.add(new RotateOperation((int)var5_5));
        }
        return ImageProcessor.process$default((ImageProcessor)var1_1, (Bitmap)var2_2, (List)var3_3, false, 4, null);
    }

    static /* synthetic */ Bitmap cropApplyFiltersTunesFromPage$default(PageProcessor pageProcessor, ImageProcessor imageProcessor, Bitmap bitmap, List list, Page page, int n2, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        return pageProcessor.cropApplyFiltersTunesFromPage(imageProcessor, bitmap, list, page, n2);
    }

    private final List<Operation> getOperationsForFilterAndTunes(int filterOrder, ImageFilterType filter, List<TuneOperation> tunes) {
        ArrayList arrayList;
        ArrayList<FilterOperation> this_ = arrayList;
        List<TuneOperation> list = tunes;
        ArrayList<FilterOperation> arrayList2 = this_;
        this_();
        arrayList2.addAll(CollectionsKt.take(tunes, (int)filterOrder));
        arrayList2.add(new FilterOperation(filter));
        arrayList.addAll(CollectionsKt.takeLast(list, (int)(list.size() - filterOrder)));
        return arrayList;
    }

    static /* synthetic */ List getOperationsForFilterAndTunes$default(PageProcessor pageProcessor, int n2, ImageFilterType imageFilterType, List list, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 0;
        }
        if ((n3 & 2) != 0) {
            imageFilterType = ImageFilterType.NONE;
        }
        if ((n3 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return pageProcessor.getOperationsForFilterAndTunes(n2, imageFilterType, list);
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateRotationDegree(int times) {
        void var0_1;
        int n2 = times * -1 * 90;
        return n2 < 0 ? 360 - Math.abs((int)var0_1) % 360 : var0_1 % 360;
    }

    /*
     * WARNING - void declaration
     */
    private final void rotateAndSavePageImage(Bitmap bitmap, int rotationDegree, String pageId, PageFileStorage.PageFileType pageType, ImageProcessor imageProcessor) {
        if ((bitmap = ImageProcessor.process$default(imageProcessor, bitmap, CollectionsKt.listOf((Object)new RotateOperation(rotationDegree)), false, 4, null)) != null) {
            void var4_4;
            void var3_3;
            void var1_1;
            this.pageFileStorage.setImageForId((Bitmap)var1_1, (String)var3_3, (PageFileStorage.PageFileType)var4_4);
            var1_1.recycle();
            return;
        }
        throw new IOException("Unable to filter");
    }

    /*
     * WARNING - void declaration
     */
    private final Bitmap scaleBitmapIfNeeded(Bitmap bitmap, Page.Size imageSizeLimit) {
        Bitmap bitmap2;
        void var2_2;
        if (imageSizeLimit.getHeight() != Integer.MAX_VALUE && var2_2.getWidth() != Integer.MAX_VALUE) {
            bitmap2 = BitmapUtils.scaleIfNeeded(bitmap2, var2_2.getWidth(), var2_2.getHeight());
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"BitmapUtils.scaleIfNeede\u2026h, imageSizeLimit.height)");
        }
        return bitmap2;
    }

    @Inject
    public PageProcessor(@NotNull Context context, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        this.context = context;
        this.pageFileStorage = pageFileStorage;
    }

    @NotNull
    public final Page applyFilter(@NotNull Page page, @NotNull ImageFilterType filter) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        return this.applyFilterTunes(page, filter, page.getTunes(), page.getFilterOrder());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page applyFilterTunes(@NotNull Page page, @NotNull ImageFilterType filter, @NotNull List<TuneOperation> tunes, int filterOrder) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Intrinsics.checkParameterIsNotNull(tunes, (String)"tunes");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (new File(uri.getPath()).exists()) {
            Bitmap bitmap;
            void var2_2;
            void var4_4;
            ImageProcessor imageProcessor;
            uri = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
            ImageProcessor imageProcessor2 = imageProcessor;
            imageProcessor2();
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"unfilteredDocumentBitmap");
            bitmap = ImageProcessor.process$default(imageProcessor, (Bitmap)uri, this.getOperationsForFilterAndTunes((int)var4_4, (ImageFilterType)var2_2, (List<TuneOperation>)bitmap), false, 4, null);
            if (bitmap != null) {
                void var1_1;
                imageProcessor2.dispose();
                this.pageFileStorage.setImageForId(bitmap, var1_1.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
                return Page.copy$default((Page)var1_1, null, null, null, (ImageFilterType)var2_2, null, null, 0, 119, null);
            }
            throw new IOException("Unable to filter");
        }
        throw new IOException("Unfiltered document image does not exists for this page.");
    }

    @NotNull
    public final Bitmap generateFilteredPreview(@NotNull Page page, @NotNull ImageFilterType filter) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        return this.generateFilteredPreview(page, filter, page.getTunes(), page.getFilterOrder());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap generateFilteredPreview(@NotNull Page page, @NotNull ImageFilterType filter, @NotNull List<TuneOperation> tunes, int filterOrder) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Intrinsics.checkParameterIsNotNull(tunes, (String)"tunes");
        Uri uri = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (new File(uri.getPath()).exists()) {
            Bitmap bitmap;
            void var2_2;
            void var4_4;
            ImageProcessor imageProcessor;
            uri = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)uri);
            ImageProcessor imageProcessor2 = imageProcessor;
            imageProcessor2();
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"unfilteredDocumentBitmap");
            bitmap = ImageProcessor.process$default(imageProcessor, (Bitmap)uri, this.getOperationsForFilterAndTunes((int)var4_4, (ImageFilterType)var2_2, (List<TuneOperation>)bitmap), false, 4, null);
            if (bitmap != null) {
                void var1_1;
                imageProcessor2.dispose();
                return this.pageFileStorage.generateAndSetFilteredPreviewForId(bitmap, var1_1.getPageId(), (ImageFilterType)var2_2);
            }
            throw new IOException("Unable to filter");
        }
        throw new IOException("Unfiltered document image does not exists for this page.");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page detectDocument(@NotNull Page page) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Uri uri = ((PageProcessor)((Object)this_)).pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (new File(uri.getPath()).exists()) {
            void var1_1;
            ImageProcessor imageProcessor;
            ContourDetector contourDetector;
            uri = MediaStore.Images.Media.getBitmap((ContentResolver)((PageProcessor)((Object)this_)).context.getContentResolver(), (Uri)uri);
            ContourDetector contourDetector2 = contourDetector;
            contourDetector2();
            ImageProcessor imageProcessor2 = imageProcessor;
            imageProcessor = new ImageProcessor();
            DetectionResult detectionResult = contourDetector.detect((Bitmap)uri);
            if (detectionResult != null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"originalBitmap");
                List list = contourDetector2.getPolygonF();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"detector.polygonF");
                Bitmap bitmap = PageProcessor.cropApplyFiltersTunesFromPage$default((PageProcessor)((Object)this_), imageProcessor2, (Bitmap)uri, list, (Page)var1_1, 0, 16, null);
                Bitmap bitmap2 = var1_1.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && var1_1.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE ? BitmapUtils.scaleIfNeeded(bitmap, var1_1.getDocumentImageSizeLimit().getWidth(), var1_1.getDocumentImageSizeLimit().getHeight()) : bitmap;
                if (bitmap2 != null) {
                    Bitmap bitmap3;
                    if (var1_1.getFilter() != ImageFilterType.NONE) {
                        List list2 = contourDetector2.getPolygonF();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"detector.polygonF");
                        bitmap3 = ImageProcessor.process$default(imageProcessor2, (Bitmap)uri, CollectionsKt.listOf((Object)new CropOperation(list2)), false, 4, null);
                    } else {
                        bitmap3 = bitmap2;
                    }
                    if (bitmap3 != null) {
                        PageProcessor pageProcessor = this_;
                        pageProcessor.pageFileStorage.setImageForId(bitmap2, var1_1.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
                        pageProcessor.pageFileStorage.setImageForId(bitmap3, var1_1.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
                        pageProcessor.pageFileStorage.removeFilteredPreviewImages(var1_1.getPageId());
                        uri.recycle();
                        bitmap2.recycle();
                        bitmap3.recycle();
                        if (bitmap != null) {
                            bitmap.recycle();
                        }
                        contourDetector2.dispose();
                        imageProcessor2.dispose();
                        List this_ = contourDetector2.getPolygonF();
                        Intrinsics.checkExpressionValueIsNotNull((Object)this_, (String)"detector.polygonF");
                        return Page.copy$default((Page)var1_1, null, this_, detectionResult, null, null, null, 0, 121, null);
                    }
                    throw new IOException("Unable to filter");
                }
                throw new IOException("Unable to filter");
            }
            return var1_1;
        }
        throw new IOException("Original image does not exists for this page.");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page rotate(@NotNull Page page, int times) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Uri uri = ((PageProcessor)this_).pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (new File(uri.getPath()).exists()) {
            Bitmap bitmap;
            void var1_1;
            ImageProcessor imageProcessor;
            int n2;
            PageProcessor pageProcessor = this_;
            n2 = pageProcessor.calculateRotationDegree(n2);
            ImageProcessor imageProcessor2 = imageProcessor;
            imageProcessor = new ImageProcessor();
            uri = MediaStore.Images.Media.getBitmap((ContentResolver)pageProcessor.context.getContentResolver(), (Uri)uri);
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"originalBitmap");
            ((PageProcessor)this_).rotateAndSavePageImage((Bitmap)uri, n2, var1_1.getPageId(), PageFileStorage.PageFileType.ORIGINAL, imageProcessor2);
            uri.recycle();
            uri = pageProcessor.pageFileStorage.getImageURI(var1_1.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
            if (new File(uri.getPath()).exists()) {
                bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)((PageProcessor)this_).context.getContentResolver(), (Uri)uri);
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"documentBitmap");
                ((PageProcessor)this_).rotateAndSavePageImage(bitmap, n2, var1_1.getPageId(), PageFileStorage.PageFileType.DOCUMENT, imageProcessor2);
                bitmap.recycle();
            }
            bitmap = ((PageProcessor)this_).pageFileStorage.getImageURI(var1_1.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
            if (new File(uri.getPath()).exists()) {
                uri = MediaStore.Images.Media.getBitmap((ContentResolver)((PageProcessor)this_).context.getContentResolver(), (Uri)bitmap);
                Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"unfilteredDocumentBitmap");
                ((PageProcessor)this_).rotateAndSavePageImage((Bitmap)uri, n2, var1_1.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT, imageProcessor2);
                uri.recycle();
            }
            ((PageProcessor)this_).pageFileStorage.removeFilteredPreviewImages(var1_1.getPageId());
            Object this_ = var1_1.getPolygon();
            if (this_.isEmpty() ^ true) {
                this_ = PolygonHelper.Companion.rotatePolygon(var1_1.getPolygon(), (float)n2);
            }
            imageProcessor2.dispose();
            return Page.copy$default((Page)var1_1, null, (List)this_, null, null, null, null, 0, 125, null);
        }
        throw new IOException("Original image does not exists for this page.");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page cropAndRotate(@NotNull Page page, int times, @NotNull List<? extends PointF> polygon) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
        String string = page.getPageId();
        Uri uri = this.pageFileStorage.getImageURI(string, PageFileStorage.PageFileType.ORIGINAL);
        if (new File(uri.getPath()).exists()) {
            RotateOperation rotateOperation;
            List list;
            CropOperation cropOperation;
            ImageProcessor imageProcessor;
            int n2;
            PageProcessor pageProcessor = this;
            n2 = pageProcessor.calculateRotationDegree(n2);
            uri = MediaStore.Images.Media.getBitmap((ContentResolver)pageProcessor.context.getContentResolver(), (Uri)uri);
            ImageProcessor imageProcessor2 = imageProcessor;
            Uri uri2 = uri;
            imageProcessor2();
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"originalBitmap");
            Object[] objectArray = new Operation[2];
            Operation operation = cropOperation;
            cropOperation = new CropOperation(list);
            objectArray[0] = operation;
            operation = rotateOperation;
            rotateOperation = new RotateOperation(n2);
            objectArray[1] = operation;
            operation = ImageProcessor.process$default(imageProcessor, (Bitmap)uri2, CollectionsKt.listOf((Object[])objectArray), false, 4, null);
            if (operation != null) {
                void var1_1;
                Bitmap bitmap = this.scaleBitmapIfNeeded((Bitmap)operation, var1_1.getDocumentImageSizeLimit());
                this.pageFileStorage.setImageForId(bitmap, string, PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
                bitmap.recycle();
                operation = this.cropApplyFiltersTunesFromPage(imageProcessor2, (Bitmap)uri, list, (Page)var1_1, n2);
                if (operation != null) {
                    Bitmap bitmap2 = this.scaleBitmapIfNeeded((Bitmap)operation, var1_1.getDocumentImageSizeLimit());
                    this.pageFileStorage.setImageForId(bitmap2, string, PageFileStorage.PageFileType.DOCUMENT);
                    bitmap2.recycle();
                    this.rotateAndSavePageImage((Bitmap)uri, n2, string, PageFileStorage.PageFileType.ORIGINAL, imageProcessor2);
                    uri.recycle();
                    this.pageFileStorage.removeFilteredPreviewImages(string);
                    if (list.isEmpty() ^ true) {
                        list = PolygonHelper.Companion.rotatePolygon(list, (float)n2);
                    }
                    imageProcessor2.dispose();
                    return Page.copy$default((Page)var1_1, null, list, null, null, null, null, 0, 125, null);
                }
                throw new IOException("Unable to filter");
            }
            throw new IOException("Unable to filter");
        }
        throw new IOException("Original image does not exists for this page.");
    }
}

