/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.net.Uri;
import android.provider.MediaStore;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.persistence.PolygonHelper;
import io.scanbot.sdk.process.ImageFilterType;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.bitmap.BitmapUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\rH\u0002J\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/scanbot/sdk/process/PageProcessor;", "", "context", "Landroid/content/Context;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "(Landroid/content/Context;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "applyFilter", "Lio/scanbot/sdk/persistence/Page;", "page", "filter", "Lio/scanbot/sdk/process/ImageFilterType;", "calculateRotationDegree", "", "times", "", "cropAndRotate", "polygon", "", "Landroid/graphics/PointF;", "detectDocument", "generateFilteredPreview", "Landroid/graphics/Bitmap;", "rotate", "rotateAndSavePageImage", "", "bitmap", "rotationDegree", "pageId", "", "pageType", "Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "rotateBitmap", "degree", "scaleBitmapIfNeeded", "imageSizeLimit", "Lio/scanbot/sdk/persistence/Page$Size;", "sdk-bundle_release"})
public final class PageProcessor {
    private Context context;
    private final PageFileStorage pageFileStorage;

    private final float calculateRotationDegree(int times) {
        return times * -1 * 90;
    }

    private final void rotateAndSavePageImage(Bitmap bitmap, float rotationDegree, String pageId, PageFileStorage.PageFileType pageType) {
        Bitmap bitmap2 = this.rotateBitmap(bitmap, rotationDegree);
        this.pageFileStorage.setImageForId(bitmap2, pageId, pageType);
        bitmap2.recycle();
    }

    private final Bitmap rotateBitmap(Bitmap bitmap3, float degree2) {
        Matrix matrix;
        Bitmap bitmap2 = bitmap3;
        PageProcessor this_ = matrix;
        this_();
        matrix.postRotate(degree2);
        int bitmap3 = bitmap2.getWidth();
        int degree2 = bitmap2.getHeight();
        Bitmap bitmap4 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap3, (int)degree2, (Matrix)this_, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"Bitmap.createBitmap(bitm\u2026ap.height, matrix, false)");
        return bitmap4;
    }

    /*
     * WARNING - void declaration
     */
    private final Bitmap scaleBitmapIfNeeded(Bitmap bitmap, Page.Size imageSizeLimit) {
        Bitmap bitmap2;
        void var2_2;
        if (imageSizeLimit.getHeight() != Integer.MAX_VALUE && var2_2.getWidth() != Integer.MAX_VALUE) {
            bitmap2 = BitmapUtils.scaleIfNeeded(bitmap2, var2_2.getWidth(), var2_2.getHeight());
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"BitmapUtils.scaleIfNeede\u2026h, imageSizeLimit.height)");
        }
        return bitmap2;
    }

    @Inject
    public PageProcessor(@NotNull Context context, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        this.context = context;
        this.pageFileStorage = pageFileStorage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page applyFilter(@NotNull Page page, @NotNull ImageFilterType filter) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Uri uri = this_.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (new File(uri.getPath()).exists()) {
            void var1_1;
            void var2_2;
            PageProcessor pageProcessor = this_;
            PageProcessor this_ = MediaStore.Images.Media.getBitmap((ContentResolver)pageProcessor.context.getContentResolver(), (Uri)uri);
            this_ = new ContourDetector().processImageF((Bitmap)this_, CollectionsKt.emptyList(), var2_2.getCode());
            PageFileStorage pageFileStorage = pageProcessor.pageFileStorage;
            Intrinsics.checkExpressionValueIsNotNull((Object)this_, (String)"filteredBitmap");
            pageFileStorage.setImageForId((Bitmap)this_, var1_1.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
            return Page.copy$default((Page)var1_1, null, null, null, (ImageFilterType)var2_2, null, 23, null);
        }
        throw new IOException("Unfiltered document image does not exists for this page.");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap generateFilteredPreview(@NotNull Page page, @NotNull ImageFilterType filter) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Uri uri = this_.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (new File(uri.getPath()).exists()) {
            void var1_1;
            void var2_2;
            PageProcessor pageProcessor = this_;
            PageProcessor this_ = MediaStore.Images.Media.getBitmap((ContentResolver)pageProcessor.context.getContentResolver(), (Uri)uri);
            this_ = new ContourDetector().processImageAndRelease((Bitmap)this_, CollectionsKt.emptyList(), var2_2.getCode());
            PageFileStorage pageFileStorage = pageProcessor.pageFileStorage;
            Intrinsics.checkExpressionValueIsNotNull((Object)this_, (String)"filteredBitmap");
            return pageFileStorage.generateAndSetFilteredPreviewForId((Bitmap)this_, var1_1.getPageId(), (ImageFilterType)var2_2);
        }
        throw new IOException("Unfiltered document image does not exists for this page.");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page detectDocument(@NotNull Page page) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Uri uri = ((PageProcessor)((Object)this_)).pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (new File(uri.getPath()).exists()) {
            void var1_1;
            ContourDetector contourDetector;
            uri = MediaStore.Images.Media.getBitmap((ContentResolver)((PageProcessor)((Object)this_)).context.getContentResolver(), (Uri)uri);
            ContourDetector contourDetector2 = contourDetector;
            contourDetector2();
            DetectionResult detectionResult = contourDetector.detect((Bitmap)uri);
            if (detectionResult != null) {
                Bitmap bitmap = contourDetector2.processImageF((Bitmap)uri, contourDetector2.getPolygonF(), var1_1.getFilter().getCode());
                if (var1_1.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && var1_1.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE) {
                    bitmap = BitmapUtils.scaleIfNeeded(bitmap, var1_1.getDocumentImageSizeLimit().getWidth(), var1_1.getDocumentImageSizeLimit().getHeight());
                    Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapUtils.scaleIfNeede\u2026entImageSizeLimit.height)");
                } else {
                    Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"documentBitmapBeforeScaling");
                }
                uri = var1_1.getFilter() != ImageFilterType.NONE ? contourDetector2.processImageF((Bitmap)uri, contourDetector2.getPolygonF(), ImageFilterType.NONE.getCode()) : bitmap;
                PageProcessor pageProcessor = this_;
                pageProcessor.pageFileStorage.setImageForId(bitmap, var1_1.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
                PageFileStorage pageFileStorage = pageProcessor.pageFileStorage;
                Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"unfilteredDocumentBitmap");
                pageFileStorage.setImageForId((Bitmap)uri, var1_1.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
                pageProcessor.pageFileStorage.removeFilteredPreviewImages(var1_1.getPageId());
                List this_ = contourDetector2.getPolygonF();
                Intrinsics.checkExpressionValueIsNotNull((Object)this_, (String)"detector.polygonF");
                return Page.copy$default((Page)var1_1, null, this_, detectionResult, null, null, 25, null);
            }
            return var1_1;
        }
        throw new IOException("Original image does not exists for this page.");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page rotate(@NotNull Page page, int times) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Uri uri = ((PageProcessor)((Object)this_)).pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (new File(uri.getPath()).exists()) {
            Bitmap bitmap;
            void var1_1;
            void var2_2;
            PageProcessor pageProcessor = this_;
            float f2 = pageProcessor.calculateRotationDegree((int)var2_2);
            uri = MediaStore.Images.Media.getBitmap((ContentResolver)pageProcessor.context.getContentResolver(), (Uri)uri);
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"originalBitmap");
            ((PageProcessor)((Object)this_)).rotateAndSavePageImage((Bitmap)uri, f2, var1_1.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
            uri.recycle();
            uri = pageProcessor.pageFileStorage.getImageURI(var1_1.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
            if (new File(uri.getPath()).exists()) {
                bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)((PageProcessor)((Object)this_)).context.getContentResolver(), (Uri)uri);
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"documentBitmap");
                ((PageProcessor)((Object)this_)).rotateAndSavePageImage(bitmap, f2, var1_1.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
                bitmap.recycle();
            }
            bitmap = ((PageProcessor)((Object)this_)).pageFileStorage.getImageURI(var1_1.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
            if (new File(uri.getPath()).exists()) {
                uri = MediaStore.Images.Media.getBitmap((ContentResolver)((PageProcessor)((Object)this_)).context.getContentResolver(), (Uri)bitmap);
                Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"unfilteredDocumentBitmap");
                ((PageProcessor)((Object)this_)).rotateAndSavePageImage((Bitmap)uri, f2, var1_1.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
                uri.recycle();
            }
            ((PageProcessor)((Object)this_)).pageFileStorage.removeFilteredPreviewImages(var1_1.getPageId());
            List<PointF> this_ = var1_1.getPolygon();
            if (this_.isEmpty() ^ true) {
                this_ = PolygonHelper.Companion.rotatePolygon(var1_1.getPolygon(), f2);
            }
            return Page.copy$default((Page)var1_1, null, this_, null, null, null, 29, null);
        }
        throw new IOException("Original image does not exists for this page.");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page cropAndRotate(@NotNull Page page, int times, @NotNull List<? extends PointF> polygon) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
        String string = page.getPageId();
        Uri uri = this.pageFileStorage.getImageURI(string, PageFileStorage.PageFileType.ORIGINAL);
        if (new File(uri.getPath()).exists()) {
            void var1_1;
            List<PointF> list;
            ContourDetector contourDetector;
            void var2_2;
            PageProcessor pageProcessor = this;
            float f2 = pageProcessor.calculateRotationDegree((int)var2_2);
            uri = MediaStore.Images.Media.getBitmap((ContentResolver)pageProcessor.context.getContentResolver(), (Uri)uri);
            PageProcessor pageProcessor2 = this;
            ContourDetector contourDetector2 = contourDetector;
            PageProcessor pageProcessor3 = this;
            contourDetector2();
            Bitmap bitmap = contourDetector2.processImageF((Bitmap)uri, (List)list, ImageFilterType.NONE.getCode());
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"unfilteredDocumentBitmap");
            Bitmap bitmap2 = pageProcessor3.scaleBitmapIfNeeded(pageProcessor3.rotateBitmap(bitmap, f2), var1_1.getDocumentImageSizeLimit());
            this.pageFileStorage.setImageForId(bitmap2, string, PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
            bitmap2.recycle();
            Bitmap bitmap3 = contourDetector.processImageF((Bitmap)uri, (List)list, var1_1.getFilter().getCode());
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"documentBitmap");
            Bitmap bitmap4 = pageProcessor2.scaleBitmapIfNeeded(pageProcessor2.rotateBitmap(bitmap3, f2), var1_1.getDocumentImageSizeLimit());
            this.pageFileStorage.setImageForId(bitmap4, string, PageFileStorage.PageFileType.DOCUMENT);
            bitmap4.recycle();
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"originalBitmap");
            this.rotateAndSavePageImage((Bitmap)uri, f2, string, PageFileStorage.PageFileType.ORIGINAL);
            uri.recycle();
            pageProcessor.pageFileStorage.removeFilteredPreviewImages(string);
            if (list.isEmpty() ^ true) {
                list = PolygonHelper.Companion.rotatePolygon((List<? extends PointF>)list, f2);
            }
            return Page.copy$default((Page)var1_1, null, list, null, null, null, 29, null);
        }
        throw new IOException("Original image does not exists for this page.");
    }
}

