/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.text.TextUtils;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.doo.snap.R;

@Singleton
public class CameraConfiguration {
    private List<String> supportedFlashModes;
    private List<String> supportedFocusModes;
    private List<Integer> supportedPreviewFormats;
    private List<Integer> supportedPictureFormats;
    private List<Camera.Size> supportedPreviewSizes;
    private List<Camera.Size> supportedPictureSizes;
    private boolean isConigured = false;

    @Inject
    public CameraConfiguration() {
    }

    /*
     * WARNING - void declaration
     */
    private String joinSizes(String separator, List<Camera.Size> sizes) {
        Object this_ = "";
        for (Camera.Size size : sizes) {
            if (!((String)this_).isEmpty()) {
                void var1_1;
                this_ = (String)this_ + (String)var1_1;
            }
            this_ = (String)this_ + size.width + "x" + size.height;
        }
        return this_;
    }

    public void loadCameraParameters(Camera.Parameters parameters) {
        CameraConfiguration cameraConfiguration = this;
        this.supportedFlashModes = parameters.getSupportedFlashModes();
        this.supportedFocusModes = parameters.getSupportedFocusModes();
        this.supportedPreviewFormats = parameters.getSupportedPreviewFormats();
        this.supportedPictureFormats = parameters.getSupportedPictureFormats();
        this.supportedPreviewSizes = parameters.getSupportedPreviewSizes();
        cameraConfiguration.supportedPictureSizes = parameters.getSupportedPictureSizes();
        cameraConfiguration.isConigured = true;
    }

    public List<String> getSupportedFlashModes() {
        return this.supportedFlashModes;
    }

    public List<String> getSupportedFocusModes() {
        return this.supportedFocusModes;
    }

    public List<Integer> getSupportedPreviewFormats() {
        return this.supportedPreviewFormats;
    }

    public List<Integer> getSupportedPictureFormats() {
        return this.supportedPictureFormats;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        return this.supportedPreviewSizes;
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        return this.supportedPictureSizes;
    }

    public boolean isConigured() {
        return this.isConigured;
    }

    /*
     * WARNING - void declaration
     */
    public String toString(Context context) {
        CharSequence charSequence = context.getString(R.string.D, new Object[]{Build.PRODUCT, Build.DEVICE, Build.BOARD, Build.HARDWARE, Build.MANUFACTURER, Build.BRAND, Build.MODEL, Build.HARDWARE, Build.SERIAL, Build.FINGERPRINT});
        if (((CameraConfiguration)this_).isConigured) {
            void var1_1;
            Object this_;
            charSequence = new StringBuilder().append((String)charSequence);
            int n2 = R.string.C;
            Object[] objectArray = new Object[6];
            int n3 = 0;
            String string2 = ((CameraConfiguration)this_).getSupportedFlashModes() == null ? "" : TextUtils.join((CharSequence)", ", ((CameraConfiguration)this_).getSupportedFlashModes());
            objectArray[n3] = string2;
            n3 = 1;
            string2 = ((CameraConfiguration)this_).getSupportedFocusModes() == null ? "" : TextUtils.join((CharSequence)", ", ((CameraConfiguration)this_).getSupportedFocusModes());
            objectArray[n3] = string2;
            n3 = 2;
            string2 = ((CameraConfiguration)this_).getSupportedPreviewFormats() == null ? "" : TextUtils.join((CharSequence)", ", ((CameraConfiguration)this_).getSupportedPreviewFormats());
            objectArray[n3] = string2;
            n3 = 3;
            string2 = ((CameraConfiguration)this_).getSupportedPictureFormats() == null ? "" : TextUtils.join((CharSequence)", ", ((CameraConfiguration)this_).getSupportedPictureFormats());
            objectArray[n3] = string2;
            n3 = 4;
            if (((CameraConfiguration)this_).getSupportedPreviewSizes() == null) {
                string2 = "";
            } else {
                CameraConfiguration cameraConfiguration = this_;
                string2 = cameraConfiguration.joinSizes(", ", cameraConfiguration.getSupportedPreviewSizes());
            }
            objectArray[n3] = string2;
            n3 = 5;
            if (((CameraConfiguration)this_).getSupportedPictureSizes() == null) {
                this_ = "";
            } else {
                CameraConfiguration cameraConfiguration = this_;
                this_ = cameraConfiguration.joinSizes(", ", cameraConfiguration.getSupportedPictureSizes());
            }
            objectArray[n3] = this_;
            charSequence = ((StringBuilder)charSequence).append(var1_1.getString(n2, objectArray)).toString();
        }
        return charSequence;
    }
}

