/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import net.doo.snap.util.CursorUtil;

public class FileChooserUtils {
    private static final String CONTENT_SCHEME = "content";
    private static final String FILE_SCHEME = "file";
    private static final String EXTERNALSTORAGE_AUTHORITY = "com.android.externalstorage.documents";
    private static final String DOWNLOADS_AUTHORITY = "com.android.providers.downloads.documents";
    private static final String MEDIA_AUTHORITY = "com.android.providers.media.documents";
    private static final String PUBLIC_DOWNLOADS_LINK = "content://downloads/public_downloads";

    @SuppressLint(value={"NewApi"})
    public static String getPath(Context context, Uri uri) {
        String[] stringArray;
        String[] stringArray2;
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)stringArray2, (Uri)stringArray)) {
            if (FileChooserUtils.isExternalStorageDocument((Uri)stringArray)) {
                stringArray2 = DocumentsContract.getDocumentId((Uri)stringArray).split(":");
                if ("primary".equalsIgnoreCase(stringArray2[0])) {
                    return Environment.getExternalStorageDirectory() + "/" + stringArray2[1];
                }
            } else {
                if (FileChooserUtils.isDownloadsDocument((Uri)stringArray)) {
                    return FileChooserUtils.getDataColumn((Context)stringArray2, ContentUris.withAppendedId((Uri)Uri.parse((String)PUBLIC_DOWNLOADS_LINK), (long)Long.valueOf(DocumentsContract.getDocumentId((Uri)stringArray))), null, null);
                }
                if (FileChooserUtils.isMediaDocument((Uri)stringArray)) {
                    stringArray = DocumentsContract.getDocumentId((Uri)stringArray).split(":");
                    Uri uri2 = null;
                    if ("image".equals(stringArray[0])) {
                        uri2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    }
                    String[] stringArray3 = stringArray2;
                    String[] stringArray4 = new String[1];
                    stringArray2 = stringArray4;
                    stringArray4[0] = stringArray[1];
                    return FileChooserUtils.getDataColumn((Context)stringArray3, uri2, "_id=?", stringArray2);
                }
            }
        } else {
            if (CONTENT_SCHEME.equalsIgnoreCase(stringArray.getScheme())) {
                return FileChooserUtils.getDataColumn((Context)stringArray2, (Uri)stringArray, null, null);
            }
            if (FILE_SCHEME.equalsIgnoreCase(stringArray.getScheme())) {
                return stringArray.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        void var3_4;
        void var2_3;
        Context context2;
        void var1_1;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_data";
        if (context == null) {
            return var1_1.getPath();
        }
        if ((context2 = context2.getContentResolver()) == null) {
            return var1_1.getPath();
        }
        if ((context2 = context2.query((Uri)var1_1, stringArray2, (String)var2_3, (String[])var3_4, null)) != null) {
            Context context3 = context2;
            int n2 = context3.getColumnIndexOrThrow("_data");
            context3.moveToFirst();
            String string2 = context3.getString(n2);
            CursorUtil.closeQuietly((Cursor)context2);
            return string2;
        }
        return var1_1.getPath();
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return EXTERNALSTORAGE_AUTHORITY.equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return DOWNLOADS_AUTHORITY.equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return MEDIA_AUTHORITY.equals(uri.getAuthority());
    }
}

