/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.utils.PolygonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.R;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ContourDetectorFrameHandler
implements PreviewBuffer.FrameHandler {
    private final ContourDetector contourDetector;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    protected final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private final int finderInnerThresholdPx;
    private final int finderOuterThresholdPx;
    protected boolean enabled = true;
    private List<PageAspectRatio> requiredPageAspectRatios = null;

    public static ContourDetectorFrameHandler attach(ScanbotCameraView cameraView) {
        ScanbotCameraView scanbotCameraView;
        ContourDetectorFrameHandler contourDetectorFrameHandler;
        ContourDetectorFrameHandler contourDetectorFrameHandler2 = contourDetectorFrameHandler;
        contourDetectorFrameHandler2(scanbotCameraView.getContext());
        scanbotCameraView.getPreviewBuffer().addFrameHandler((PreviewBuffer.FrameHandler)contourDetectorFrameHandler2);
        return contourDetectorFrameHandler;
    }

    /*
     * WARNING - void declaration
     */
    public ContourDetectorFrameHandler(Context context) {
        void var1_1;
        this.contourDetector = new ScanbotSDK((Context)var1_1).contourDetector();
        this.sapManager = SapSingleton.getInstance();
        this.finderInnerThresholdPx = var1_1.getResources().getDimensionPixelSize(R.dimen.default_finder_inner_threshold);
        this.finderOuterThresholdPx = var1_1.getResources().getDimensionPixelSize(R.dimen.default_finder_outer_threshold);
    }

    /*
     * WARNING - void declaration
     */
    private DetectionResult detectOffCenter(PreviewBuffer.FrameHandler.Frame previewFrame, DetectionResult detectionResult, List<PointF> polygon) {
        DetectionResult detectionResult2;
        Rect rect = previewFrame.finderRect;
        if (!(rect == null || rect.isEmpty() || detectionResult2 != DetectionResult.OK && detectionResult2 != DetectionResult.OK_BUT_BAD_ASPECT_RATIO && detectionResult2 != DetectionResult.OK_BUT_TOO_SMALL && detectionResult2 != DetectionResult.OK_BUT_BAD_ANGLES)) {
            Rect rect2;
            void var1_1;
            List list;
            list = PolygonHelper.rotatePolygon((List)list, (float)var1_1.frameOrientation);
            int n2 = var1_1.frameOrientation % 180 == 0 ? 1 : 0;
            int n3 = n2 != 0 ? var1_1.width : var1_1.height;
            n2 = n2 != 0 ? var1_1.height : var1_1.width;
            Rect rect3 = rect2;
            List list2 = list;
            float f2 = n3;
            n3 = (int)(((PointF)list2.get((int)0)).x * f2);
            float f3 = n2;
            int n4 = (int)(((PointF)list2.get((int)0)).y * f3);
            int n5 = (int)(((PointF)list2.get((int)2)).x * f2);
            int n6 = (int)(((PointF)list2.get((int)2)).y * f3);
            rect2 = new Rect(n3, n4, n5, n6);
            if (this.checkOuterThreshold(var1_1.finderRect, rect3)) {
                detectionResult2 = DetectionResult.OK_OFF_CENTER;
            } else if (!this.requiredPageAspectRatios.isEmpty() && this.checkInnerThreshold(var1_1.finderRect, rect3)) {
                detectionResult2 = DetectionResult.OK_BUT_TOO_SMALL;
            }
        }
        return detectionResult2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkInnerThreshold(Rect finderRect, Rect polygonRect) {
        void var2_3;
        void var1_2;
        int n2 = this.finderInnerThresholdPx;
        return polygonRect.left - var1_2.left > n2 || var2_3.top - var1_2.top > n2 || var1_2.bottom - var2_3.bottom > n2 || var1_2.right - var2_3.right > n2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkOuterThreshold(Rect finderRect, Rect polygonRect) {
        void var1_2;
        void var2_3;
        int n2 = this.finderOuterThresholdPx;
        return finderRect.left - var2_3.left > n2 || var1_2.top - var2_3.top > n2 || var2_3.bottom - var1_2.bottom > n2 || var2_3.right - var1_2.right > n2;
    }

    /*
     * WARNING - void declaration
     */
    private void setRectOfInterest(int frameOrientation, RectF visibleRect) {
        if (visibleRect != null) {
            void var2_2;
            void var1_1;
            Matrix matrix;
            ContourDetectorFrameHandler contourDetectorFrameHandler = contourDetectorFrameHandler2;
            ContourDetectorFrameHandler contourDetectorFrameHandler2 = matrix;
            contourDetectorFrameHandler2();
            contourDetectorFrameHandler2.setRotate((float)var1_1, 0.5f, 0.5f);
            matrix.mapRect((RectF)var2_2);
            contourDetectorFrameHandler.contourDetector.setRectOfInterest((RectF)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fixRequiredAspectRatios(int frameOrientation) {
        ArrayList<PageAspectRatio> arrayList = this.requiredPageAspectRatios;
        if (arrayList != null && !arrayList.isEmpty()) {
            ArrayList<PageAspectRatio> arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<PageAspectRatio>();
            for (PageAspectRatio pageAspectRatio : this.requiredPageAspectRatios) {
                double d2;
                double d3;
                PageAspectRatio pageAspectRatio2;
                void var1_1;
                if (var1_1 % 180 == false) {
                    PageAspectRatio pageAspectRatio3;
                    pageAspectRatio2 = pageAspectRatio3;
                    PageAspectRatio pageAspectRatio4 = pageAspectRatio;
                    d3 = pageAspectRatio4.width;
                    d2 = pageAspectRatio4.height;
                    pageAspectRatio3 = new PageAspectRatio(d3, d2);
                } else {
                    PageAspectRatio pageAspectRatio5;
                    pageAspectRatio2 = pageAspectRatio5;
                    PageAspectRatio pageAspectRatio6 = pageAspectRatio;
                    d3 = pageAspectRatio6.height;
                    d2 = pageAspectRatio6.width;
                    pageAspectRatio5 = new PageAspectRatio(d3, d2);
                }
                arrayList.add(pageAspectRatio2);
            }
            this.contourDetector.setRequiredAspectRatios(arrayList);
        }
    }

    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame previewFrame) {
        DetectedFrame detectedFrame;
        SdkLicenseError sdkLicenseError;
        ContourDetectorFrameHandler contourDetectorFrameHandler = this_;
        contourDetectorFrameHandler.logger.logMethod();
        if (!contourDetectorFrameHandler.enabled) {
            return false;
        }
        if (!this_.sapManager.checkLicenseStatus(SdkFeature.EdgeDetection).booleanValue()) {
            SdkLicenseError sdkLicenseError2;
            FrameHandlerResult.Failure failure;
            ContourDetectorFrameHandler contourDetectorFrameHandler2 = this_;
            ContourDetectorFrameHandler this_ = failure;
            sdkLicenseError = sdkLicenseError2;
            sdkLicenseError2 = new SdkLicenseError();
            failure = new FrameHandlerResult.Failure((Object)sdkLicenseError);
            contourDetectorFrameHandler2.notifyHandlers((FrameHandlerResult<DetectedFrame, SdkLicenseError>)this_);
            return false;
        }
        ContourDetectorFrameHandler contourDetectorFrameHandler3 = this_;
        ContourDetectorFrameHandler contourDetectorFrameHandler4 = this_;
        SdkLicenseError sdkLicenseError3 = sdkLicenseError;
        this_.fixRequiredAspectRatios(sdkLicenseError.frameOrientation);
        int n2 = sdkLicenseError3.frameOrientation;
        contourDetectorFrameHandler4.setRectOfInterest(n2, sdkLicenseError3.visibleRect);
        SdkLicenseError sdkLicenseError4 = sdkLicenseError;
        Object object = sdkLicenseError4.frame;
        int n3 = sdkLicenseError4.width;
        int n4 = sdkLicenseError4.height;
        object = contourDetectorFrameHandler4.contourDetector.detect(object, n3, n4);
        List list = contourDetectorFrameHandler4.contourDetector.getPolygonF();
        object = contourDetectorFrameHandler3.detectOffCenter((PreviewBuffer.FrameHandler.Frame)sdkLicenseError, (DetectionResult)object, list);
        DetectedFrame detectedFrame2 = detectedFrame;
        SdkLicenseError sdkLicenseError5 = sdkLicenseError;
        int n5 = sdkLicenseError5.frameOrientation;
        int n6 = sdkLicenseError5.width;
        int n7 = sdkLicenseError5.height;
        double d2 = this_.contourDetector.getDetectionScore();
        Rect rect = sdkLicenseError.finderRect;
        List<PageAspectRatio> list2 = this_.requiredPageAspectRatios;
        detectedFrame = new DetectedFrame((DetectionResult)object, list, n5, n6, n7, d2, rect, list2);
        return contourDetectorFrameHandler3.notifyHandlers((FrameHandlerResult<DetectedFrame, SdkLicenseError>)new FrameHandlerResult.Success((Object)detectedFrame2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            void var1_1;
            this.handlers.add((ResultHandler)var1_1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            void var1_1;
            this.handlers.remove(var1_1);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnabled(boolean enabled) {
        void var1_1;
        this.enabled = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        void var1_1;
        if (!(acceptedAngleScore < 0.0) && !(var1_1 > 100.0)) {
            this.contourDetector.setAcceptedAngleScore((double)var1_1);
            return;
        }
        throw new IllegalArgumentException("Invalid acceptedAngleScore value.");
    }

    /*
     * WARNING - void declaration
     */
    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        void var1_1;
        if (!(acceptedSizeScore < 0.0) && !(var1_1 > 100.0)) {
            this.contourDetector.setAcceptedSizeScore((double)var1_1);
            return;
        }
        throw new IllegalArgumentException("Invalid acceptedSizeScore value.");
    }

    /*
     * WARNING - void declaration
     */
    public final void setRequiredAspectRatios(List<PageAspectRatio> requiredPageAspectRatios) {
        void var1_1;
        this.requiredPageAspectRatios = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected boolean notifyHandlers(FrameHandlerResult<DetectedFrame, SdkLicenseError> result) {
        ContourDetectorFrameHandler contourDetectorFrameHandler = this;
        boolean bl = false;
        Set<ResultHandler> set = contourDetectorFrameHandler.handlers;
        synchronized (set) {
            Iterator<ResultHandler> iterator = contourDetectorFrameHandler.handlers.iterator();
            while (true) {
                void var1_2;
                if (!iterator.hasNext()) break;
                bl |= iterator.next().handle((FrameHandlerResult)var1_2);
                continue;
                break;
            }
            return bl;
        }
    }

    public static class DetectedFrame {
        public final DetectionResult detectionResult;
        public final List<PointF> polygon;
        public final int frameOrientation;
        public final int frameWidth;
        public final int frameHeight;
        public final double detectionScore;
        public final Rect finderRect;
        public final List<PageAspectRatio> requiredPageAspectRatios;

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public DetectedFrame(DetectionResult detectionResult, List<PointF> polygon, int frameOrientation, int frameWidth, int frameHeight) {
            void var2_2;
            void var5_5;
            void var4_4;
            void var3_3;
            void var1_1;
            DetectedFrame detectedFrame = this;
            this.detectionResult = var1_1;
            this.frameOrientation = var3_3;
            this.frameWidth = var4_4;
            this.frameHeight = var5_5;
            detectedFrame.polygon = Collections.unmodifiableList(var2_2);
            detectedFrame.detectionScore = 0.0;
            detectedFrame.finderRect = null;
            detectedFrame.requiredPageAspectRatios = null;
        }

        /*
         * WARNING - void declaration
         */
        public DetectedFrame(DetectionResult detectionResult, List<PointF> polygon, int frameOrientation, int frameWidth, int frameHeight, double detectionScore, Rect finderRect, List<PageAspectRatio> requiredPageAspectRatios) {
            void var9_8;
            void var8_7;
            void var6_6;
            void var2_2;
            void var5_5;
            void var4_4;
            void var3_3;
            void var1_1;
            this.detectionResult = var1_1;
            this.frameOrientation = var3_3;
            this.frameWidth = var4_4;
            this.frameHeight = var5_5;
            this.polygon = Collections.unmodifiableList(var2_2);
            this.detectionScore = var6_6;
            this.finderRect = var8_7;
            this.requiredPageAspectRatios = var9_8;
        }
    }

    public static interface ResultHandler
    extends BaseResultHandler<DetectedFrame, SdkLicenseError> {
    }
}

