/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.snap;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.lib.detector.Line2D;

public class PolygonHelper {
    private static final int MIN_EDGE_LENGTH_PX = 35;
    private float[] tmpPoints = new float[8];
    private Matrix matrix = new Matrix();
    private int width;
    private int height;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int rotation = 0;

    public static boolean checkPolygonSize(List<Point> polygon) {
        List<Point> list;
        return !polygon.isEmpty() && Math.abs(list.get((int)1).x - list.get((int)0).x) > 35 && Math.abs(list.get((int)2).x - list.get((int)3).x) > 35 && Math.abs(list.get((int)3).y - list.get((int)0).y) > 35 && Math.abs(list.get((int)2).y - list.get((int)1).y) > 35;
    }

    /*
     * WARNING - void declaration
     */
    public void setRotation(int degrees) {
        void var1_1;
        if (this.rotation == var1_1) {
            return;
        }
        this.rotation = var1_1;
        this.matrix.setRotate((float)var1_1, 0.5f, 0.5f);
    }

    /*
     * WARNING - void declaration
     */
    public void setImageSize(int width, int height) {
        void var2_2;
        void var1_1;
        PolygonHelper polygonHelper = this;
        polygonHelper.width = var1_1;
        polygonHelper.height = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setLayout(int left, int top, int right, int bottom) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.left = var1_1;
        this.top = var2_2;
        this.right = var3_3;
        this.bottom = var4_4;
        this.width = var3_3 - var1_1;
        this.height = var4_4 - var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void polygonToLinePoints(List<PointF> polygon, float[] points) {
        int n2;
        void var1_1;
        int n3;
        for (n3 = 0; n3 < var1_1.size(); ++n3) {
            PolygonHelper polygonHelper = this;
            int n4 = n3;
            n2 = n4 * 2;
            polygonHelper.tmpPoints[n2] = ((PointF)var1_1.get((int)n4)).x;
            polygonHelper.tmpPoints[++n2] = ((PointF)var1_1.get((int)n3)).y;
        }
        this.matrix.mapPoints(this.tmpPoints);
        for (n3 = 0; n3 < var1_1.size(); ++n3) {
            void var2_2;
            void v2 = var2_2;
            n2 = n3 * 4;
            int n5 = this.left;
            int n6 = this.width;
            float[] fArray = this.tmpPoints;
            int n7 = n3 * 2;
            var2_2[n2] = (float)n5 + (float)n6 * this.tmpPoints[n7];
            int n8 = n2 + 1;
            int n9 = this.top;
            int n10 = n8;
            n8 = this.height;
            v2[n10] = (float)n9 + (float)n8 * fArray[n7 + 1];
            v2[n2 + 2] = (float)n5 + (float)n6 * fArray[(n7 + 2) % 8];
            v2[n2 + 3] = (float)n9 + (float)n8 * fArray[(n7 + 3) % 8];
        }
    }

    /*
     * WARNING - void declaration
     */
    public void polygonToPoints(List<PointF> polygon, float[] points) {
        int n2;
        void var1_1;
        int n3;
        for (n3 = 0; n3 < var1_1.size(); ++n3) {
            PolygonHelper polygonHelper = this;
            int n4 = n3;
            n2 = n4 * 2;
            polygonHelper.tmpPoints[n2] = ((PointF)var1_1.get((int)n4)).x;
            polygonHelper.tmpPoints[++n2] = ((PointF)var1_1.get((int)n3)).y;
        }
        this.matrix.mapPoints(this.tmpPoints);
        for (n3 = 0; n3 < var1_1.size(); ++n3) {
            void var2_2;
            void v2 = var2_2;
            n2 = n3 * 2;
            float[] fArray = this.tmpPoints;
            v2[n2] = (float)this.left + (float)this.width * this.tmpPoints[n2];
            v2[++n2] = (float)this.top + (float)this.height * fArray[n2];
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getDrawingPolygon(List<PointF> polygon, List<PointF> drawingPolygon) {
        void var2_2;
        for (int i2 = 0; i2 < var2_2.size(); ++i2) {
            void var1_1;
            PointF pointF = (PointF)var1_1.get(i2);
            PointF pointF2 = (PointF)var2_2.get(i2);
            pointF2.x = pointF.x * (float)this.width;
            pointF2.y = pointF.y * (float)this.height;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getPolygonFromDrawingPolygon(List<PointF> drawingPolygon, List<PointF> polygon) {
        void var1_1;
        for (int i2 = 0; i2 < var1_1.size(); ++i2) {
            void var2_2;
            PointF pointF = (PointF)var2_2.get(i2);
            PointF pointF2 = (PointF)var1_1.get(i2);
            pointF.x = pointF2.x / (float)this.width;
            pointF.y = pointF2.y / (float)this.height;
        }
    }

    public List<Line2D> scaleLines(List<Line2D> lines) {
        ArrayList<Line2D> arrayList;
        ArrayList<Line2D> arrayList2 = arrayList;
        arrayList = new ArrayList<Line2D>();
        for (Line2D line2D : lines) {
            line2D.getStart().x = (float)this.left + (float)this.width * line2D.getStart().x;
            line2D.getStart().y = (float)this.top + (float)this.height * line2D.getStart().y;
            line2D.getEnd().x = (float)this.left + (float)this.width * line2D.getEnd().x;
            line2D.getEnd().y = (float)this.top + (float)this.height * line2D.getEnd().y;
            arrayList2.add(line2D);
        }
        return arrayList2;
    }

    public static class Line {
        private double a;
        private double b;
        private double c;
        private PointF intersectionPoint;

        public Line() {
            PointF pointF;
            Line this_ = pointF;
            pointF = new PointF();
            v1.intersectionPoint = this_;
        }

        /*
         * WARNING - void declaration
         */
        public PointF getIntersectionPoint(Line line) {
            void var1_2;
            PointF pointF = this.intersectionPoint;
            Line line2 = this;
            double d2 = line2.c;
            double d3 = var1_2.b;
            double d4 = d2 * d3;
            double d5 = line2.b;
            double d6 = var1_2.c;
            double d7 = var1_2.a;
            double d8 = d5 * d7;
            double d9 = line2.a;
            pointF.x = (float)((d4 -= d5 * d6) / (d8 - d9 * d3));
            pointF.y = (float)((d9 * d6 - d2 * d7) / (d5 * d7 - d9 * d3));
            return pointF;
        }

        /*
         * WARNING - void declaration
         */
        public void calculateLine(PointF start, PointF end) {
            void var2_3;
            void var1_1;
            float f2 = var1_1.y;
            float f3 = var2_3.y;
            this.a = f2 - f3;
            float f4 = var2_3.x;
            float f5 = var1_1.x;
            this.b = f4 - f5;
            this.c = (f5 - f4) * f2 + (f3 - f2) * f5;
        }

        /*
         * WARNING - void declaration
         */
        public double getDistanceToPoint(PointF point) {
            void var1_1;
            if (this.a == 0.0 && this.b == 0.0) {
                return 0.0;
            }
            double d2 = this.a;
            double d3 = this.b;
            return Math.abs(this.a * (double)var1_1.x + this.b * (double)var1_1.y + this.c) / Math.sqrt(d2 * d2 + d3 * d3);
        }
    }

    public static class Edge {
        public PointF pointA;
        public PointF pointB;
        public PointF pointFarA;
        public PointF pointFarB;
        public Line edgeLine;
        public Line lineA;
        public Line lineB;
        private PointF handle;
        public float prevX;
        public float prevY;
        public boolean isDetectedLine;

        public Edge() {
            PointF pointF;
            Line line;
            Line line2;
            Line line3;
            Object this_ = line3;
            line3 = new Line();
            v1.edgeLine = this_;
            this_ = line2;
            line2 = new Line();
            v1.lineA = this_;
            this_ = line;
            line = new Line();
            v1.lineB = this_;
            this_ = pointF;
            pointF = new PointF();
            v1.handle = this_;
            v1.isDetectedLine = false;
        }

        public float getAngleInDegrees() {
            PointF pointF = this_.pointB;
            Edge this_ = this_.pointA;
            float f2 = pointF.x - ((PointF)this_).x;
            return (float)(Math.toDegrees(Math.atan2(pointF.y - ((PointF)this_).y, f2)) + 90.0);
        }

        public PointF getHandle() {
            PointF pointF = this_.pointA;
            Edge this_ = this_.pointB;
            this_.handle.x = (pointF.x + ((PointF)this_).x) / 2.0f;
            this_.handle.y = (pointF.y + ((PointF)this_).y) / 2.0f;
            return this_.handle;
        }

        public boolean isHorizontal() {
            PointF pointF = this_.pointB;
            Edge this_ = this_.pointA;
            float f2 = pointF.y - ((PointF)this_).y;
            return Math.abs(pointF.x - ((PointF)this_).x) > Math.abs(f2);
        }
    }
}

